# xspin
# Dataflow option

set d_runs 0

proc dataflow {} {
	global d_runs

	if {$d_runs > 0} { return };	# not foolproof, but close enough
	set d_runs 1

	add_log "<dataflow option>"
	add_log "spin -D pan.in"; update
	set fd [open pan.in w]
	puts $fd "[.inp.t get 0.0 end]" nonewline
	flush $fd
	catch "close $fd"

	add_log "1. (Write) -> Write/None"; update
	.inp.t tag remove hilite 0.0 end
	set fd [open "|spin -D pan.in" w+]
	while {[gets $fd line] > -1} {
		set mtch [scan $line "%s %d: %s" fnm lno varnm]
		if {$mtch == 3} {
			src_line $lno
		}
		set k [string last ":" $line]; incr k
		set line [string range $line $k end]
		add_log "line $lno: $line"
	}
	add_log "spin -D -D pan.in"; update
	add_log "2. (Read) -> Write/None"; update
	set fd [open "|spin -D -D pan.in" w+]
	while {[gets $fd line] > -1} {
		set mtch [scan $line "%s %d: %s" fnm lno varnm]
		if {$mtch == 3} {
			src_line $lno
		}
		set k [string last ":" $line]; incr k
		set line [string range $line $k end]
		add_log "line $lno: $line"
	}
	add_log "<done>"; update
	set d_runs 0
}
