# xspin
# validation options panel

set an_typ -1;	set cyc_typ 0
set ct_typ 0;	set et_typ 1
set oct_typ -1;	# remembers last setting used for compilation
set nv_typ 1
set po_typ 1;	set vb_typ 0
set pr_typ 0;	set where 0
set ur_typ 1;	set vbox 0
set killed 0;	set Job_Done 0;	set tcnt 0
set waitwhat "none"

set e(0)	"Maximum Memory Usage (Mbytes): "
set ival(0)	32

set e(1)	"Estimated State Space Size (states x 10^3): "
set ival(1)	500

set e(2)	"Maximum Search Depth (steps): "
set ival(2)	10000

set e(3)	"Extra Compile-Time Directives (Optional): "
set ival(3)	""

set LastGenerate	""
set LastCompile	""
set NextCompile	""

proc validation {} {
	global e;	global ival
	global an_typ;	global nv_typ
	global cyc_typ;	global ct_typ
	global et_typ;	global stop
	global vb_typ pr_typ ur_typ

	set stop 0

	catch {destroy .v}
	toplevel .v

	wm title .v "Validation Options"
	wm iconname .v "VAL"
	wm geometry .v +150+150
#	wm minsize  .v 400 200

	frame .v.pan -relief flat

	# Initialize Sliders

	frame .v.memopts -relief flat;				# memory options panel
	frame .v.correct -relief flat;				# correctness properties
	frame .v.oframe  -relief raised -borderwidth 1m;	# error trail options
	frame .v.recomp  -relief raised -borderwidth 1m;	# recompilation control
	frame .v.mesg -relief raised -borderwidth 1m;		# queue loss options
	frame .v.cframe  -relief raised -borderwidth 1m;	# compile time options

	if {$an_typ == -1} {
		set an_typ 0
		set nv_typ [hasWord "never"]
		if {$nv_typ == 1} {
			if {[hasWord "accept.*:"]} {
				set an_typ 2
			}
		} elseif {[hasWord "progress.*:"]} {
				set an_typ 1
		}
	}

	for {set x 0} {$x<=3} {incr x} {
		global e
		global ival

		frame .v.memopts.choice$x -relief flat
		entry .v.memopts.choice$x.e1 -relief sunken -width 35
		label .v.memopts.choice$x.e2 -text $e($x) -relief flat
		.v.memopts.choice$x.e1 insert end $ival($x)

		pack append .v.memopts.choice$x \
			.v.memopts.choice$x.e2 {left  frame w fillx} \
			.v.memopts.choice$x.e1 {right frame e fillx}

		pack append .v.memopts \
			.v.memopts.choice$x { top frame w pady 5 fillx}
	}
	set z .v.correct

	frame $z.rframe  -relief raised -borderwidth 1m

	label $z.rframe.lb \
		-font -Adobe-Helvetica-Bold-R-Normal-*-120-* \
		-text "Correctness Properties" \
		-relief sunken -borderwidth 1m
	radiobutton $z.rframe.sp -text "State Properties (Safety)" \
		-variable an_typ -value 0 \
		-relief flat \
		-command { set cyc_typ 0 }
	radiobutton $z.rframe.np -text "Non-Progress Cycles (Liveness)" \
		-variable an_typ -value 1 \
		-relief flat 
	radiobutton $z.rframe.ac -text "Acceptance Cycles (Liveness)" \
		-variable an_typ -value 2 \
		-relief flat \
		-command { if {![hasWord "accept"]} then "set an_typ 0; complain1" }

	checkbutton $z.rframe.nv -text "Apply Never Claim (If Present)" \
		-variable nv_typ \
		-relief flat \
		-command { if {![hasWord "never"]} then "set nv_typ 0; complain2" }
	checkbutton $z.rframe.fc -text "Weak Fairness (for Liveness)" \
		-variable cyc_typ \
		-relief flat  \
		-command { if $an_typ==0 then "set cyc_typ 0; complain3" }
	checkbutton $z.rframe.ur -text "Report Unreachable Code" \
		-variable ur_typ \
		-relief flat

	pack append $z.rframe \
		$z.rframe.lb {top pady 4 frame w fillx} \
		$z.rframe.sp {top pady 4 frame w} \
		$z.rframe.np {top pady 4 frame w} \
		$z.rframe.ac {top pady 4 frame w} \
		$z.rframe.nv {top pady 4 frame w} \
		$z.rframe.fc {top pady 4 frame w} \
		$z.rframe.ur {top pady 4 frame w filly}
	pack append $z $z.rframe {top frame nw filly}

	# Type of Run

	set z .v
	frame $z.pframe  -relief raised -borderwidth 1m
	label $z.pframe.lb2 \
		-font -Adobe-Helvetica-Bold-R-Normal-*-120-* \
		-text "   Type of Verification Run   " \
		-relief sunken -borderwidth 1m
	checkbutton $z.pframe.po -text "Reduced (Partial Orders)" \
		-variable po_typ \
		-relief flat 
	checkbutton $z.pframe.vb -text "Verbose (For Debugging)" \
		-variable vb_typ \
		-relief flat
	checkbutton $z.pframe.pr -text "Add Complexity Profiling" \
		-variable pr_typ \
		-relief flat

	label $z.pframe.lb3 \
		-font -Adobe-Helvetica-Bold-R-Normal-*-120-* \
		-text "   Error Trapping   " \
		-relief sunken -borderwidth 1m
	radiobutton $z.pframe.c0 -text "Don't Stop at Errors" \
		-variable et_typ -value 0 \
		-relief flat 
	radiobutton $z.pframe.c1 -text "Stop at Error Nr:" \
		-variable et_typ -value 1 \
		-relief flat 
	entry $z.pframe.c2 -relief sunken -width 8

	$z.pframe.c2 insert end "1"

	pack append $z.pframe \
		$z.pframe.lb2 {top fillx pady 4 frame w} \
		$z.pframe.po {top pady 4 frame w} \
		$z.pframe.vb  {top pady 4 frame w} \
		$z.pframe.pr  {top pady 4 frame w} \
		$z.pframe.lb3 { top expand fillx frame w} \
		$z.pframe.c0 {top pady 4 frame w} \
		$z.pframe.c2 {right} \
		$z.pframe.c1 {left expand}

	pack append .v \
		.v.memopts {top frame w} \
		.v.correct {left frame nw expand} \
		.v.pframe  {left frame nw filly}

	# Queues

	label .v.mesg.loss0 \
		-font -Adobe-Helvetica-Bold-R-Normal-*-120-* \
		-text "A Full Queue" \
		-relief sunken -borderwidth 1m
	radiobutton .v.mesg.loss1 -text "Blocks New Msgs" \
		-variable l_typ -value 0 \
		-relief flat
	radiobutton .v.mesg.loss2 -text "Loses New Msgs" \
		-variable l_typ -value 1 \
		-relief flat
	pack append .v.mesg .v.mesg.loss0 {top pady 4 frame w fillx} \
		.v.mesg.loss1 {top pady 4 frame w} \
		.v.mesg.loss2 {top pady 4 frame w}
	pack append .v .v.mesg {top frame n}

	# Compile time options

	label .v.cframe.lb \
		-font -Adobe-Helvetica-Bold-R-Normal-*-120-* \
		-text "Search Mode" \
		-relief sunken -borderwidth 1m

	radiobutton .v.cframe.ea -text "Exhaustive" \
		-variable ct_typ -value 0 \
		-relief flat 
	radiobutton .v.cframe.sa -text "Supertrace" \
		-variable ct_typ -value 1 \
		-relief flat 

	pack append .v.cframe .v.cframe.lb {top pady 4 frame nw fillx} \
		.v.cframe.ea {top pady 4 frame nw} \
		.v.cframe.sa {top pady 4 frame nw}
	pack append .v .v.cframe {top frame w expand fill}

	# Run & Cancel button

	pack append .v [button .v.exit -text "Cancel" \
		-command "stopval"] {right frame se}
	pack append .v [button .v.run -text "Run" \
		-command "runval" ] {right frame se}

}

proc complain1 {} {
	add_log "specification contains no accept labels"
}

proc complain2 {} {
	add_log "specification contains no never claim"
}

proc complain3 {} {
	add_log "weak fairness is irrelevant to state properties"
}

proc stopval {} {
	global stop
	global ival

	set ival(0) "[.v.memopts.choice0.e1 get]"
	set ival(1) "[.v.memopts.choice1.e1 get]"
	set ival(2) "[.v.memopts.choice2.e1 get]"
	set ival(3) "[.v.memopts.choice3.e1 get]"

	set stop 1
	add_log "<stop validation>"
	catch {destroy .v}
}

proc log {n} {
	set m 1
	set cnt 0
	while {$m<$n} {
		set m [expr $m*2]
		incr cnt
	}
	return $cnt
}

proc bld_v_options {} {
	global an_typ;	global cyc_typ;
	global et_typ;	global l_typ;
	global ct_typ;	global ival;
	global v_options; global a_options;
	global c_options; global po_typ vb_typ pr_typ ur_typ;
	global ol_typ oct_typ nv_typ

	set ol_typ $l_typ
	set oct_typ $ct_typ

	set a_options "-a"
	if $l_typ==1	{ set a_options [format "%s -m" $a_options] }

	# the Mbytes scale resolution is in millions: 2^20
	set Mbytes [.v.memopts.choice0.e1 get]
	set Mbytes [expr 19 + [log $Mbytes] / [log 2]]
	# 2^20 is 1 million - subtract 1 because it's rounded up by tcl
	# the Mstate scale resolution is in thousands: 2^10
	set Mstate [expr 10+[log [.v.memopts.choice1.e1 get]]]
	set Mdepth [.v.memopts.choice2.e1 get]
	set ival(0) "[.v.memopts.choice0.e1 get]"
	set ival(1) "[.v.memopts.choice1.e1 get]"
	set ival(2) "[.v.memopts.choice2.e1 get]"
	set ival(3) "[.v.memopts.choice3.e1 get]"

	if $ct_typ==1	{
		set c_options [format "-DBITSTATE -DMEMCNT=%d" $Mbytes]

		# in supertrace mode: #bits ~~ 128x #states
		# (effectively the #bytes will be ~~ 16x #states)

		set Mstate [expr 7+$Mstate]
		set v_options "-X -m$Mdepth -w$Mstate"
	} else {
		set c_options [format "-DMEMCNT=%d" $Mbytes]

		# in exhaustive mode: #hashtable ~~ #states

		set v_options "-X -m$Mdepth -w$Mstate"
	}
	set c_options [format "-D_POSIX_SOURCE %s" $c_options]
	if $po_typ==1	{ set c_options [format "%s -DREDUCE" $c_options] }
	if $vb_typ==1	{ set c_options [format "%s -DVERBOSE" $c_options] }
	if $nv_typ==0	{ set c_options [format "%s -DNOCLAIM" $c_options] }
	if $pr_typ==1	{ set c_options [format "%s -DPEG" $c_options] }
	if $cyc_typ==1	{ set c_options [format "%s -DNFAIR=3" $c_options] }

	set c_options [format "%s %s" $c_options [.v.memopts.choice3.e1 get]] 

	if $an_typ==1	{ set v_options [format "%s -l" $v_options] }
	if $ur_typ==0	{ set v_options [format "%s -n" $v_options] }
	if $an_typ==2	{ set v_options [format "%s -a" $v_options] }
	if $cyc_typ==1	{ set v_options [format "%s -f" $v_options] }
	if $et_typ==0	{ set v_options [format "%s -c0" $v_options] }
	if $et_typ==1	{
		set v_options [format "%s -c%s" $v_options [.v.pframe.c2 get]]
	}
}

proc runval {} {
	global v_options a_options;
	global c_options where Job_Done
	global stop s_typ vbox waitwhat
	global LastGenerate LastCompile NextCompile

	set stop 0

	bld_v_options

	catch {destroy .v}

	add_log "<starting validation>"

	catch {exec rm -f pan.oin}
	if [file exists pan.in] {
		catch {exec mv pan.in pan.oin}
	}

	set model [.inp.t get 0.0 end]
	set fd [open pan.in w]
	puts $fd $model nonewline
	flush $fd
	catch "close $fd"
	## disabling printfs
	catch {eval exec sed s/printf.*\".*\".*\)/skip/ pan.in > _p} err
	catch {eval exec mv _p pan.in} err

	catch {eval exec cmp pan.in pan.oin} err
	if {$err != ""} { set LastGenerate "" }

	if {$LastGenerate == $a_options} {
		add_log "<no code regeneration necessary>"
		set errmsg 0
	} else {
		set LastCompile ""
		add_log "spin $a_options pan.in"; update
		catch "eval exec spin $a_options pan.in" errmsg
		if "$stop || [string length $errmsg]>0" {
			add_log "$errmsg"
			update
			return
		}
	}
	set LastGenerate $a_options

	## optionally: change cc in next line to gcc ##
	set NextCompile "cc -o pan $c_options pan.c"

	if {$LastCompile == $NextCompile && [file exists pan]} {
		add_log "<no recompilation necessary>"
		set errmsg 0
	} else {
		add_log $NextCompile; update
		set errmsg \
		[catch {eval exec $NextCompile &} cc_pid]

		if {$stop || $errmsg} {
			add_log "$errmsg"
			update
			return
		}
		set Job_Done 0
		set waitwhat "Compiling executable verifier"
		watch_job $cc_pid

		if {$Job_Done==0} {
			tkwait variable Job_Done
		}
		if {$Job_Done == -1} {
			add_log "aborted"
			return
		}
	}
	set LastCompile $NextCompile
	set NextCompile ""

	add_log "./pan $v_options"; update
	set errmsg [catch {eval exec ./pan $v_options >pan.out &} pan_pid]
	if {$stop || $errmsg} {
		add_log "$errmsg"
		update
		return
	}

	set Job_Done 0
	set waitwhat "Running the verification"
	watch_job $pan_pid
	if {$Job_Done==0} {
		tkwait variable Job_Done
	}

	update
	set firstline 1
	set have_trail 0
	set po_red_viol 0

	set vbox [mkbox "Validation Output" "ValOut" "pan.out" 80 20]
	set fd [open "pan.out" r]
	while {[gets $fd line] > -1} {

		if {$firstline} {
			set firstline 0
			set nerr 0
			set trunc 0
			set nomem 0
			.inp.t tag remove hilite 0.0 end
			.c$vbox.t delete 0.0 end
		}
		catch { .c$vbox.t insert end "$line\n" }
		catch { .c$vbox.t yview -pickplace end }

		if {[string first "line" $line]>=0} {
			scan $line "\tline %d" where
			src_line $where
		}
		if {[string first "State-vector" $line] == 0} {
			set nerr [string first "errors:" $line]
			if {$nerr > 0} {
			set part [string range $line $nerr end]
			scan $part "errors: %d" nerr
			}
		}
		if {[string first "search depth too small" $line]>0} {
			set trunc 1
		}
		if {[string first "wrote pan.in.trail" $line]>0} {
			set have_trail 1
		}
		if {[string first "violated: access to chan" $line]>0} {
			set po_red_viol 1
		}
		if {[string first "out of memory" $line]>0} {
			set nomem 1
		}
		update
		if $stop break
	}

	if {$have_trail && $po_red_viol==0 && ($nerr>0 || $trunc>0)} {
		catch { repeatbox $nerr $trunc $nomem }
	}
	catch { .c$vbox.t yview 0 }
	catch "close $fd"
	if {$firstline} {
		add_log "<no output>"
		catch { destroy .c$vbox }
	} else {
		add_log "<done>"
	}
	update
}

proc src_line {s} {
	scan $s %d tgt_lnr

	if {$tgt_lnr > 0} {
	.inp.t tag add hilite $tgt_lnr.0 $tgt_lnr.end
	.inp.t tag configure hilite -background black -foreground white
	.inp.t yview -pickplace [expr $tgt_lnr-1]
	}
}

proc repeatbox { {nerr} {trunc} {nomem}} {
	global s_typ

	catch {destroy .rep}
	toplevel .rep

# puts "debug: repeatbox $nerr $trunc"

	wm title .rep "Suggested Action"
	wm iconname .rep "Suggest"
	wm geometry .rep +100+100

	button .rep.b0 -text "Dismiss" -command {destroy .rep}
	button .rep.b1 -text "Guided Simulation.." \
		-command {destroy .rep; simulation }
	button .rep.b2 -text "(Re)Validate.." \
		-command {destroy .rep; validation }

	if {$nerr>0} {
		message .rep.t -width 500 -text "\
Repeat the run with a different search
depth to find a shorter path to the error.

Or, perform a GUIDED simulation to retrace
the error found in this run."
		set s_typ 1

		pack append .rep .rep.t {top expand fill}
		pack append .rep .rep.b0 {right}
		pack append .rep .rep.b1 {right}
		pack append .rep .rep.b2 {right}
	} else {

		if {$nomem>0} {
			message .rep.t -width 500 -text "\
Increase the Maximum Memory Usage allotment, or
(if impossible) switch to Supertrace mode.

Then repeat the verification (with recompilation)."
		} else {
			message .rep.t -width 500 -text "\
Repeat the run with a different search
depth, to avoid truncation of the search."
		}
		pack append .rep .rep.t {top expand fill}
		pack append .rep .rep.b0 {right}
		pack append .rep .rep.b2 {right}
	}
}

proc watch_job {pid} {
	global killed tcnt waitwhat

	set w .cc_$pid
	toplevel $w
	wm title $w "Status Window"
	wm minsize $w 10 10
	wm geometry $w +100+100

	set killed 0
	message $w.t -aspect 1000 -relief raised -borderwidth 2
	button  $w.k -text "Abort" -command "killit $w $pid"
	pack append $w \
		$w.t {top} \
		$w.k {bot}

	set tcnt 0

	check_ps $w $pid
}

proc killit {w pid} {
	global killed Job_Done
	catch { exec kill $pid }
	set killed $pid
	$w.t configure -text "aborted"
	set Job_Done -1
	catch { destroy $w }
}

proc check_ps {w pid} {
	global killed Job_Done tcnt waitwhat

	if {![winfo exists $w]} {
		set Job_Done -1
		return
	}
	if {$killed!=$pid} {
		catch {exec /bin/ps -e > tmp_pan_ps}
		set stat [catch {exec grep "$pid " tmp_pan_ps} t]
		catch {exec rm -f tmp_pan_ps}
		if {$stat == 0} {
			incr tcnt 2
			$w.t configure \
			-text "$waitwhat $tcnt..."
			after 2000 check_ps $w $pid
			return
		} else {	;# process went away
			set Job_Done 1
	}	}
	catch { destroy $w }
}
