# xspin
# simulation options panel

set s_options	""
set v_options	""
set a_options	""
set c_options	""

set fd		0
set Depth	0
set Seq(0)	0
set Sdbox	0
set Spbox(0)	0
set sbox	0

set simruns	0
set stepper	0
set stepped	0
set VERBOSE	0
set howmany	0
set Choice(1)	0

proc simulation {} {
	global s_typ l_typ stop
	global fvars gvars lvars
	global msc svars rvars seed

	set stop 0

	catch {destroy .s}
	toplevel .s

	wm title .s "Simulation Options"
	wm iconname .s "SIM"
	wm geometry .s +150+150

	frame .s.opt -relief flat

	frame .s.opt.mode -relief raised -borderwidth 1m
	label .s.opt.mode.fld0 \
		-font -Adobe-Helvetica-Bold-R-Normal-*-120-* \
		-text "Display Mode" \
		-relief sunken -borderwidth 1m
	radiobutton .s.opt.mode.fld1 -text "Visual in Model" \
		-variable m_typ -value 0 \
		-relief flat
	radiobutton .s.opt.mode.fld2 -text "Raw Ascii Traces" \
		-variable m_typ -value 1 \
		-relief flat
	radiobutton .s.opt.mode.fld3 -text "Time Sequence" \
		-variable m_typ -value 2 \
		-relief flat
	checkbutton .s.opt.mode.fld4 -text "Message Sequence Chart" \
		-variable msc \
		-relief flat

	pack append .s.opt.mode .s.opt.mode.fld0 {top pady 4 frame w fillx}
	pack append .s.opt.mode .s.opt.mode.fld3 {top pady 4 frame w}
	pack append .s.opt.mode .s.opt.mode.fld1 {top pady 4 frame w}
	pack append .s.opt.mode .s.opt.mode.fld2 {top pady 4 frame w}
	pack append .s.opt.mode .s.opt.mode.fld4 {top pady 4 frame w}
	pack append .s.opt .s.opt.mode {left frame n}

	frame .s.opt.mesg -relief raised -borderwidth 1m
	label .s.opt.mesg.loss0 \
		-font -Adobe-Helvetica-Bold-R-Normal-*-120-* \
		-text "A Full Queue" \
		-relief sunken -borderwidth 1m
	radiobutton .s.opt.mesg.loss1 -text "Blocks New Msgs" \
		-variable l_typ -value 0 \
		-relief flat
	radiobutton .s.opt.mesg.loss2 -text "Loses New Msgs" \
		-variable l_typ -value 1 \
		-relief flat
	pack append .s.opt.mesg .s.opt.mesg.loss0 {top pady 4 frame w fillx}
	pack append .s.opt.mesg .s.opt.mesg.loss1 {top pady 4 frame w}
	pack append .s.opt.mesg .s.opt.mesg.loss2 {top pady 4 frame w}
	pack append .s.opt .s.opt.mesg {left frame n}

	frame .s.opt.lframe -relief raised -borderwidth 1m
	label .s.opt.lframe.tl \
		-font -Adobe-Helvetica-Bold-R-Normal-*-120-* \
		-text "Simulation Style" \
		-relief sunken -borderwidth 1m
	radiobutton .s.opt.lframe.is -text "Interactive" \
		-variable s_typ -value 2 \
		-relief flat
	radiobutton .s.opt.lframe.gs -text "Guided (using pan.trail)" \
		-variable s_typ -value 1 \
		-relief flat
	radiobutton .s.opt.lframe.rs -text "Random (using seed)" \
		-variable s_typ -value 0 \
		-relief flat
	entry .s.opt.lframe.entry -relief sunken -width 8 
	label .s.opt.lframe.label \
		-font -Adobe-Helvetica-Bold-R-Normal-*-120-* \
		-text "Seed Value"

	pack append .s.opt.lframe .s.opt.lframe.tl {top pady 4 frame w fillx} \
		.s.opt.lframe.is {top pady 4 frame w} \
		.s.opt.lframe.gs {top pady 4 frame w} \
		.s.opt.lframe.rs {top pady 4 frame w} \
		.s.opt.lframe.label right \
		.s.opt.lframe.entry right
	pack append .s.opt .s.opt.lframe {left frame n}
	pack append .s .s.opt { top frame n }

	pack append .s [button .s.rewind -text "Start" \
		-command "Rewind"  ] {left frame w}
	pack append .s [button .s.exit -text "Cancel" \
		-command "Stopsim" ] {left frame w}

	.s.opt.lframe.entry insert end $seed
}

proc bld_s_options {} {
	global fvars gvars lvars svars
	global rvars l_typ
	global s_typ seed s_options

	set s_options "-X -p -v"
	if {$s_typ==2} { set s_options [format "%s -i" $s_options] }
	if $gvars { set s_options [format "%s -g" $s_options] }
	if $lvars { set s_options [format "%s -l" $s_options] }
	if $svars { set s_options [format "%s -s" $s_options] }
	if $rvars { set s_options [format "%s -r" $s_options] }
	if $l_typ { set s_options [format "%s -m" $s_options] }
	if {$s_typ==1} then {
		set s_options [format "%s -t" $s_options]
	} else {
		if "[string length $seed] > 0" {
			set s_options [format "%s -n%s" $s_options $seed]
		}
	}
}

proc Stopsim {} {
	global stop sbox
	global stepper stepped howmany

	set stop 1
	set stepped 0
	set stepper 0
	add_log "<stop simulation>"
	catch {destroy .s}
	catch {set howmany 0}
}

proc Step_forw {} {
	global stepper;	global stepped
	global sbox;	global simruns

	set stepped 1
	set stepper 1
	if {$simruns == 0} {
		catch { destroy .s }
		runsim
	} else {
		catch { .c$sbox.run configure \
		-text "Run" -command "Runsim" }
	}
}

proc Step_back {} {
	global Depth
	global Seq
	global fd

	set Depth [expr $Depth - 2]
	if {$Depth < 0} { set Depth 0 }
	catch { seek $fd $Seq($Depth) }
	Step_forw
}

proc Rewind {} {
	global simruns;	global Depth
	global fd;	global s_typ
	global Sdbox;	global Spbox
	global seed

	if {$s_typ == 0} {
		set seed [.s.opt.lframe.entry get]
	}
	if {$s_typ == 1} {
		set Depth 0
		if {$simruns} { seek $fd 0 }
		catch {
			foreach el [array names Spbox] {
				set Sdbox $Spbox($el)
				.c$Sdbox.t tag remove Rev 1.0 end
	}	}	}

	Step_forw
}

proc Runsim {} {
	global stepper
	global stepped
	global sbox

	catch { .c$sbox.run configure \
		-text "Suspend" -command "Step_forw" }
	set stepper 1
	set stepped 0
}

proc runsim {} {
	global s_options s_typ
	global stepper stepped
	global simruns m_typ
	global gvars lvars
	global fd stop Depth Seq
	global Sdbox Spbox howmany Choice
	global sbox VERBOSE msc

	set simruns 1
	set Vvbox 0
	set pno 0
	set Varnm("") ""
	set Queues("")	""
	set Depth 0
	set Seq(0) 0
	set Pstp 1
	set SmallFont "-*-Courier-Bold-R-Normal--*-60-*"
	set BigFont   "-*-Courier-Bold-R-Normal--*-120-*"
	set Seenpno 1
	set Banner "Select"

	catch { unset Spbox(0) }
	catch {
		foreach el [array names pbox] {
			destroy .c$pbox($el)
			unset pbox($el)
		}
		foreach el [array names Spbox] {
			destroy .c$Spbox($el)
			unset Spbox($el)
		}
	}

	bld_s_options

	add_log "<starting simulation>"
	add_log "spin $s_options pan.in"
	update
	set s_options [format "%s pan.in" $s_options]

	set fd [open pan.in w];		# should avoid rewriting on -t
	puts $fd "[.inp.t get 0.0 end]" nonewline
	flush $fd
	catch "close $fd"

	set sbox [mkbox "Simulation Output" "SimOut" "sim.out" 60 10 150 150]

	if {$s_typ == 1} {
		pack append .c$sbox [button .c$sbox.rewind -text "Step 1" \
		-command "Rewind" ] {left frame w}
		pack append .c$sbox [button .c$sbox.stepf -text "Step Forw" \
		-command "Step_forw" ] {left frame w}
		pack append .c$sbox [button .c$sbox.stepb -text "Step Back" \
		-command "Step_back" ] {left frame w}
	} else {
		pack append .c$sbox [button .c$sbox.stepf -text "Single Step" \
		-command "Step_forw" ] {left frame w}
	}
	pack append .c$sbox [button .c$sbox.run -text "Run" \
		-command "Runsim" ] {left frame w}

	.c$sbox.b configure -text "Cancel" -command "Stopsim"

	set YSZ 12
	set XSZ 84
	set YNR 60
	set NPR 10
	set SMX 250
	set Easy 1
	set HAS 0
	set HAS_CYCLE 0
	set dontwait 0
	set nrexecutable 0
	set lastexecutable 0

	if { $m_typ == 2 } {
		set pbox(0) [mkbox "Time Sequence" "Sequence" "seq.out" \
			60 10 150 375]
		set dbox $pbox(0)
		if {$msc != 0} {
			if {[hasWord "!!"] || [hasWord "\\?\\?"]} {
				set Easy 0
			}
			set dbox2 \
			[mkcanvas "Message Sequence Chart" "msc" 770 150 1]
			.f$dbox2.c configure \
				-height [expr $YNR*$YSZ+16] \
				-scrollincrement $YSZ \
				-scrollregion "[expr -$XSZ/2] 0 \
					[expr $NPR*$XSZ] [expr $SMX*$YSZ]"
	}	}

	if {$s_typ == 1} {
		catch { .c$sbox.t insert end "preparing trail, please wait..." }
		update
		catch { eval exec rm -f trail.out } errmsg
		catch { eval exec spin $s_options >&trail.out } errmsg
		if "[string length $errmsg]>0" {
			add_log "$errmsg"
			catch { destroy .c$sbox }
			set simruns 0
			update
			return
		}
		set fd [open "trail.out" r]
		catch { .c$sbox.t insert end "done\n" }
	} else {
		set fd [open "|spin $s_options" w+]
	}

	if {$s_typ == 2} {
		Runsim
	}

	while {$stop == 0} {
	if {[gets $fd line] > -1} {
		set pln 0
		set syntax 0
		set isvar 0
		set pname ""
		set i 0

		set pmtch [scan $line "%d: proc %d (%s line %d" \
			pstp pno pname pln]
		set i [string first "\[" $line]
		if {$i > 0} {
			set i [expr $i + 1]
			set j [string length $line]
			set j [expr $j - 2]
			set stmnt [string range $line $i $j]
		} else {
			set stmnt "-"
		}

		if {$pmtch != 4} {
			set pmtch [scan $line "	proc %d (%s line %d" \
			pno pname pln]
			if { $pmtch == 3 } { set pmtch 4 }
		}
		if {$pmtch != 4} {
			if {[string first "spin: line" $line] == 0 } {
				scan $line "spin: line %d" pln
				.inp.t tag add Rev $pln.0 $pln.end
				.inp.t tag configure Rev \
					-background black -foreground white
				.inp.t yview -pickplace $pln.0
				if {[string first "assertion viol" $line] < 0} {
					set syntax 1
				}
			} elseif {[string first "Error: " $line] == 0 } {
				set syntax 1
			}
		}
		if {$pmtch != 4 && $syntax == 0} {
			set pmtch [scan $line "%d: proc - (%s line %d" \
			pstp pname pln]
			if { $pmtch == 3 } { set pmtch 4; set pno -1 }
		}
		set pname [string trim $pname "()"]
		if {$pmtch == 4 && $syntax == 0} {
			if { $m_typ == 1 } {
				if { [info exists pbox($pno)] == 0 } {
					set pbox($pno) [mkbox \
						"Proc $pno ($pname)" \
						"Proc$pno" "proc.$pno.out" \
						60 10 \
						[expr 150+$pno*25] \
						[expr 375+$pno*35] ]
				}
				set dbox $pbox($pno)
			} elseif { $m_typ == 0 } {
				if { [info exists Spbox($pno)] == 0 } {
					set Spbox($pno) \
						[mkbox "$pname (proc $pno)" \
						"$pname" "" \
						60 10 \
						[expr 150+$pno*25] \
						[expr 375+$pno*35] ]
					readinfile .c$Spbox($pno).t "pan.in"
				}
				set Sdbox $Spbox($pno)
			}
		} elseif { [string first "..." $line] > 0 } {
			set $line ""
			set syntax 1
			set pln 0
		} elseif {$s_typ == 2 \
		      && [string first "Select " $line] >= 0 } {
			set Banner $line
			set pln 0
			set nrexecutable 0
			set lastexecutable 0
		} elseif {$s_typ == 2 \
		      && [string first "choice" $line] >= 0 } {
			scan $line "	choice %d" howmany
			set NN [string first ":" $line]; incr NN 2
			set Choice($howmany) [string range $line $NN end]
			if {[string first "unexecutable," $line] > 0} {
				incr nrexecutable
			} else {
				set lastexecutable $howmany
			}
			set pln 0
		} elseif {$s_typ == 2 \
		      && [string first "Make Selection" $line] >= 0 } {
			scan $line "Make Selection %d" howmany
			if {$nrexecutable == $howmany-1} {
				add_log "selected: $howmany (forced)"
				set howmany $lastexecutable
			} else {
				pickoption $Banner
				add_log "selected: $howmany"
			}
			puts $fd $howmany
			flush $fd
			set dontwait 1
			set pln 0
		} elseif { [string first "processes" $line] > 0 \
		      ||   [string first "timeout" $line]  == 0 \
		      ||   [string first "=s==" $line]  > 0 \
		      ||   [string first "=r==" $line]  > 0 } {

			if { $m_typ == 1 } {
				set dbox $pbox(0)
			} elseif { $m_typ == 0 } {
				if { [info exists Spbox($pno)] == 0 } {
					set Spbox($pno) \
						[mkbox "$pname (proc $pno)" \
						"$pname" "" \
						60 10 \
						[expr 150+$pno*25] \
						[expr 375+$pno*35] ]
					readinfile .c$Spbox($pno).t "pan.in"
				}
				set Sdbox $Spbox($pno)
			}
			set pln 0;	# prevent tag update
		} elseif { [string first " = " $line] > 0 } {
				set isvar [string first "=" $line]
				set isvar [expr $isvar + 1]
				set varvl [string range $line $isvar end]
				set isvar [expr $isvar - 2]
				set varnm [string range $line 0 $isvar]
				set varnm [string trim $varnm "	"]
				set Varnm($varnm) $varvl
				set isvar 1
		} elseif { [scan $line " %s %d " varnm qnr] == 2} {
			if { [string compare $varnm "queue"] == 0} {
				set isvar [string last ":" $line]
				set isvar [expr $isvar + 1]
				set varvl [string range $line $isvar end]
				set XX [string first "(" $line]
				set YY [string last  ")" $line]
				set ZZ [string range $line $XX $YY]
				set Queues($qnr) $varvl
				if {[info exists Alias($qnr)]} {
				if {[string first $ZZ $Alias($qnr)] < 0} {
					set Alias($qnr) "$Alias($qnr), $ZZ"
				}
				} else {
					set Alias($qnr) $ZZ
				}
				set isvar 1
			}
		} elseif {[string length $line] == 0} {
			if {$dontwait == 0} { set stepper 0 }
			set pln 0
			set Depth [expr $Depth + 1]
			set Seq($Depth) [tell $fd]
			set dontwait 0
		}
	if {$syntax == 0 } {
		if { $m_typ == 2 && $pln != 0 } {
			catch { .c$dbox.t yview -pickplace end }
			catch { .c$dbox.t insert end "$pno:$pln" }
			for {set i $pno} {$i > 0} {incr i -1} {
				catch { .c$dbox.t insert end "\t|" }
			}
			catch { .c$dbox.t insert end "\t|>$stmnt\n" }

			set Mcont "--"
			set HAS 0
			if { [scan $stmnt "values: %d!%d" inq inp1] == 2 \
			||   [scan $stmnt "values: %d!%s" inq inp2] == 2 } {
				set HAS   [string first "!" $stmnt]
				incr HAS
				set Mcont [string range $stmnt $HAS end]
				set HAS 1
			} elseif { [scan $stmnt "values: %d?%d" inq inp1] == 2 \
			|| [scan $stmnt "values: %d?%s" inq inp2] == 2 } {
				set HAS   [string first "?" $stmnt]
				incr HAS
				set Mcont [string range $stmnt $HAS end]
				set HAS 2
			} elseif { [string first "-" $stmnt] == 0} {
				set HAS 3
				if {$HAS_CYCLE} {
					set stmnt [format "Cycle>>"]
				} else {
					set stmnt [format "<end>"]
				}
			}
			if {$pno+1 > $Seenpno} { set Seenpno [expr $pno+1] }
			set XLOC [expr (1+$pno)*$XSZ]
			set YLOC [expr $Pstp*$YSZ]
			catch {
			if {$VERBOSE || $HAS != 0 || \
				[info exists R($pstp,$pno)]} {
				incr Pstp

				for	{set i 1} \
					{$Pstp > 1 && $i <= $Seenpno} \
					{incr i} {
					set TMP1 [expr $i*$XSZ]
					.f$dbox2.c create line \
					$TMP1 $YLOC $TMP1 \
					[expr $YLOC+$YSZ] \
					-fill blue
				}
				if {$HAS == 1 || $HAS == 2} {
					set stmnt [string range $stmnt 8 end]
				}
				if { [info exists Plabel($pno)] == 0} {
					set Plabel($pno) 0
					.f$dbox2.c create rectangle \
						[expr $XLOC-20] $YLOC \
						[expr $XLOC+20] \
						[expr $YLOC+$YSZ] \
						-outline red -fill yellow
					.f$dbox2.c create text $XLOC \
						[expr $YLOC+$YSZ/2] \
						-font $SmallFont \
						-text "$pname:$pno"

					set YLOC [expr $Pstp*$YSZ]
					incr Pstp
					for	{set i 1} \
						{$Pstp > 1 && $i <= $Seenpno} \
						{incr i} {
						set TMP1 [expr $i*$XSZ]
						.f$dbox2.c create line \
						$TMP1 $YLOC $TMP1 \
						[expr $YLOC+$YSZ] \
						-fill blue
					}
				}
				if {(1+$pno) > $NPR} {
					set NPR [expr $pno+2]
					.f$dbox2.c configure \
					 -scrollregion \
					 "[expr -$XSZ/2] 0 \
					  [expr $NPR*$XSZ] [expr $SMX*$YSZ]"
				}
				if {$Pstp > $SMX-2} {
					set SMX [expr 2*$SMX]
					.f$dbox2.c configure \
					 -scrollregion \
					 "[expr -$XSZ/2] 0 \
					  [expr $NPR*$XSZ] [expr $SMX*$YSZ]"
				}

				if { [info exists R($pstp,$pno)] == 0 } {
					set R($pstp,$pno) \
						[.f$dbox2.c create rectangle \
						 [expr $XLOC-20] $YLOC \
						 [expr $XLOC+20] \
						 [expr $YLOC+$YSZ] \
						 -outline blue -fill white]
					set T($pstp,$pno) \
						[.f$dbox2.c create text \
						 $XLOC \
						 [expr $YLOC+$YSZ/2] \
						-font $SmallFont \
						-text $pstp]
					if {$Pstp > $YNR-2} {
						.f$dbox2.c yview \
						 [expr ($Pstp-$YNR)]
					}
				}
				if { $HAS == 3 } {
					.f$dbox2.c itemconfigure \
					 $R($pstp,$pno) \
					 -outline red -fill yellow
				}

				.f$dbox2.c bind $T($pstp,$pno) <Any-Enter> "
					.f$dbox2.c itemconfigure $T($pstp,$pno) \
						-font $BigFont -text {$stmnt}
					.inp.t tag remove hilite 0.0 end
						src_line {[format "%d" $pln]}
				"
				.f$dbox2.c bind $T($pstp,$pno) <Any-Leave> "
					.f$dbox2.c itemconfigure $T($pstp,$pno) \
						-font $SmallFont -text {$pstp}
				"
			}

			set YLOC [expr $YLOC+$YSZ/2]
			if {$HAS == 1} {
				if { [info exists Q_add($inq)] == 0 } {
					set Q_add($inq) 0
					set Q_del($inq) 0
				}
				set Slot $Q_add($inq)
				incr Q_add($inq) 1

				set Mesg_y($inq,$Slot) $YLOC
				set Mesg_x($inq,$Slot) $XLOC
				set Q_val($inq,$Slot) $Mcont
			
				set Rem($inq,$Slot) \
					[.f$dbox2.c create text \
					[expr $XLOC-40] $YLOC \
					-font $SmallFont -text $stmnt]
			} elseif { $HAS == 2 } {
				if {$Easy} {
					set Slot $Q_del($inq)
					incr Q_del($inq) 1
				} else {
					for {set Slot $Q_del($inq)} \
						{$Slot < $Q_add($inq)} \
						{incr Slot} {
					if {$Q_val($inq,$Slot) == "_X_"} {
							incr Q_del($inq) 1
						} else {
							break
					}	}

					for {set Slot $Q_del($inq)} \
						{$Slot < $Q_add($inq)} \
						{incr Slot} {
					if {$Mcont == $Q_val($inq,$Slot)} {
						set Q_val($inq,$Slot) "_X_"
						break
					}	}
				}
				if {$Slot >= $Q_add($inq)} {
					add_log "<<error: cannot match $stmnt>>"
				} else {
					set TMP1 $Mesg_x($inq,$Slot)
					set TMP2 $Mesg_y($inq,$Slot)
					if {$XLOC < $TMP1} {
						set Delta -20
					} else {
						set Delta 20
					}
					.f$dbox2.c create line \
						[expr $TMP1+$Delta] $TMP2 \
						[expr $XLOC-$Delta] $YLOC \
						-arrow last -arrowshape {5 5 5}
			
					.f$dbox2.c coords $Rem($inq,$Slot) \
						[expr ($TMP1 + $XLOC)/2] \
						[expr ($TMP2 + $YLOC)/2]
				}
			} }
		} elseif { $m_typ == 1 } {
			catch { .c$dbox.t yview -pickplace end }
			catch { .c$dbox.t insert end "$line\n" }
		} elseif { $m_typ == 0 } {
			if {$pln != 0} {
				catch { .c$Sdbox.t yview -pickplace $pln.0 }
				catch { .c$Sdbox.t tag remove Rev 1.0 end }
				catch { .c$Sdbox.t tag add Rev $pln.0 $pln.end }
				catch { .c$Sdbox.t tag configure Rev \
					-background black -foreground white }
			}
		}
		if {$pln == 0 && ($gvars || $lvars)} {
			if {$Vvbox == 0} {
				set Vvbox [mkbox "Variables" \
					"Vars" "var.out" 60 20 150 600]
			} else {
				catch { .c$Vvbox.t delete 0.0 end }
			}
			foreach el [lsort [array names Varnm]] {
				if {[string length $Varnm($el)] > 0} {
				catch { .c$Vvbox.t insert \
					end "$el = $Varnm($el)\n" }
			}	}
			foreach el [lsort [array names Queues]] {
				catch {
				.c$Vvbox.t insert end "queue $el ($Alias($el))\n"
				.c$Vvbox.t insert end "	$Queues($el)\n"
				}
			}
		}
	} else {
			set stepper 0
	}

		if {$isvar == 0} {
			if {$syntax == 1} {
				if {[string first "..." $line] < 0} {
					add_log "$line"
				}
			} else {
				if {[string length $line] > 0} {
				catch { .c$sbox.t insert end "$line\n" }
				catch { .c$sbox.t yview -pickplace end }
				}
				if {$m_typ == 2 && \
					[string first "START OF CYCLE" $line] > 0} {
					catch { .c$dbox.t yview -pickplace end }
					catch { .c$dbox.t insert end "$line\n" }
					catch {
						set XLOC [expr $Seenpno*$XSZ+$XSZ/2]
						set YLOC [expr $Pstp*$YSZ+$YSZ/2]

						.f$dbox2.c create text \
							[expr $XLOC+$XSZ] $YLOC \
							-font $SmallFont \
							-text "Cycle" \
							-fill red

						.f$dbox2.c create line \
							$XLOC $YLOC \
							[expr $XLOC+$XSZ/2] $YLOC \
							-fill red \
							-arrow first -arrowshape {5 5 5}
					}
					set HAS_CYCLE [expr $YLOC+1]
				}
				if {$m_typ == 2 && $HAS == 3 && $HAS_CYCLE != 0} {
					catch {
						set YLOC [expr $Pstp*$YSZ+$YSZ/2]
						set XLOC0 [expr $pno*$XSZ+$XSZ]
						set XLOC [expr $Seenpno*$XSZ+$XSZ]
						.f$dbox2.c create line \
							$XLOC0 [expr $YLOC-$YSZ/2] \
							$XLOC0 $YLOC \
							-fill red
						.f$dbox2.c create line \
							$XLOC0 $YLOC $XLOC $YLOC \
							-fill red

						set XLOC [expr $Seenpno*$XSZ+$XSZ]

						.f$dbox2.c create line \
							$XLOC $YLOC $XLOC \
							[expr $HAS_CYCLE-1] \
							-fill red
					}
				}
			}
		}
		update
		if {$syntax == 0 \
		&&  $stop == 0 \
		&&  $stepped == 1 \
		&&  $stepper == 0 \
		&&  $dontwait == 0} {
			tkwait variable stepper
		}
	} else {
		if {$s_typ == 0 || $s_typ == 2} {
			add_log "<at end of run>"
		} else {
			add_log "<at end of trail>"
		}
		update
		tkwait variable stepper
	}
	}
	# end of guided trail

	set simruns 0

	if { $m_typ == 1 } {
		foreach el [array names pbox] {
			catch { destroy .c$pbox($el) }
			catch { unset pbox($el) }
		}
	} elseif { $m_typ == 0 } {
		foreach el [array names Spbox] {
			catch { destroy .c$Spbox($el) }
			catch { unset Spbox($el) }
		}
	}
	catch { destroy .c$sbox }
	catch { destroy .c$dbox }
	catch { destroy .c$Vvbox }
	catch { unset .c$sbox }

	catch "close $fd"
	add_log "<done>"; update
	update
}

proc pickoption {nm} {
	global howmany Choice
	global stepper stepped

	catch {destroy .prompt}
	toplevel .prompt

	wm title .prompt "Select"
	wm iconname .prompt "Select"
	wm geometry .prompt +150+150

	text .prompt.t -relief raised -bd 2 \
		-width [string length $nm] -height 1 \
		-setgrid 1
	pack append .prompt .prompt.t { top expand fillx }
	.prompt.t insert end "$nm"
	for {set i 1} {$i <= $howmany} {incr i} {
		if {[info exists Choice($i)] \
		&&  $Choice($i) != 0 \
		&&  [string first "unexecutable," $Choice($i)] <= 0} {
		pack append .prompt \
			[button .prompt.b$i -text "$i: $Choice($i)" \
			-anchor w \
			-command "set howmany $i" ] \
			{top expand fillx}
		}
	}
	tkwait variable howmany

	destroy .prompt
}
