# xspin
# Specific Help

proc roadmap1 {} {
	catch {destroy .road1}
	toplevel .road1

	wm title .road1 "Help with Simulation"
	wm iconname .road1 "SimHelp"
	message .road1.t -width 600 -text "\
1.  The random simulation option is used for a quick debugging\
of a validation model.  Correctness requirements (other than\
assertions) are not checked during simulations

2.  During random simulation you can either do single-step\
execution, or an uninterrupted random run.  All nondeterministic\
decisions are resolved randomly.  You can force a selection\
to go a specific direction only by modifying the model to force such\
choices.  A random run can be repeated precisely if the Seed Value\
for the random number generator is kept the same.\
You cannot go backwards in time. (See guided simulation below.)

3.  A guided simulation is used only to follow an error-trail that is\
produced by the validator.  If the trail gets to be thousands of execution\
steps long, it can be time-consuming.  Make an effort, therefore to search\
for the shortest possible error-trail. (See validation help).

4. In guided simulations you can go forwards or backwards in time.\
(But, beware that not all variable values are updated on backward steps.)\
Best mode is to let the simulation run to completion (the error state) and\
then back up a few steps to figure out the cause of the error."

	button .road1.b -text "Ok" -command {destroy .road1}
	pack append .road1 .road1.t {top expand fill}
	pack append .road1 .road1.b {top}
}

proc roadmap2 {} {
	catch {destroy .road2}
	toplevel .road2

	wm title .road2 "Help with Validation"
	wm iconname .road2 "ValHelp"
	message .road2.t -width 600 -text "\
1. To get started, leave all parameters at their default values\
and try an exhaustive verification (hit Run).\
If you run out of memory, double the memory bound (Max Memory Usage),\
but make sure to never\ exceed the amount of physical (not virtual!)\
RAM that is available on your machine.

If you hit the maximum search depth without finding errors:\
double it.

2. If an exhaustive verification cannot be completed,\
switch to a supertrace analysis - and leave the memory bound\
at its maximukm value.

Begin with the default estimate of the number of reachable states.\
After you successfully complete a run, double the estimate, and see\
if the number of reached stated changes much.  Continue to do this until\
it stops changing, or until you hit the maximum (i.e., larger than the\
memory bound you set earlier allows).

3. If an error is found, try to reduce the search depth to try to find\
a shorter equivalent.  If you're content with the depth, move on to a\
guided simulation, to play back the error trail in detail.\
To find the shortest error-trail, continue to half the search depth\
limit until the error disappears.  Then continue to half the interval\
between the last level at which you saw the error, and the last level\
you checked where it no longer appeared.

4. If searching for cycles -- use the fairness restriction only when\
really necessary.  It can increase the CPU-time requirement (not the\
memory requirements) by a factor roughly equal to twice the number\
of active processes.

5. It is safe to leave the Reduced Search option set for all verifications.\
Turn it off only for debugging purposes.  The Verbose option, similarly, is
only for debugging, not for real verification work.  The Profiling option
gathers statistics about the verification hot-spots in the model."

	button .road2.b -text "Ok" -command {destroy .road2}
	pack append .road2 .road2.t {top expand fill}
	pack append .road2 .road2.b {top}
}

proc roadmap3 {} {
	catch {destroy .road3}
	toplevel .road3

	wm title .road3 "Reducing Complexity"
	wm iconname .road3 "CompHelp"
	message .road3.t -width 600 -text "\
1. Make the model more general, more abstract.\
Remove everything that isn't directly related to the property\
you are trying to prove: redundant computations, redundant data.

In a first verification run: drastically reduce the number of\
slots in asynchronous channels (use 2, or 3 slots to get started).

2. Group local computations into atomic sequences.

3. Avoid leaving scratch data around in variables.  You can reduce\
the number of states by, for instance, resetting local variables\
that are used inside atomic sequences to zero at the end of those\
sequences; so that the scratch values aren't visible outside the\
sequence.

4. If possible to do so: combine the behavior of two processes in\
a single one.  Generalize behavior;  focus on coordination aspects\
(i.e., the interfaces between processes, rather than the local\
computation inside processes)."

	button .road3.b -text "Ok" -command {destroy .road3}
	pack append .road3 .road3.t {top expand fill}
	pack append .road3 .road3.b {top}
}
