# xspin
# FSM view option

set nodeX(0) 0
set nodeY(0) 0
set Label(0) 0
set Transit(0) {}
set TLabel(0) 0
set edgeHead(0) 0
set edgeTail(0) 0
set Dist(0) 0
set State(0) 0
set Edges(0) {}
set New 0
set MaxDist 0

set cnr	0

proc fsmview {} {
	catch {destroy .z}
	toplevel .z

	wm title .z "Double-Click Proc"

	listbox .z.list -setgrid 1
	button .z.b -text "Cancel" -command "destroy .z"

	pack append .z \
		.z.list {top expand fill} \
		.z.b {right padx 5}

	scan [.inp.t index end] %d numlines
	.z.list insert end "init"
	for {set i 1} {$i < $numlines} {incr i} {
		set line [.inp.t get $i.0 $i.end]
		set k [string first "proctype" $line]
		if { $k >= 0} {
			incr k 9
			set j [string first "(" $line]
			incr j -1
			.z.list insert end \
				[string trim [string range $line $k $j]]
		}
	}

	bind .z.list <Double-Button-1> {
		set pfind [selection get]
		catch { destroy .z }
		findfsm $pfind
	}
}

proc findfsm {pfind} {
	global New Dist State Edges Label Transit MaxDist

	add_log "<fsm view option>"

	set foo [mk_exec]
	if {$foo == 0} { return }

	set src 0; set trn 0; set trg 0
	set Want 0

	catch { foreach el [array names State] { unset State($el) } }
	catch { foreach el [array names Edges] { unset Edges($el) } }
	catch { foreach el [array names Dist]  { unset Dist($el) } }

	add_log "./pan -d"; update
	set fd [open "|./pan -d" w+]
	set MaxDist 0
	while {[gets $fd line] > -1} {
		set k [string first "proctype" $line]
		if { $k >= 0 } {
			if { $Want == 1 } {
				break
			}
			incr k 9
			set pname [string range $line $k end]
			if { [string first $pfind $line] >= 0 } {
				set Want 1
				set nsrc "$pname:0"
				set Dist($nsrc) 0
				set Label($nsrc) "line 0"
				set Edges($nsrc) {}
			}
		} elseif { $Want == 1 \
			&& [string first "state" $line] >= 0} {
			scan $line "	state %d -(tr %d)-> state %d" \
				src trn trg

			set nsrc "$pname:$src"
			set ntrg "$pname:$trg"
			set k [string first "line" $line]
			if { $k > 0 } {
				set m [string first "=>" $line]
				incr m -1
				set lbl [string range $line $k $m]
				incr m 3
				set action [string range $line $m end]
			} else {
				set lbl "line 0"
				set action "line 0"
			}
			set Label($nsrc) $lbl
			if { [info exists Dist($nsrc)] == 0 } {
				set Dist($nsrc) 0
				set Edges($nsrc) {}
			}
			if { [info exists Dist($ntrg)] == 0 } {
				set Dist($ntrg) [expr $Dist($nsrc) + 1]
				set Edges($ntrg) {}
				if {$Dist($ntrg) > $MaxDist } {
					set MaxDist $Dist($ntrg)
				}
			} else {
				if { [expr $Dist($nsrc) + 1] < $Dist($ntrg) } {
					set Dist($ntrg) [expr $Dist($nsrc) + 1]
					if {$Dist($ntrg) > $MaxDist } {
						set MaxDist $Dist($ntrg)
					}
			}	}
			lappend Edges($nsrc) $ntrg
			lappend Transit($nsrc) $action
		}
	}
	if { $Want == 1 } {
		dograph $pfind
	} else {
		add_log "sorry, $pfind not found..."
	}
	catch "close $fd"
	add_log "<done>"
	update
}

proc dograph {n} {
	global Dist Edges Label Transit MaxDist
	set count -1
	set found 1

	mkcanvas "FSM $n" $n 300 300 0
	set prefix [string length $n]
	incr prefix
	set y 0

	foreach el [array names Dist]  {	# for every state
	foreach ed [array names Edges] {	# if edge to state with lower Dist
		if { [ string first $n $el ] >= 0 } {
		for {set i 0} { [lindex $Edges($el) $i] != "" } {incr i} {
				set ntrg [lindex $Edges($el) $i]
				if { $Dist($ntrg) < $Dist($el) } {
					set NotMiddle($el) 1
	} }	}	}	}

	while {$count < $MaxDist} {
		incr count
		incr y 50
		set x 250
		set found 0
		foreach el [array names Dist] {
			if { [ string first $n $el ] >= 0 \
			&&   $Dist($el) == $count } {
				incr found
				set pn [string range $el $prefix end]

				if { [info exists NotMiddle($el)] != 0 } {
					if { $x == 250 } {
						incr x 75
					}
				}
				set State($el) [mkNode $Label($el) $pn $x $y]
				if { $x > 250 } {
					set x [expr $x - 250]
					set x [expr 250 - $x]
				} else {
					set x [expr 250 - $x]
					incr x 75
					set x [expr 250 + $x]
				}
		}	}
	}
	foreach el [array names Edges] {
		if { [ string first $n $el ] >= 0 } {
			for {set i 0} { [lindex $Edges($el) $i] != "" } {incr i} {
				set ntrg [lindex $Edges($el) $i]
				set lbl  [lindex $Transit($el) $i]
				mkEdge $lbl $State($el) $State($ntrg)
			}
	}	}
	update
}

proc mkNode {n t x y} {
	# tcl book p. 213
	global cnr
	global nodeX nodeY edgeHead edgeTail New TLabel
	set New [.f$cnr.c create oval [expr $x-10] [expr $y-10] \
		[expr $x+10] [expr $y+10] \
		-outline black \
		-fill white \
		-tags node]
	set Lab [.f$cnr.c create text $x $y -text $t -tags label]

	.f$cnr.c bind $Lab <Any-Enter> "
		.f$cnr.c itemconfigure $Lab -fill black -text {$n}
		set_src {$n}
	"
	.f$cnr.c bind $Lab <Any-Leave> "
		.f$cnr.c itemconfigure $Lab -fill black -text $t
	"

	set nodeX($New) $x
	set nodeY($New) $y
	set TLabel($New) $Lab

	set edgeHead($New) {}
	set edgeTail($New) {}
	update
	return $New
}

proc set_src {n} {
	set where 0
	scan $n "line %d" where
	.inp.t tag remove hilite 0.0 end
	src_line $where
}

proc mkEdge {L a b} {
	global cnr Xrem Yrem
	global nodeX nodeY edgeHead edgeTail

	if { $nodeY($b) > $nodeY($a) } {
		set ydiff -11
	} elseif { $nodeY($b) < $nodeY($a) } {
		set ydiff 11
	} else {
		set ydiff 0
	}
	if { $nodeX($b) > $nodeX($a) } {
		set xdiff -6
	} elseif { $nodeX($b) < $nodeX($a) } {
		set xdiff 6
	} else {
		set xdiff 0
	}
	set edge [.f$cnr.c create line \
		$nodeX($a) $nodeY($a) \
		[expr $nodeX($b) + $xdiff] \
		[expr $nodeY($b) + $ydiff] \
		 -arrow both -arrowshape {4 3 3} ]
	.f$cnr.c lower $edge
	lappend edgeHead($a) $edge
	lappend edgeTail($b) $edge
	set Xrem($edge) $xdiff
	set Yrem($edge) $ydiff
	set Ledge($edge) $L;	# <<<<< action-label on transition

	set midX [expr $nodeX($a) + $nodeX($b)]
	set midX [expr $midX / 2 ]
	set midY [expr $nodeY($a) + $nodeY($b)]
	set midY [expr $midY / 2 ]

	set transition [.f$cnr.c create text $midX $midY]

	.f$cnr.c bind $transition <Any-Enter> "
		.f$cnr.c itemconfigure $transition -fill black -text {$L}
	"
	.f$cnr.c bind $transition <Any-Leave> "
		.f$cnr.c itemconfigure $transition -fill black -text {}
	"
}

proc moveNode {cnr node mx my} {
	global edgeHead edgeTail TLabel
	global nodeX nodeY curX curY
	global Xrem Yrem

	set xDist [expr $mx - $curX]
	set yDist [expr $my - $curY]

	.f$cnr.c move $node $xDist $yDist
	.f$cnr.c move $TLabel($node) $xDist $yDist
	incr nodeX($node) $xDist
	incr nodeY($node) $yDist
	foreach edge $edgeHead($node) {
		set ec [.f$cnr.c coords $edge]
		.f$cnr.c coords $edge \
			$nodeX($node)  $nodeY($node) \
			[lindex $ec 2] [lindex $ec 3]
	}
	foreach edge $edgeTail($node) {
		set ec [.f$cnr.c coords $edge]
		set nx [expr $nodeX($node) + $Xrem($edge)]
		set ny [expr $nodeY($node) + $Yrem($edge)]
		.f$cnr.c coords $edge \
			[lindex $ec 0] [lindex $ec 1] \
			$nx $ny
	}
}

set curX 0
set curY 0

proc mkcanvas {n m geox geoy placed} {
	global cnr curX curY

	incr cnr
	toplevel .f$cnr
	wm title .f$cnr "$n"
	wm iconname .f$cnr $m
	if {$placed} {
		wm geometry .f$cnr +$geox+$geoy
	}
	wm minsize .f$cnr 100 100

	set cv [canvas .f$cnr.c  -relief raised -bd 2\
		-scrollregion {-15c -5c 30c 40c} \
		-xscroll ".f$cnr.hscroll set" \
		-yscroll ".f$cnr.vscroll set"]
	scrollbar .f$cnr.vscroll -relief sunken \
		-command ".f$cnr.c yview"
	scrollbar .f$cnr.hscroll -relief sunken -orient horiz \
		-command ".f$cnr.c xview"
	#-width 500 -height 500

	button .f$cnr.b1 -text "Close" \
		-command "destroy .f$cnr"

	button .f$cnr.b2 -text "Save in: $m.bw.ps" \
		-command "$cv postscript -file $m.bw.ps -colormode mono"
	button .f$cnr.b3 -text "Save in: $m.col.ps" \
		-command "$cv postscript -file $m.col.ps -colormode color"
#	or use:	-colormode gray

	pack append .f$cnr \
		.f$cnr.vscroll {right filly} \
		.f$cnr.hscroll {bottom fillx} \
		.f$cnr.c {top expand fill} \
		.f$cnr.b1 {right padx 5} \
		.f$cnr.b2 {right padx 5} \
		.f$cnr.b3 {right padx 5}

	.f$cnr.c bind node <Button-2> {
		set curX %x
		set curY %y
	}
	.f$cnr.c bind node <B2-Motion> "
		moveNode $cnr \[.f$cnr.c find withtag current] %x %y
		set curX %x
		set curY %y
	"
	.f$cnr.c bind node <Any-Enter> "
		.f$cnr.c itemconfigure current -fill black
	"
	.f$cnr.c bind node <Any-Leave> "
		.f$cnr.c itemconfigure current -fill white
	"

	tkwait visibility .f$cnr
	return $cnr
}
