# xspin
# Files and Generic Boxes

set file ""
set boxnr 0
set comp_done 0

proc file_ok {f} {
	if [file exists $f] {
		if "![file isfile $f] || ![file writable $f]" {
			add_log "error: file $f is not writable"
			return 0
	}	}
	return 1
}

proc mk_exec {} {

	set fd [open pan.tmp w]
	puts $fd "[.inp.t get 0.0 end]" nonewline
	flush $fd
	catch "close $fd"

	if {[file exists "pan.in"] && [file exists "pan"]} {
		catch { eval exec cmp pan.tmp pan.in } errmsg
		if "[string length $errmsg] == 0" {
			return 1
		}
	}
	add_log "<compiling executable>"
	catch { warner }
	catch { eval exec mv pan.tmp pan.in } errmsg
		if "[string length $errmsg]>0" {
			add_log "$errmsg"
			return 0
		}
	add_log "spin -a pan.in"
	catch { eval exec spin -a pan.in } errmsg
		if "[string length $errmsg]>0" {
			add_log "$errmsg"
			return 0
		}
	add_log "cc -o pan -D_POSIX_SOURCE pan.c"; update
	catch { eval exec cc -o pan -D_POSIX_SOURCE pan.c } errmsg
		if "[string length $errmsg]>0" {
			add_log "$errmsg"
			return 0
		}
	add_log "<compilation complete>"
	catch {destroy .warn}
	return 1
}

proc warner {} {

	catch {destroy .warn}
	toplevel .warn

	wm title .warn "Update"
	wm iconname .warn "Update"
	wm geometry .warn +200+200

	message .warn.t -width 300 -text "\
Please wait until compilation of the \
executable produced by spin completes."

	pack append .warn .warn.t {top expand fill}
}

proc save_spec {} {
	set fname [.menu.name get]
	if [file_ok $fname]==0 return
	set fd [open $fname w]
	add_log "<save spec in $fname>"
	puts $fd "[.inp.t get 0.0 end]" nonewline
	catch "flush $fd"
	catch "close $fd"
}

proc browse {} {
	global file
	catch {destroy .b}
	toplevel .b

	wm iconname .b "Load"

	scrollbar .b.scroll -command ".b.list yview"
	listbox .b.list -yscroll ".b.scroll set" -relief raised -geometry 20x20
	pack append .b \
		.b.scroll {right filly} \
		.b.list {left expand fill}

	fillerup
	bind .b.list <Double-Button-1> {
		set file [selection get]
		if [file isdirectory $file] then {
			cd $file
			fillerup
			add_log "cd $file"
		} else {
			if ![file isfile $file] {
				set file ""
			} else {
				readinfile .inp.t $file
				set dir [pwd]
				.menu.name delete 0 end
				.menu.name insert end "$file"
				.menu.name configure -width [string length $file]
				destroy .b
			}
		}
	}
}

proc reopen {} {
	global file

	set file [.menu.name get]
	catch {readinfile .inp.t $file} ermsg
	if [string length $ermsg]<=1 return
	add_log $ermsg
}

proc readinfile {into from} {
	global file

	set maxlngth 0

	$into delete 0.0 end
	set fd [open $from r]
	
	while {[gets $fd line] > -1} {
		$into insert end "$line\n"
		if {[string length $line] > $maxlngth} {
			set maxlngth [string length $line]
		}
	}
	catch "close $fd"

	if {$maxlngth > 80} { set maxlngth 80 }
	$into configure -width $maxlngth

	add_log "<open $from>"
}

proc fillerup {} {
	wm title .b [pwd]
	.b.list delete 0 end
	foreach i [exec ls -a "."] {
		if [string compare $i "."] {
			.b.list insert end $i
		}
	}
}

proc gotoline {} {
	catch { destroy .ln }
	toplevel .ln
	wm title .ln "Goto Line"
	wm iconname .ln "Goto"

	label .ln.lab -text "Enter line number:"
	entry .ln.ent -width 20 -relief sunken -textvariable lno
	pack append .ln \
		.ln.lab {left padx 1m} \
		.ln.ent {right expand}
	bind .ln.ent <Return> {
		.inp.t tag remove hilite 0.0 end
		.inp.t tag add hilite $lno.0 $lno.1000
		.inp.t tag configure hilite -background black -foreground white
		.inp.t yview -pickplace [expr $lno-1]
	}
	focus .ln.ent
}

proc savebox {b} {
	set fname [.c$b.f.e1 get]
	if [file_ok $fname]==0 return
	set fd [open $fname w]
	add_log "<saved output in $fname>"
	puts $fd "[.c$b.t get 0.0 end]" nonewline
	catch "flush $fd"
	catch "close $fd"
}

proc mkbox {n m p {wd 60} {ht 10} {xp 200} {yp 200}} {
	global boxnr

	incr boxnr

	toplevel .c$boxnr
	wm title .c$boxnr $n
	wm iconname .c$boxnr $m
	wm geometry .c$boxnr +$xp+$yp

	text .c$boxnr.t -relief raised -bd 2 \
		-setgrid 1 -width $wd -height $ht -wrap word
	button .c$boxnr.b -text "Close" \
		-command "destroy .c$boxnr"
	pack append .c$boxnr \
		.c$boxnr.t {top expand fill} \
		.c$boxnr.b {right padx 5}

	if [string length $p]>0 {
		frame  .c$boxnr.f -relief sunken
		button .c$boxnr.f.e0 -text "Save in: " \
			-command "savebox $boxnr"
		entry  .c$boxnr.f.e1 -relief flat -width 10
		.c$boxnr.f.e1 insert end $p
		pack append .c$boxnr.f \
			.c$boxnr.f.e0 {left padx 5} \
			.c$boxnr.f.e1 {left}
		pack append .c$boxnr \
			.c$boxnr.f {right padx 5}
	}

	tkwait visibility .c$boxnr
	return $boxnr
}

# Tcl/Tk book, page 219
proc forAllMatches {w pattern} {
	scan [$w index end] %d numLines
	for {set i 1} {$i < $numLines} { incr i} {
		$w mark set last $i.0
		if {[regexp -indices $pattern \
			[$w get last "last lineend"] indices]} {
				$w mark set first \
					"last + [lindex $indices 0] chars"
				$w mark set last "last + 1 chars \
					+ [lindex $indices 1] chars"
			.inp.t tag add hilite $i.0 $i.1000
			.inp.t tag configure hilite -background black -foreground white
			.inp.t yview -pickplace [expr $i-1]
		}
	}
}

proc hasWord {pattern} {
	scan [.inp.t index end] %d numLines
	for {set i 1} {$i < $numLines} { incr i} {
		.inp.t mark set last $i.0
		if {[regexp -indices $pattern \
			[.inp.t get last "last lineend"] indices]} {
				return 1
		}
	}
	return 0
}
