/***** spin: sym.c *****/

#include "spin.h"
#include "y.tab.h"

Symbol	*symtab[Nhash+1];
Symbol	*context = (Symbol *) 0;

hash(s)
	char *s;
{
	int h=0;

	while (*s)
	{	h += *s++;
		h <<= 1;
		if (h&(Nhash+1))
			h |= 1;
	}
	return h&Nhash;
}

Symbol *
lookup(s)
	char *s;
{
	Symbol *sp;
	int h=hash(s);

	for (sp = symtab[h]; sp; sp = sp->next)
		if (strcmp(sp->name, s) == 0 && sp->context == context)
			return sp;			/* found  */
	if (context)					/* local  */
	for (sp = symtab[h]; sp; sp = sp->next)
		if (strcmp(sp->name, s) == 0 && !sp->context)
			return sp;			/* global */
	sp = (Symbol *) emalloc(sizeof(Symbol));	/* add    */
	sp->name = (char *) emalloc(strlen(s) + 1);
	strcpy(sp->name, s);
	sp->nel = 1;
	sp->context = context;
	sp->next = symtab[h];
	symtab[h] = sp;

	return sp;
}

void
settype(n, t)
	Node *n;
{
	while (n)
	{	if (n->nsym->type)
		  yyerror("redeclaration of `%s'", n->nsym->name);
		n->nsym->type = t;
		if (n->nsym->nel <= 0)
		  yyerror("bad array size for `%s'", n->nsym->name);
		n = n->rgt;
	}
}

Node *Mtype = (Node *) 0;

void
setmtype(m)
	Node *m;
{
	Node *n = m;
	if (Mtype)
		yyerror("mtype redeclared", (char *)0);

	Mtype = n;
	while (n)	/* syntax check */
	{	if (!n->lft || !n->lft->nsym
		||  (n->lft->ntyp != NAME)
		||   n->lft->lft)	/* indexed variable */
			fatal("bad mtype definition", (char *)0);
		n = n->rgt;
	}
}

Node *Symnode = 0;

void
syms(m)
	Node *m;
{
	if (Symnode)
		yyerror("Duplicate Symmetry definition", (char *)0);

	Symnode = m;
}
#include <stdio.h>

int SymCnt=0;
void
putsyms(fd, fh)
	FILE *fd, *fh;
{
	if (!Symnode || !Symnode->rgt || !Symnode->lft)
	{	fprintf(fh, "#define Normalize	0\n");
		return;
	}
	fprintf(fh, "#ifndef WHICH\n");
	fprintf(fh, "#define WHICH	1	/* must be either 1 or -1 */\n");
	fprintf(fh, "#endif\n");

	putdescend(fd, Symnode->lft, Symnode->rgt);

	fprintf(fh, "#define Normalize	1 ");
	while (SymCnt > 0)
		fprintf(fh, "\\\n\t\t&& Symmer%d() == WHICH ", --SymCnt);
	fprintf(fh, "\n");
}

void
putdescend(fd, a, b)
	FILE *fd;
	Node *a, *b;
{
	if (b->ntyp != ';')
		putasym(fd, a, b);
	else
	{	putasym(fd, a, b->lft);
		putasym(fd, a, b->rgt);
	}
}

void
putasym(fd, m, n)
	FILE *fd;
	Node *m, *n;
{
	Node *t1 = m;
	Node *t2 = n;
	fprintf(fd, "Symmer%d()\n{	long d;\n", SymCnt++);
	for ( ; t1 && t2; t1 = t1->rgt, t2 = t2->rgt)
	{	if (!t1->lft || !t2->lft)
			fatal("bad Symmetry list", (char *)0);

		fprintf(fd, "	d = ");
		putstmnt(fd, t1->lft, 0);
		fprintf(fd, " - ");
		putstmnt(fd, t2->lft, 0);
		fprintf(fd, ";\n");

		fprintf(fd, "	if (d < 0) return -1;\n");
		fprintf(fd, "	if (d > 0) return  1;\n\n");
	}
	fprintf(fd, "	return 0;\n}\n");
}

ismtype(str)
	char *str;
{
	Node *n;
	int cnt = 1;

	for (n = Mtype; n; n = n->rgt)
	{	if (strcmp(str, n->lft->nsym->name) == 0)
			return cnt;
		cnt++;
	}
	return 0;
}
