/***** spin: sched.c *****/

#include <stdio.h>
#include "spin.h"
#include "y.tab.h"

int nproc = 0;
int nstop = 0;
int Tval  = 0;
int Rvous = 0;
int depth = 0;

RunList		*X   = (RunList  *) 0;
RunList		*run = (RunList  *) 0;
ProcList	*rdy = (ProcList *) 0;
Element		*eval_sub();
extern int	verbose, lineno, s_trail, analyze;
extern Symbol	*Fname;
extern char	*claimproc;
extern int	Noglobal;
int Have_claim=0;

void
runnable(s, n)
	Sequence *s;	/* body */
	Symbol *n;	/* name */
{
	RunList *r = (RunList *) emalloc(sizeof(RunList));
	r->n = n;
	r->pid = nproc++;
	r->pc = s->frst;
	r->maxseq = s->last->seqno;
	r->nxt = run;
	run = r;
}

void
ready(n, p, s)
	Symbol *n;	/* process name */
	Node *p;	/* formal parameters */
	Sequence *s;	/* process body */
{
	ProcList *r = (ProcList *) emalloc(sizeof(ProcList));
	r->n = n;
	r->p = p;
	r->s = s;
	r->nxt = rdy;
	rdy = r;
}

enable(s, n)
	Symbol *s;	/* process name */
	Node *n;	/* actual parameters */
{
	ProcList *p;
	for (p = rdy; p; p = p->nxt)
		if (strcmp(s->name, p->n->name) == 0)
		{	runnable(p->s, p->n);
			setparams(run, p, n);
			return (nproc-nstop-1);	/* pid */
		}
	return 0; /* process not found */
}

void
start_claim(n)
{	ProcList *p;
	int i;

	for (p = rdy, i=1; p; p = p->nxt, i++)
		if (i == n)
		{	runnable(p->s, p->n);
			Have_claim = 1;
			return;
		}
	fatal("couldn't find claim", (char *) 0);
}

void
sched()
{	Element *e;
	RunList *Y;	/* previous process in run queue */
	int i;

	if (analyze)
	{	gensrc();
		return;
	} else if (s_trail)
	{	match_trail();
		return;
	}
	if (claimproc)
		printf("warning: claims are ignored in simulations\n");

	for (Tval=i=0; Tval < 2; Tval++, i=0)
	{	while (i < nproc-nstop)
		for (X=run, Y=0, i=0; X; X = X->nxt)
		{	lineno = X->pc->n->nval;
			Fname  = X->pc->n->fname;
#ifdef DEBUG
			printf("process %s\n", X->n->name);
#endif
			if (e = eval_sub(X->pc))
			{	X->pc = e; Tval=0;
				talk(e, X->symtab);
			} else
			{	if (X->pc->n->ntyp == '@'
				&&  X->pid == (nproc-nstop-1))
				{	if (Y)
						Y->nxt = X->nxt;
					else
						run = X->nxt;
					nstop++; Tval=0;
					if (verbose&4)
					{	whoruns();
						printf("terminates\n");
					}
				} else
					i++;
			}
			Y = X;
	}	}
	wrapup();
}

wrapup()
{	if (depth)	/* for guided simulations, Chapter 12 */
		printf("step %d, ", depth);
	if (nproc != nstop)
	{	printf("#processes: %d\n", nproc-nstop);
		dumpglobals();
		verbose &= ~1;	/* no more globals */
		verbose |=  4;	/* add process states */
		for (X = run; X; X = X->nxt)
			talk(X->pc, X->symtab);
	}
	printf("%d processes created\n", nproc);
}

complete_rendez()
{	RunList *orun = X;
	Element *e;
	int res=0;

	if (s_trail)	/* for guided simulations, Chapter 12 */
		return 1;
	Rvous = 1;
	for (X = run; X; X = X->nxt)
#ifdef DEBUG
	{	printf("check: (%d)", Rvous); talk(X->pc, X->symtab);
#endif
		if (X != orun && (e = eval_sub(X->pc)))
		{	X->pc = e;
			if (verbose&4)
			{	printf("rendezvous: %s ",X->n->name);
				printf("<-> %s\n", orun->n->name);
				printf("=r==:	");
				talk(e, X->symtab);
				printf("=s==:	");
				X = orun;
				talk(X->pc, X->symtab);
			}
			res = 1;
			break;
		}
#ifdef DEBUG
	}
#endif
	Rvous = 0;
	X = orun;
	return res;
}

/***** Runtime - Local Variables *****/

void
addsymbol(r, s)
	RunList *r;
	Symbol  *s;
{
	Symbol *t = (Symbol *) emalloc(sizeof(Symbol));
	int i;

	t->name = s->name;
	t->type = s->type;
	t->nel  = s->nel;
	t->ini  = s->ini;
	if (s->val)		/* if initialized, copy it */
	{	t->val = (int *) emalloc(s->nel*sizeof(int));
		for (i = 0; i < s->nel; i++)
			t->val[i] = s->val[i];
	} else
		checkvar(t, 0);	/* initialize it */
	t->next = r->symtab;	/* add it */
	r->symtab = t;
}

void
naddsymbol(r, s, k)
	RunList *r;
	Symbol  *s;
{
	Symbol *t = (Symbol *) emalloc(sizeof(Symbol));
	int i;

	t->name = s->name;
	t->type = s->type;
	t->nel  = s->nel;
	t->ini  = s->ini;
	t->val = (int *) emalloc(s->nel*sizeof(int));
	if (s->nel != 1)
	fatal("array in formal parameter list, %s", s->name);
	for (i = 0; i < s->nel; i++)
		t->val[i] = k;
	t->next = r->symtab;
	r->symtab = t;
}

typck(n, t, s)
	Node *n;
	char *s;
{
	if (!n || !n->lft
	||  (n->lft->ntyp == NAME && n->lft->nsym->type != t
	     && n->lft->nsym->type != 0
	     && (t == CHAN || n->lft->nsym->type == CHAN))
	||  (n->lft->ntyp == NAME && n->lft->nsym->type == 0
	     && lookup(n->lft->nsym->name)->type != t) )
	{	yyerror("error in parameters of run %s(...)", s);
		return 0;
	}
	return 1;
}

void
setparams(r, p, q)
	RunList *r;
	ProcList *p;
	Node *q;
{
	Node *f, *a;	/* formal and actual pars */
	Node *t;	/* list of pars of 1 type */

	for (f = p->p, a = q; f; f = f->rgt) /* one type at a time */
	for (t = f->lft; t; t = t->rgt, a = (a)?a->rgt:a)
	{	int k;
		if (!a) fatal("missing actual parameters: '%s'", p->n->name);
		k = eval(a->lft);        /* must be initialized*/
		if (typck(a, t->nsym->type, p->n->name))
		{	if (t->nsym->type == CHAN)
				naddsymbol(r, t->nsym, k); /* copy */
			else
			{	t->nsym->ini = a->lft;
				addsymbol(r, t->nsym);
  			}
		}
	}
}

Symbol *
findloc(s, n)
	Symbol *s;
{
	Symbol *r = (Symbol *) 0;

	if (n >= s->nel || n < 0)
	{	yyerror("array indexing error %s", s->name);
		return (Symbol *) 0;
	}

	if (!X)
	{	if (analyze)
			fatal("error, cannot evaluate variable '%s'", s->name);
		else
			yyerror("error, cannot evaluate variable '%s'", s->name);
		return (Symbol *) 0;
	}
	for (r = X->symtab; r; r = r->next)
		if (strcmp(r->name, s->name) == 0)
			break;
	if (!r && !Noglobal)
	{	addsymbol(X, s);
		r = X->symtab;
	}
	return r;
}

getlocal(s, n)
	Symbol *s;
{
	Symbol *r;

	r = findloc(s, n);
	if (r) return cast_val(r->type, r->val[n]);
	return 0;
}

setlocal(p, m)
	Node *p;
{
	int n = eval(p->lft);
	Symbol *r = findloc(p->nsym, n);

	if (r) r->val[n] = m;
	return 1;
}

void
whoruns()
{	if (!X) return;

	if (Have_claim && X->pid >= 1)
	{	if (X->pid == 1)
			printf("proc  - (%s)	", X->n->name);
		else
			printf("proc %2d (%s)	", X->pid-1, X->n->name);
	} else
		printf("proc %2d (%s)	", X->pid, X->n->name);
}

void
talk(e, s)
	Element *e;
	Symbol *s;
{
	if (verbose&4)
	{	p_talk(e);
		if (verbose&1) dumpglobals();
		if (verbose&2) dumplocal(s);
	}
}

void
p_talk(e)
	Element *e;
{
	whoruns();
	printf("line %d (state %d)\n",
		(e && e->n && e->n->nval)?e->n->nval:-1, e->seqno);
}

remotelab(n)
	Node *n;
{
	int i;

	if (n->nsym->type)
		fatal("not a labelname: `%s'", n->nsym->name);
	if ((i = find_lab(n->nsym, n->lft->nsym)) == 0)
		fatal("unknown labelname: %s", n->nsym->name);
#ifdef DEBUG
	printf("remotelab=%d\n", i);
#endif
	return i;
}

remotevar(n)
	Node *n;
{
	int pno, i, j, trick=0;
	RunList *Y, *oX = X;

	if (!n->lft->lft)
	{	yyerror("missing pid in %s", n->nsym->name);
		return 0;
	}
	pno = eval(n->lft->lft); /* pid */
TryAgain:
	i = nproc - nstop;
	for (Y = run; Y; Y = Y->nxt)
	if (--i == pno)
	{	if (strcmp(Y->n->name, n->lft->nsym->name))
		{	if (!trick && Have_claim)
			{	trick = 1; pno++;
				/* assumes user only guessed the pid */
				goto TryAgain;
			}
			printf("remote ref %s[%d] refers to %s\n",
				n->lft->nsym->name, pno, Y->n->name);
			yyerror("wrong proctype %s", Y->n->name);
		}
		{ extern int Noglobal;
		  Noglobal=1; /* make sure it's not created by default */
		  if (n->nsym->type == 0) n->nsym->type = INT;
		  X = Y; j = getval(n->nsym, eval(n->rgt)); X = oX;
		  Noglobal=0;
		}
#ifdef DEBUG
	printf("remotevar %s in pid %d  =%d\n", n->nsym->name, pno, j);
#endif
		return j;
	}
	printf("remote ref: %s[%d] ", n->lft->nsym->name, pno);
	yyerror("variable %s not found", n->nsym->name);
	return 0;
}
