/***** spin: pangen5.c *****/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "spin.h"
#include "y.tab.h"

extern int	nproc, nstop, Tval, Rvous, Have_claim;
extern RunList	*run, *X;
extern int	verbose, lineno;
extern int	depth;

FILE *fd;

void
whichproc(p)
{	RunList *oX;

	for (oX = run; oX; oX = oX->nxt)
		if (oX->pid == p)
		{	printf("(%s) ", oX->n->name);
			break;
		}
}

int
newer(f1, f2)
	char *f1, *f2;
{
	struct stat x, y;

	if (stat(f1, (struct stat *)&x) < 0) return 0;
	if (stat(f2, (struct stat *)&y) < 0) return 1;
	if (x.st_mtime < y.st_mtime) return 0;
	return 1;
}

void
match_trail()
{	int i, pno, nst, lv0=0, lv1=0;
	extern Symbol *Fname;

	if (Fname->name[0] == '\"')
	{	i = strlen(Fname->name);
		Fname->name[i-1] = '\0';
		Fname = lookup(&Fname->name[1]);
	}
			
	if (newer(Fname->name, "pan.trail"))
	printf("Warning, file %s modified since trail was written\n",
			Fname->name);

	if (!(fd = fopen("pan.trail", "r")))
	{	printf("spin -t: cannot find `pan.trail'\n");
		exit(1);
	}
	Tval = 1; /* timeouts may be part of the trail */
	while (fscanf(fd, "%d:%d:%d:%d\n", &depth, &pno, &nst, &lv0)
								== 4)
	{	if (lv1 >= 0 && depth > 0 && (verbose&32 || lv1 != lv0))
			talk(X->pc, X->symtab);
		lv1=lv0;	/* non-verbose in intermediate steps */
		if (depth == -1)
		{	if (verbose)
			printf("<<<<<START OF CYCLE>>>>>\n");
			continue;
		}
		if (depth == -2)
		{
#ifdef DEBUG
			printf("<<<<<START OF CLAIM (%d)>>>>>\n", pno);
#endif
			start_claim(pno);
			continue;
		}
		i = nproc - nstop;
		if (nst == 0)
		{	if (pno == i-1 && run->pc->n->ntyp == '@')
			{	run = run->nxt;
#ifdef DEBUG
				printf("%d: proc %d stopped\n", depth, pno);
#endif
				nstop++;
				continue;
			} else
			{	printf("step %d: stop error, %d %d %c\n",
					depth, pno, i, run->pc->n->ntyp);
				exit(1);
		}	}
#ifdef DEBUG
		printf("process %d, newstate %d\n", pno, nst);
#endif
		for (X = run; X; X = X->nxt)
		{
#ifdef DEBUG
			printf("%d: check %s\n", i, X->n->name);
#endif
			if (--i == pno)
				break;
		}
#ifdef DEBUG
		printf("pick %s (%d in %d - %d)\n",
			(X)?X->n->name:"none", pno, nproc, nstop);
#endif
		if (!X)
		{	int k=0;
			printf("step %d: lost trail ", depth); whichproc(pno);
			if (Have_claim)
			{	if (pno == 1)
					printf("(state %d)\n", nst);
				else
				{	if (pno > 1) k = 1;
					printf("(proc %d state %d)\n", pno-k, nst);
				}
			} else
				printf("(proc %d state %d)\n", pno-k, nst);
			lost_trail();
			wrapup();
			exit(1);
		}
		lineno = X->pc->n->nval;
		do
		{	X->pc = d_eval_sub(X->pc, pno, nst);
#ifdef DEBUG
		printf("%d: move to %d\n", depth, (X&&X->pc)?X->pc->seqno:0);
fflush(stdout);
#endif
		} while (X && X->pc && X->pc->seqno != nst);
		if (!X || !X->pc)
		{	int k = 0;
			printf("step %d: lost trail ", depth); whichproc(pno);
			if (Have_claim)
			{	if (pno == 1)
					printf("(state %d)\n", nst);
				else
				{	if (pno > 1) k = 1;
					printf("(proc %d state %d.)\n", pno-k, nst);
				}
			} else
				printf("(proc %d state %d.)\n", pno, nst);
			lost_trail();
			wrapup();
			exit(1);
		}
	}
	talk(X->pc, X->symtab);
	printf("spin: trail ends after %d steps\n", depth);
	wrapup();
}

void
lost_trail()
{	int d, p, n, l;

	while (fscanf(fd, "%d:%d:%d:%d\n", &d, &p, &n, &l) == 4)
	{	printf("step %d: proc  %d ", d, p); whichproc(p);
		printf("(state %d) - d %d\n", n, l);
	}
}

int Depth=0;

Element *
walk_sub(e, pno, nst)
	Element *e;
{
	SeqList *z;
	Element *f;
#ifdef DEBUG
	printf("walk_sub starts %d\n", Depth);
#endif

	if (Depth > 32)	/* very likely circular */
		return (Element *) 0;
	Depth++;
	for (z = e->sub; z; z = z->nxt)
	{
#ifdef DEBUG
	explain(z->this->frst->n);
#endif
		if (z->this->frst->seqno == nst)
		{	Depth--; return z->this->frst; }
		if (!z->this->frst->nxt)
			fatal("cannot happen", "walk_sub");
		if (z->this->frst->sub)
		{	f = walk_sub(z->this->frst, pno, nst);
			if (f) { Depth--; return f; }
		}
		f = huntele(z->this->frst, z->this->frst->status);
#ifdef DEBUG
		printf("hunted ele, now in state %d\n", f->seqno);
#endif
		if (f->seqno == nst)
		{	Depth--; return f; }
		if (f->seqno == X->pc->seqno)		/* looping */
			continue;			/* fails */
		if (f->sub && (f = walk_sub(f, pno, nst)))
		{	Depth--; return f; }
		if (f && f->n->ntyp == ATOMIC)
		{	f = f->n->seql->this->frst;
			if (f->seqno == nst)
			{	Depth--; return f; }
		}
#ifdef DEBUG
		printf("walksub no match, want %d saw %d\n",
				nst, z->this->frst->seqno);
#endif
	}
#ifdef DEBUG
	printf("walk_sub failed %d\n", Depth);
#endif
	Depth--;
	return (Element *) 0;
}

Element *
d_eval_sub(s, pno, nst)
	Element *s;
{
	Element *e=s;

	if (e->n->ntyp == GOTO)
	{
#ifdef DEBUG
	printf("d_eval: goto\n"); fflush(stdout);
#endif
		return get_lab(e->n->nsym);
	}
	if (e->sub)
	{	if (e = walk_sub(e, pno, nst))
		{
#ifdef DEBUG
	printf("d_eval: walk_sub\n"); fflush(stdout);
#endif
			return e;
		}
#ifdef DEBUG
	printf("d_eval: !walk_sub\n"); fflush(stdout);
#endif
	} else if (e->n && e->n->ntyp == ATOMIC)
	{	e->n->seql->this->last->nxt = e->nxt;
#ifdef DEBUG
	printf("d_eval: atomic\n"); fflush(stdout);
#endif
		if (e->n->seql->this->frst->seqno == nst)
			return e->n->seql->this->frst;
		return d_eval_sub(e->n->seql->this->frst, pno, nst);
	} else if (eval(e->n))
	{
#ifdef DEBUG
	printf("d_eval: nxt\n"); fflush(stdout);
#endif
		return e->nxt;
	}
#ifdef DEBUG
	else
	{	printf("unexecutable:\t"); fflush(stdout);
		explain(e->n);
	}
#endif
	if (e && (nst == e->seqno))
#ifdef DEBUG
	{	printf("step %d: returning %u\n", depth, e);
		fflush(stdout);
#endif
		return e;
#ifdef DEBUG
	}
#endif
	if (s && (nst == s->seqno))
#ifdef DEBUG
	{	printf("step %d: proc %d didn't leave %d\n",
			depth, pno, s->seqno);
#endif
		return s;
#ifdef DEBUG
	}
#endif
	printf("step %d: lost trail ", depth);
	if (Have_claim)
	{	int k=0;
		if (pno == 1)
			printf("(");
		else
		{	if (pno > 1) k = 1;
			printf("(proc %d ", pno-k);
		}
	} else
		printf("(proc %d ", pno);
	whichproc(pno);
	printf("state .%d) [stuck in %d]\n", nst, (e)?e->seqno:-1);
	lost_trail();
	wrapup();
	exit(1);
}
