/***** spin: pangen3.c *****/

#include <stdio.h>
#include <ctype.h>
#include "spin.h"
#include "y.tab.h"

extern FILE	*th;
#ifdef GODEF
extern int	Globalname;
extern int	Countm;
#endif

typedef struct SRC {
	short ln, st;
	struct SRC *nxt;
} SRC;

SRC	*frst = (SRC *) 0;
SRC	*skip = (SRC *) 0;
int	col;

void
putskip(m)	/* states that need not be reached */
{	SRC *tmp;

	for (tmp = skip; tmp; tmp = tmp->nxt)
		if (tmp->st == m)
			return;
	tmp = (SRC *) emalloc(sizeof(SRC));
	tmp->st = (short) m;
	tmp->nxt = skip;
	skip = tmp;
}

void
putsrc(n, m)	/* match states to source lines */
{	SRC *tmp;

	for (tmp = frst; tmp; tmp = tmp->nxt)
		if (tmp->st == m)
		{	if (tmp->ln != n)
				printf("putsrc mismatch %d - %d\n");
			return;
		}
	tmp = (SRC *) emalloc(sizeof(SRC));
	tmp->ln = (short) n;
	tmp->st = (short) m;
	tmp->nxt = frst;
	frst = tmp;
}

void
dumpskip(n, m)
{	SRC *tmp, *lst;
	int j;

	fprintf(th, "uchar reached%d [] = {\n\t", m);
	for (j = 0, col = 0; j <= n; j++)
	{	lst = (SRC *) 0;
		for (tmp = skip; tmp; lst = tmp, tmp = tmp->nxt)
			if (tmp->st == j)
			{	putnr(1);
				if (lst)
					lst->nxt = tmp->nxt;
				else
					skip = tmp->nxt;
				break;
			}
		if (!tmp)
			putnr(0);
	}
	fprintf(th, "};\n");
	skip = (SRC *) 0;
}

void
dumpsrc(n, m)
{	SRC *tmp, *lst;
	int j;

	fprintf(th, "short src_ln%d [] = {\n\t", m);
	for (j = 0, col = 0; j <= n; j++)
	{	lst = (SRC *) 0;
		for (tmp = frst; tmp; lst = tmp, tmp = tmp->nxt)
			if (tmp->st == j)
			{	putnr(tmp->ln);
				if (lst)
					lst->nxt = tmp->nxt;
				else
					frst = tmp->nxt;
				break;
			}
		if (!tmp)
			putnr(0);
	}
	fprintf(th, "};\n");
	frst = (SRC *) 0;
	dumpskip(n, m);
}

void
putnr(n)
{
	if (col++ == 8)
	{	fprintf(th, "\n\t");
		col = 1;
	}
	fprintf(th, "%3d, ", n);
}

#define Cat0(x)   	comwork(fd,now->lft,m); fprintf(fd, x); \
			comwork(fd,now->rgt,m)
#define Cat1(x)		fprintf(fd,"("); Cat0(x); fprintf(fd,")")
#define Cat2(x,y)  	fprintf(fd,x); comwork(fd,y,m)
#define Cat3(x,y,z)	fprintf(fd,x); comwork(fd,y,m); fprintf(fd,z)

void
symbolic(fd, v)
	FILE *fd;
{
	Node *n; extern Node *Mtype;
	int cnt = 1;

	for (n = Mtype; n; n = n->rgt, cnt++)
		if (cnt == v)
		{	fprintf(fd, "%s", n->lft->nsym->name);
			break;
		}
	if (!n)
		fprintf(fd, "%d", v);
}

void
comwork(fd, now, m)
	FILE *fd;
	Node *now;
{
	Node *v;
	int i, j; extern int Mpars;

	if (!now) { fprintf(fd, "0"); return; }
	switch (now->ntyp) {
	case CONST:	fprintf(fd, "%d", now->nval); break;
	case '!':	Cat3("!(", now->lft, ")"); break;
	case UMIN:	Cat3("-(", now->lft, ")"); break;
	case '~':	Cat3("~(", now->lft, ")"); break;

	case '/':	Cat1("/");  break;
	case '*':	Cat1("*");  break;
	case '-':	Cat1("-");  break;
	case '+':	Cat1("+");  break;
	case '%':	Cat1("%%"); break;
	case '<':	Cat1("<");  break;
	case '>':	Cat1(">");  break;
	case '&':	Cat1("&");  break;
	case '|':	Cat1("|");  break;
	case LE:	Cat1("<="); break;
	case GE:	Cat1(">="); break;
	case NE:	Cat1("!="); break;
	case EQ:	Cat1("=="); break;
	case OR:	Cat1("||"); break;
	case AND:	Cat1("&&"); break;
	case LSHIFT:	Cat1("<<"); break;
	case RSHIFT:	Cat1(">>"); break;

	case RUN:	fprintf(fd, "run %s(", now->nsym->name);
			for (v = now->lft; v; v = v->rgt)
				if (v == now->lft)
				{	Cat2("", v->lft);
				} else
				{	Cat2(",", v->lft);
				}
			fprintf(fd, ")");
			break;

	case LEN:	putname(fd, "len(", now->lft, m, ")");
			break;

	case 's':	putname(fd, "", now->lft, m, "!");
			for (v = now->rgt, i = 0; v; v = v->rgt, i++)
			{	if (v != now->rgt) fprintf(fd,",");
				if (v->lft->ntyp == CONST)
					symbolic(fd,v->lft->nval);
				else
					comwork(fd,v->lft,m);
			}
			for ( ; i < Mpars; i++)
				fprintf(fd, ", 0");
			break;
	case 'r':	putname(fd, "", now->lft, m, "?");
			for (v = now->rgt, i=j=0; v; v = v->rgt, i++)
			{	if (v != now->rgt) fprintf(fd,",");
				if (v->lft->ntyp == CONST)
					symbolic(fd,v->lft->nval);
				else
					comwork(fd,v->lft,m);
			}
			break;
	case 'R':	putname(fd, "", now->lft, m, "?[");
			for (v = now->rgt, i=j=0; v; v = v->rgt, i++)
			{	if (v != now->rgt) fprintf(fd,",");
				if (v->lft->ntyp == CONST)
					symbolic(fd,v->lft->nval);
				else
					comwork(fd,v->lft,m);
			}
			fprintf(fd, "]");
			break;

	case 'c':	Cat3("(", now->lft, ")");
			break;
	case ASGN:	comwork(fd,now->lft,m);
			fprintf(fd," = ");
			comwork(fd,now->rgt,m);
			break;
	case PRINT:	{	char buf[512];
				strncpy(buf, now->nsym->name, 510);
				for (i = strlen(buf)-1; i >= 0; i--)
					if (buf[i] == '\"')
						buf[i] = '\'';
				fprintf(fd, "printf(%s", buf);
			}
			for (v = now->lft; v; v = v->rgt)
			{	Cat2(",", v->lft);
			}
			fprintf(fd, ")");
			break;
	case NAME:	putname(fd, "", now, m, "");
			break;
	case   'p':	putremote(fd, now, m);
			break;
	case   'q':	fprintf(fd, "%s", now->nsym->name);
			break;
	case ASSERT:	Cat3("assert(", now->lft, ")");
			break;
	case   '.':
	case BREAK:
	case  GOTO:	fprintf(fd, "goto", m); break;
	case   '@':
			fprintf(fd, "@", m); break;

	case ATOMIC:
			fprintf(fd, "ATOMIC");
			break;
	case IF:
			fprintf(fd, "IF");
			break;
	case DO:
			fprintf(fd, "DO");
			break;
	case TIMEOUT:
#ifdef GODEF
			Globalname = 1;	/* don't consider this local */
#endif
			fprintf(fd, "timeout");
			break;
	default:	if (isprint(now->ntyp))
				fprintf(fd, "`%c'", now->ntyp);
			else
				fprintf(fd, "%d", now->ntyp);
			break;
	}
}

void
comment(fd, now, m)
	FILE *fd;
	Node *now;
{
	extern int terse, nocast;
#ifdef GODEF
	Globalname = 0;
#endif
	terse=nocast=1;
	comwork(fd, now, m);
	terse=nocast=0;
}

#ifdef GODEF

atom_stack *top_ast = 0;

push_ast(what, when, cause, n)
	char *what;
	Node *n;
{
	atom_stack *tmp, *lst;

	for (tmp = top_ast; tmp; tmp = tmp->nxt)
		if (strcmp(tmp->what, what) == 0
		&&  tmp->when == when
		&&  tmp->n && n
		&&  tmp->n->nsym == n->nsym)
			return;
	tmp = (atom_stack *) emalloc(sizeof(atom_stack));
	tmp->what  = (char *) emalloc(strlen(what) + 1);
	strcpy(tmp->what, what);
	tmp->when  = when;
	tmp->cause = cause;
	tmp->n     = n;
	if (cause == 'r' || cause == 's' || !top_ast)
	{	tmp->nxt   = top_ast;
		top_ast    = tmp;
	} else	/* tail add */
	{	for (lst = top_ast; lst->nxt; lst = lst->nxt)
			;
		lst->nxt = tmp;
	}
}

static int rHeader;
static int sHeader;

lastfirst(fd, tmp)
	FILE *fd;
	atom_stack *tmp;
{
	if (!tmp) return;
	lastfirst(fd, tmp->nxt);
	switch (tmp->cause) {
	case 'r':
		if (!rHeader) break;
		rHeader = 0;
		fprintf(fd, "\n#if SYNC\n");
		fprintf(fd, "		depth = od;\n");
		fprintf(fd, "#endif\n");
		fprintf(fd, "		} /*rH*/\n\t\t");
		break;
	case 's':
		if (!sHeader) break;
		sHeader = 0;
		fprintf(fd, "} /*sH*/\n\t\t");
	default :
		break;
	}
}

pop_ast(fd, how)
	FILE *fd;
{
	atom_stack *tmp;

	rHeader = 0;
	sHeader = 0;
	for (tmp = top_ast; tmp; tmp = tmp->nxt)
	{	Countm++;
		switch (tmp->cause) {
		case 'r':
			if (rHeader == 0)
			{	fprintf(fd, "{ int L_typ = Rcv_LOCK;\n");
				fprintf(fd, "#if SYNC\n");
				fprintf(fd, "\t\tint od=depth;\n");
				fprintf(fd, "#if ASYNC\n");
				putname(fd, "\t\tif (q_zero(", tmp->n, 0, "))\n");
				fprintf(fd, "#endif\n");
				fprintf(fd, "\t\t{\tdepth--; L_typ = Snd_LOCK; }\n");
				fprintf(fd, "#endif\n\t\t");
				rHeader++;
			}
			pop_common(fd, tmp, how);
			break;

		case 's':
			if (sHeader == 0 && how == 1)
			{	fprintf(fd, "if (SYNC == 0 || !q_zero");
				putname(fd, "(", tmp->n, 0, ")) {\n\t\t");
				sHeader++;
			}
			pop_common(fd, tmp, how);
			break;
		case TIMEOUT:
			fprintf(fd, "push_act(II, R_LOCK, %s, t->forw, ",
				(how == 0)?"REL":"BLOCK");
			fprintf(fd, "CS_timeout); /* + */\n\t\t");
			break;
		default:
			pop_common(fd, tmp, how);
			break;
		}
	}
	lastfirst(fd, top_ast);
	if (how == 1) clear_ast();
}

pop_common(fd, tmp, how)
	FILE *fd;
	atom_stack *tmp;
{
	if (tmp->when == Direct)
	{	fprintf(fd, "push_act(II, %s, ", tmp->what);
		fprintf(fd, "%s, t->forw, CS_",
			(how == 0)?"REL":"BLOCK");
		fprintf(fd, "%s", tmp->n->nsym->name);
		if (tmp->n->nsym->nel > 1)
		{	fprintf(fd, "+");
			putstmnt(fd, tmp->n->lft, 0);
		}
		fprintf(fd, "); /* + */\n\t\t");
	} else if (tmp->when == Indirect)
	{	if (tmp->cause == 'r')
			fprintf(fd, "push_act(II, L_typ, %s, t->forw, ",
				(how == 0)?"REL":"BLOCK");
		else
			fprintf(fd, "push_act(II, %s, %s, t->forw, ",
				tmp->what, (how == 0)?"REL":"BLOCK");
		putname(fd, "1+MAXCONFL+", tmp->n, 0, "); /* + */\n\t\t");
	} else
	{	fprintf(stderr, "cannot happen pop_ast\n");
		abort();
	}
}

has_ast()
{
	return (top_ast != 0);
}

clear_ast()
{
	/* don't call free, avoid wasting time in malloc */
	top_ast = (atom_stack *) 0;
}

atom_stack *
save_ast()
{
	return top_ast;
}

restor_ast(oCS)
	atom_stack *oCS;
{
	top_ast = oCS;
}

coll_global(s, how)
	Sequence *s;
{
	Element *f, *g;
	SeqList *h;

	if (!s) return;
	for (f = s->frst; ; f = f->nxt)
	{	coll_cs(f->n);
		for (h = f->sub; h; h = h->nxt)
			coll_global(h->this, how);
		if (f == s->last)
			break;
	}
}
#endif
