/***** spin: pangen2.c *****/

#include <stdio.h>
#include "spin.h"
#include "y.tab.h"
#include "pangen2.h"

extern ProcList	*rdy;
extern RunList	*run;
extern Symbol	*Fname;
extern char	*claimproc;
extern int	lineno;
extern int	Mpars;
extern int	m_loss;
int		Globalname;

#ifdef GODEF
void push_cs();
void push_loss();
void putbase();
void putindex();
void coll_global();
void coll_base();
void coll_cs();
void coll_indx();
int aMarked=0, Marked=0, Countm=0, Maxcs=0;
#endif

FILE	*tc, *th, *tt, *tm, *tb, *tf;
int	uniq=1;
int	nocast=0;	/* to turn off casts in lvalues */
int	terse=0;	/* terse printing of varnames */
int	nps=0;		/* number of processes */
int	mst=0;		/* max nr of state/process */
int	claimnr = -1;	/* claim process, if any */
int	Pid;		/* proc currently processed */
int	EVAL_runs = 0;	/* used in fairness checks */

#ifdef VARSTACK
int	Cksum;		/* debugging only */
#endif

fproc(s)
	char *s;
{
	ProcList *p;
	int i;

	if (strcmp("_init", s) == 0)
		return 0;
	for (p = rdy, i = 1; p; p = p->nxt, i++)
		if (strcmp(p->n->name, s) == 0)
			return i;
	fatal("proctype %s not found", s);
}

void
gensrc()
{	ProcList *p;
	int i;

	if (!(tc = fopen("pan.c", "w"))		/* main routines */
	||  !(th = fopen("pan.h", "w"))		/* header file   */
	||  !(tt = fopen("pan.t", "w"))		/* transition matrix */
	||  !(tm = fopen("pan.m", "w"))		/* forward  moves */
	||  !(tf = fopen("pan.f", "w"))		/* fairness checks */
	||  !(tb = fopen("pan.b", "w")))	/* backward moves */
	{	printf("spin: cannot create pan.[chtmb]\n");
		exit(1);
	}
	fprintf(th, "/*** %s ***/\n", Fname->name);
	fprintf(th, "#define uchar	unsigned char\n");
	if (claimproc)
	{	claimnr = fproc(claimproc);
		fprintf(th, "#define VERI	%d\n",	claimnr);
		fprintf(th, "#define claimline");
		fprintf(th, "	src_ln%d[((P0 *)pptr(1))->_p]\n",
							claimnr);
	}
	fprintf(th, "#define M_LOSS	%d\n", m_loss);
	fprintf(th, "#define endclaim	endstate%d\n",	claimnr);
	ntimes(tc, 0, 1, Preamble);

	fprintf(tc, "#ifndef NOBOUNDCHECK\n");
	fprintf(tc, "#define Index(x, y)	Boundcheck(x, y, II, tt, t)\n");
	fprintf(tc, "#else\n");
	fprintf(tc, "#define Index(x, y)	x\n");
	fprintf(tc, "#endif\n");

	mst = (run)?run->maxseq:0;
	for (p = rdy, i = 1; p; p = p->nxt, i++)
		mst = max(p->s->last->seqno, mst);
	nps = i+1;	/* add progress checker */

	fprintf(tt, "settable()\n{\tTrans *T, *settr();\n\n");
	fprintf(tt, "#ifdef VERBOSE\n");
	fprintf(tt, "\tMoves[0] = \"bad move\";\n");
	fprintf(tt, "#endif\n");
	fprintf(tt, "\ttrans = (Trans ***) ");
	fprintf(tt, "emalloc(%d*sizeof(Trans **));\n", nps);

	fprintf(tm, "	switch (t->forw) {\n");
	fprintf(tm, "	default: Uerror(\"bad forward move\");\n");

	fprintf(tb, "	switch (t->back) {\n");
	fprintf(tb, "	default: Uerror(\"bad return move\");\n");
	fprintf(tb, "	case  0: goto R999; /* nothing to undo */\n");

	fprintf(tf, "	switch (t->forw) {\n");
	fprintf(tf, "	default: continue;\n");

	if (!run) fatal("no runable process", (char *)0);

	putproc(run->n, run->pc, 0, run->maxseq);
	for (p = rdy, i = 1; p; p = p->nxt, i++)
		putproc(p->n, p->s->frst, i, p->s->last->seqno);
	putprogress(i, 2);
#ifdef GODEF
	fprintf(th, "#define _TRA_%d	%d	/* progress */\n", i, uniq);
	fprintf(th, "#define _TRA_%d	%d	/* end */\n", i+1, uniq+2);
#endif
	ntimes(tt, 0, 1, Tail);
	genheader();
	genaddproc();
	genother(i);
	genaddqueue();
	genunio();

	putsyms(tc, th);
}

void
putproc(n, e, i, j)
	Symbol *n;
	Element *e;
{
	Pid = i;
#ifdef GODEF
	fprintf(th, "#define _TRA_%d	%d	/* %s */\n", i, uniq, n->name);
#endif
	fprintf(th, "\nshort nstates%d=%d;\t/* %s */\n", i,j+1,n->name);
	fprintf(tm, "\n		 /* PROC %s */\n", n->name);
	fprintf(tb, "\n		 /* PROC %s */\n", n->name);
	fprintf(tt, "\n	/* proctype %d: %s */\n", i, n->name);
	fprintf(tt, "\n	trans[%d] = (Trans **)", i);
	fprintf(tt, " emalloc(%d*sizeof(Trans *));\n\n", j+1);
	putseq(e, 0);
	dumpsrc(j, i);
}

void
putprogress(i, j)	/* loop detector */
{
	fprintf(th, "\nshort nstates%d=%d;\t/* _progress */\n", i, j+1);

	fprintf(tt, "\n	/* proctype %d: _progress */\n", i);
	fprintf(tt, "\n	trans[%d] = (Trans **)", i);
	fprintf(tt, " emalloc(%d*sizeof(Trans *));\n\n", j+1);
	fprintf(tt, "	trans[%d][1]	= settr(1,2,%d,%d,\"-\",0,0);\n",
						i, uniq, uniq);
	fprintf(tt, "	trans[%d][2]	= settr(1,0,%d,%d,\"-\",0,0);\n",
						i, uniq+1, uniq+1);
	fprintf(tt, "}\n");

	fprintf(tm, "\n		 /* _progress */\n");
	fprintf(tm, "	case %d:	/* progress */\n", uniq);
	fprintf(tm, "		IfNotBlocked\n");
	fprintf(tm, "		now._p_t = 13;	/* 13 to help the hasher */\n");
	fprintf(tm, "		m = 3; goto P999;\n");
	fprintf(tm, "	case %d:\n", uniq+1);
	fprintf(tm, "		continue;\n");
	fprintf(tm, "	}\n\n");

	fprintf(tb, "\n		 /* _progress */\n");
	fprintf(tb, "	case %d:	/* progress */\n", uniq);
	fprintf(tb, "		now._p_t = 0;\n");
	fprintf(tb, "		goto R999;\n");
	fprintf(tb, "	case %d:\n", uniq+1);
	fprintf(tb, "		goto R999;\n");
	fprintf(tb, "	}\n\n");

	fprintf(tf, "	}\n");
}

void
putseq(f, level)
	Element *f;
{
	Element *e;

	for (e = f; e; e = e->nxt)
		putseq_el(e, level+1);
}

void
putseq_lst(s, level)
	Sequence *s;
{
	Element *g;

	for (g = s->frst; ; g = g->nxt)
	{	if (!g)
		{	fprintf(stderr, "cannot happen seq_lst\n");
			exit(1);
		}
		putseq_el(g, level+1);
		if (g == s->last)
			break;
	}
}

void
putseq_el(e, level)
	Element *e;
{
	SeqList *h;
	int n, a, bu;

	if (e->status & DONE)
		return;
	e->status |= DONE;
	if (e->n->nval)
		putsrc(e->n->nval, e->seqno);
	if (e->sub)
	{	int oMarked, oaMarked; atom_stack *oCS, *save_ast();
		fprintf(tt, "\tT = trans[%d][%d] = ",
						Pid, e->seqno);
		fprintf(tt, "settr(%d,0,0,0,\"", e->status);
		comment(tt, e->n, e->seqno);
		fprintf(tt, "\",0,%d);\t/* line %d (%d,%d) */\n",
			e->n->ntyp,
			e->n->nval, Marked, level);
		for (h = e->sub; h; h = h->nxt)
		{	putskip(h->this->frst->seqno);
			a = huntstart(h->this->frst);
			fprintf(tt, "\tT = T->nxt\t= ");
			fprintf(tt, "settr(%d,%d,0,0,\"",
						e->status, a, e->n->ntyp);
			comment(tt, e->n, e->seqno);
			fprintf(tt, "\", %d, %d);\t/* line %d (%d,%d) */\n",
				1-Marked, e->n->ntyp,
				e->n->nval, Marked, level);
		}
#if 0
		oMarked = Marked;
		oCS = save_ast();
#endif
		oaMarked = aMarked;
		for (h = e->sub; h; h = h->nxt)
		{
			aMarked = oaMarked;
#if 1
			if (aMarked)
			{	clear_ast();
				coll_global(h->this, 0);
				Marked = has_ast();
			}
#else
			Marked  = oMarked;
			restor_ast(oCS);
#endif
			putseq_lst(h->this, level);
		}
	} else
	{	if (e->n && e->n->ntyp == ATOMIC)
		{	patch_atomic(e->n->seql->this);
			putskip(e->n->seql->this->frst->seqno);
			a = huntstart(e->n->seql->this->frst);
			fprintf(tt, "\tT = trans[%d][%d] = ", Pid, e->seqno);
			fprintf(tt, "settr(%d,0,0,0,\"", ATOM, e->n->ntyp);
			comment(tt, e->n, e->seqno);
			fprintf(tt, "\", 0, %d);\t/* line %d */\n",
				e->n->ntyp, e->n->nval);
			fprintf(tt, "\t    T->nxt\t= ");

			fprintf(tt, "settr(%d,%d,0,0,\"", ATOM, a, e->n->ntyp);
			comment(tt, e->n, e->seqno);
			fprintf(tt, "\", 0, %d);\t/* line %d (%d,%d) */\n",
				e->n->ntyp, e->n->nval, Marked, level);
			e->n->seql->this->last->nxt = e->nxt;
#ifdef GODEF
			/*
			 * if the statements in an atomic sequence
			 * touch global objects, the guard(s) must
			 * be labeled with all conflict sets touched
			 */
			if (has_ast())
			{	fprintf(stderr, "internal error: ast stack\n"); 
				pop_ast(stderr, 0);
				exit(1);
			}
			coll_global(e->n->seql->this, 0);
			Marked = has_ast();
			aMarked = 1;
#endif
			putseq_lst(e->n->seql->this, level);
#ifdef GODEF
			Marked = 0; aMarked = 0;
#endif
			return;
		}
		if (e->n->ntyp == GOTO)
			a = huntele(get_lab(e->n->nsym),
					e->status)->seqno;
		else if (e->nxt)
			a = huntele(e->nxt, e->status)->seqno;
		else
			a = 0;
		fprintf(tt, "\tT = trans[%d][%d]\t= ",
					Pid, e->seqno);

		putfair(tf, e->n, e->seqno, uniq);

		fprintf(tm, "\tcase  %d: /* STATE ", uniq++);
		fprintf(tm, "%d, ", e->seqno);
		comment(tm, e->n, e->seqno);
		fprintf(tm, ", line %d (Marked %d, level %d, status %d/%d) */\n\t\t",
			e->n->nval, Marked, level, e->status, e->status&ATOM);
		if (e->n && e->n->ntyp != 'r' && Pid != claimnr)
			fprintf(tm, "IfNotBlocked\n\t\t");
		putstmnt(tm, e->n, e->seqno);
#ifdef VARSTACK
/*
 * warning: checklast() in dflow.c
 * is an untrusted optimization
 *			Cksum=rand();
 *			if (Pid != claimnr)
 *				bu = checklast(tm, e->n, e->nxt, e->seqno, 1);
 *			else
 */
#endif
			bu = 0;
		n = getweight(e->n);
		fprintf(tm, ";\n\t\tm = %d;\n\t\t", n);
#ifdef GODEF
		Countm = 0;
		if (any_cs(e->n)) push_cs(tm, e->n, 0);
		Maxcs = max(Countm, Maxcs);
#endif
		if (bu == 0) bu = 2;
		fprintf(tm, "goto P999;\n", n);
		if (bu || any_undo(e->n))
		{
			fprintf(tb, "\tcase  %d: ", uniq-1);
			fprintf(tb, "/* STATE ");
			fprintf(tb, "%d, ", e->seqno);
			comment(tb, e->n, e->seqno);
		fprintf(tb, ", line %d (Marked %d, level %d, status %d/%d) */\n\t\t",
		e->n->nval, Marked, level, e->status, e->status&ATOM);
#ifdef VARSTACK
			if (bu == 1)
				checklast(tb, e->n, e->nxt, e->seqno, 0);
#endif
			if (any_undo(e->n))
				undostmnt(e->n, e->seqno);
			fprintf(tb, ";\n\t\t");
#ifdef GODEF
		Countm = 0;
		/* DO combine the conflict sets in the backward move */
		if (Marked)	/* guard of an atomic sequence -with globals- */
			pop_ast(tb, 1);
		else
		{	if ((e->status&ATOM) == 0 && (e->status&L_ATOM) == 0)
			{	if (any_cs(e->n))	/* globals touched */
					push_cs(tb, e->n, 1);
				else			/* locals only */
				{	Countm++;
					fprintf(tb, "push_act(II, R_LOCK, BLOCK, ");
					fprintf(tb, "t->forw, MAXCONFL);\n\t\t");
				}
			} else if (aMarked)	/* guard of local at.seq. */
			{	Countm++;
				fprintf(tb, "push_act(II, R_LOCK, BLOCK, ");
				fprintf(tb, "t->forw, MAXCONFL);\n\t\t");
			}
		}
		Maxcs = max(Countm, Maxcs);
#endif
			fprintf(tb, "goto R999;\n");
			fprintf(tt, "settr(%d,%d,%d,%d,\"",
				e->status, a, uniq-1, uniq-1, e->n->ntyp);
		} else
			fprintf(tt, "settr(%d,%d,%d,0,\"",
				e->status, a, uniq-1, e->n->ntyp);
		comment(tt, e->n, e->seqno);
		if (Marked)	/* globals are touched later in an atomic s. */
			Globalname=1;
		fprintf(tt, "\", %d, %d);\t/* line %d (%d,%d) */\n",
			1-Globalname, e->n->ntyp, e->n->nval, Marked, level);
		Marked = 0; aMarked = 0;
	}
}

void
patch_atomic(s)
	Sequence *s;
{	/* catch goto's that break the chain */
	Element *f, *g;
	SeqList *h;
	for (f = s->frst; ; f = f->nxt)
	{	if (f->n && f->n->ntyp == GOTO)
		{	g = get_lab(f->n->nsym);
			if ((f->status & ATOM)
			&& !(g->status & ATOM))
			{	f->status &= ~ATOM;
				f->status |= L_ATOM;
			}
		} else
		for (h = f->sub; h; h = h->nxt)
			patch_atomic(h->this);
		if (f == s->last)
			break;
	}
}

#ifdef GODEF

int Mustwrite = 0;

any_cs(now)
	Node *now;
{
	Node *v;

	if (!now) { return; }
	switch (now->ntyp) {
	
	case CONST:  case  'q': case '.':
	case BREAK:  case GOTO: case '@':
	case ATOMIC: case   IF: case DO:
			return 0;

	case 'p':	/* XXXXX forbid rem ref of locals - handle _p */
		return 0;

	case 'c': case '!': case LEN:
	case UMIN: case ASSERT:
	case '~':	return any_cs(now->lft);

	case '/': case '*': case '-': case '+':
	case '%': case '<': case '>': case '&':
	case '|': case LE: case GE: case NE:
	case EQ: case OR: case AND: case LSHIFT: case RSHIFT: case ASGN:
			return any_cs(now->lft)|any_cs(now->rgt);

	case RUN:
	case PRINT:	for (v = now->lft; v; v = v->rgt)
				if (any_cs(v->lft))
					return 1;
			return 0;

	case TIMEOUT:
	case 'r':
	case 's':
	case 'R':	return 1;

	case NAME:	if (!now->nsym->context
			||  now->nsym->type == CHAN)	/* global or chan */
				return 1;
			if (now->nsym->nel != 1)
				return any_cs(now->lft);
			return 0;
	}
	fprintf(stderr, "cannot happen %d\n", now->ntyp);
	return 0;
}

void
coll_cs(now)
	Node *now;
{
	Node *v;

	if (!now) { return; }
	switch (now->ntyp) {
	case 'c': case '!':
	case UMIN: case ASSERT:
	case '~':	coll_cs(now->lft);
			break;

	case '/': case '*': case '-': case '+':
	case '%': case '<': case '>': case '&':
	case '|': case LE: case GE: case NE:
	case EQ: case OR: case AND: case LSHIFT: case RSHIFT:
			coll_cs(now->lft);
			coll_cs(now->rgt);
			break;

	case PRINT:
	case RUN:	for (v = now->lft; v; v = v->rgt)
				coll_cs(v->lft);
			break;

	case ASGN:	coll_base("W_LOCK", Direct, now->ntyp, now->lft);
			coll_indx(now->lft);
			coll_cs(now->rgt);
			break;

	case 'r':	coll_base("R_LOCK", Direct, now->ntyp, now->lft);
			coll_base("Rcv_LOCK", Indirect, now->ntyp, now->lft);
			coll_indx(now->lft);

			Mustwrite = 1;
			for (v = now->rgt; v; v = v->rgt)
				coll_cs(v->lft);
			Mustwrite = 0;
			break;

	case 's':	coll_base("R_LOCK", Direct, now->ntyp, now->lft);

			coll_base("Snd_LOCK", Indirect, now->ntyp, now->lft);
			coll_indx(now->lft);

			for (v = now->rgt; v; v = v->rgt)
				coll_cs(v->lft);
			break;

	case 'R':	coll_base("R_LOCK", Direct, now->ntyp, now->lft);

			coll_base("R_LOCK", Indirect, now->ntyp, now->lft);
			coll_indx(now->lft);

			for (v = now->rgt; v; v = v->rgt)
				coll_cs(v->lft);
			break;
	case TIMEOUT:	coll_base("R_LOCK", Direct, now->ntyp, 0);
			break;
	case LEN:	coll_base("R_LOCK", Direct, now->ntyp, now->lft);

			coll_base("R_LOCK", Indirect, now->ntyp, now->lft);
			coll_indx(now->lft);
			break;

	case NAME:	coll_base((Mustwrite)?"W_LOCK":"R_LOCK", Direct, now->ntyp, now);
			coll_indx(now);
			break;

	case CONST:
	case   'p':	
	case   'q':
	default   :	break;
	}
}

void
push_loss(fd, now, How)
	FILE *fd;
	Node *now;
{
	Node *v;
	/* special case: update the conflict sets when
	 * a message loss on option -m occurs
	 * it counts as a read on the channel id
	 */
	putbase(fd, "R_LOCK", How, now->lft);
	fprintf(fd, "push_act(II, R_LOCK, %s, t->forw, ",
		(How == 0)?"REL":"BLOCK");
	putname(fd, "1+MAXCONFL+", now->lft, 0, ");\n\t\t");
	putindex(fd, now->lft, How);
	for (v = now->rgt; v; v = v->rgt)
		push_cs(fd, v->lft, How);
}

void
push_cs(fd, now, How)	/* How = 0, before; How = 1, after */
	FILE *fd;
	Node *now;
{
	Node *v;

	if (!now) { return; }
	switch (now->ntyp) {
	case 'c': case '!':
	case UMIN: case ASSERT:
	case '~':	push_cs(fd,now->lft, How);
			break;

	case '/': case '*': case '-': case '+':
	case '%': case '<': case '>': case '&':
	case '|': case LE: case GE: case NE:
	case EQ: case OR: case AND: case LSHIFT: case RSHIFT:
			push_cs(fd, now->lft, How);
			push_cs(fd, now->rgt, How);
			break;

	case PRINT:
	case RUN:	for (v = now->lft; v; v = v->rgt)
				push_cs(fd, v->lft, How);
			break;

	case ASGN:	putbase(fd, "W_LOCK", How, now->lft);
			if (now->lft->nsym->nel != 1)
				push_cs(fd, now->lft->lft, How);
			push_cs(fd, now->rgt, How);
			break;

	case 'r':	fprintf(fd, "{ int L_typ = Rcv_LOCK;\n");
			fprintf(fd, "#if SYNC\n");
			fprintf(fd, "\t\tint od=depth;\n");
			fprintf(fd, "#if ASYNC\n");
			putname(fd, "\t\tif (q_zero(", now->lft, 0, "))\n");
			fprintf(fd, "#endif\n");
			fprintf(fd, "\t\t{	depth--; L_typ = Snd_LOCK; }\n");
			/*
			 * depth is decremented here to make sure these
			 * blocks are committed to and unpushed by the
			 * send half of the rendezvous
			 */
			fprintf(fd, "#endif\n\t\t");
			putbase(fd, "R_LOCK", How, now->lft);
			Countm++;
			fprintf(fd, "push_act(II, L_typ, %s, t->forw, ",
				(How == 0)?"REL":"BLOCK");
			putname(fd, "1+MAXCONFL+", now->lft, 0, ");\n\t\t");
			putindex(fd, now->lft, How);
			Mustwrite = 1;
			for (v = now->rgt; v; v = v->rgt)
				push_cs(fd, v->lft, How);
			Mustwrite = 0;
			fprintf(fd, "\n#if SYNC\n");
			fprintf(fd, "		depth = od;\n");
			fprintf(fd, "#endif\n");
			fprintf(fd, "		}\n\t\t");
			break;

	case 's':	if (How == 1)	/* lock rv's only at receive point */
			{	fprintf(fd, "if (SYNC == 0 || !q_zero");
				putname(fd, "(", now->lft, 0, ")) {\n\t\t");
			}
			putbase(fd, "R_LOCK", How, now->lft);
			Countm++;
			fprintf(fd, "push_act(II, Snd_LOCK, %s, t->forw, ",
				(How == 0)?"REL":"BLOCK");
			putname(fd, "1+MAXCONFL+", now->lft, 0, ");\n\t\t");
			putindex(fd, now->lft, How);
			for (v = now->rgt; v; v = v->rgt)
				push_cs(fd, v->lft, How);
			if (How == 1)
				fprintf(fd, "}\n\t\t");
			break;

	case 'R':	putbase(fd, "R_LOCK", How, now->lft);
			Countm++;
			fprintf(fd, "push_act(II, R_LOCK, %s, t->forw, ",
				(How == 0)?"REL":"BLOCK");
			putname(fd, "1+MAXCONFL+", now->lft, 0, ");\n\t\t");
			putindex(fd, now->lft, How);
			for (v = now->rgt; v; v = v->rgt)
				push_cs(fd, v->lft, How);
			break;

	case LEN:	putbase(fd, "R_LOCK", How, now->lft);
			Countm++;
			fprintf(fd, "push_act(II, R_LOCK, %s, t->forw, ",
				(How == 0)?"REL":"BLOCK");
			putname(fd, "1+MAXCONFL+", now->lft, 0, ");\n\t\t");
			putindex(fd, now->lft, How);
			break;

	case NAME:	putbase(fd, (Mustwrite)?"W_LOCK":"R_LOCK", How, now);
			if (now->nsym->nel != 1)
				push_cs(fd, now->lft, How);
			break;
	case TIMEOUT:	fprintf(fd, "push_act(II, R_LOCK, %s, t->forw, ",
				(How == 0)?"REL":"BLOCK");
			fprintf(fd, "CS_timeout);\n\t\t");
			break;
	case   'p':	
	case   'q':
	case CONST:
	default   :	break;
	}
}
#endif

#define cat0(x)   	putstmnt(fd,now->lft,m); fprintf(fd, x); \
			putstmnt(fd,now->rgt,m)
#define cat1(x)		fprintf(fd,"("); cat0(x); fprintf(fd,")")
#define cat2(x,y)  	fprintf(fd,x); putstmnt(fd,y,m)
#define cat3(x,y,z)	fprintf(fd,x); putstmnt(fd,y,m); fprintf(fd,z)

void
putstmnt(fd, now, m)
	FILE *fd;
	Node *now;
{
	Node *v;
	int i, j;

	if (!now) { fprintf(fd, "0"); return; }
	if (now->ntyp != CONST) lineno = now->nval;
	switch (now->ntyp) {
	case CONST:	fprintf(fd, "%d", now->nval); break;
	case '!':	cat3("!(", now->lft, ")"); break;
	case UMIN:	cat3("-(", now->lft, ")"); break;
	case '~':	cat3("~(", now->lft, ")"); break;

	case '/':	cat1("/");  break;
	case '*':	cat1("*");  break;
	case '-':	cat1("-");  break;
	case '+':	cat1("+");  break;
	case '%':	cat1("%%"); break;
	case '<':	cat1("<");  break;
	case '>':	cat1(">");  break;
	case '&':	cat1("&");  break;
	case '|':	cat1("|");  break;
	case LE:	cat1("<="); break;
	case GE:	cat1(">="); break;
	case NE:	cat1("!="); break;
	case EQ:	cat1("=="); break;
	case OR:	cat1("||"); break;
	case AND:	cat1("&&"); break;
	case LSHIFT:	cat1("<<"); break;
	case RSHIFT:	cat1(">>"); break;

	case TIMEOUT:	fprintf(fd, "((trpt->tau)&1)"); break;

	case RUN:	if (claimproc
			&&  strcmp(now->nsym->name, claimproc) == 0)
				fatal("%s is claim, not runnable",
							claimproc);
			if (EVAL_runs)
			{	fprintf(fd, "(now._nr_pr < MAXPROC)");
				break;
			}
			fprintf(fd,"addproc(%d", fproc(now->nsym->name));
			for (v = now->lft; v; v = v->rgt)
			{	cat2(", ", v->lft);
			}
			fprintf(fd, ")");
			break;
	case LEN:	putname(fd, "q_len(", now->lft, m, ")");
			break;

	case 's':	fprintf(fd, "\n#if (SYNC>0 && ASYNC==0)\n\t\t");
			putname(fd, "if (q_len(", now->lft, m, "))\n");
			fprintf(fd, "#else\n\t\t");
			putname(fd, "if (q_full(", now->lft, m, "))\n");
			fprintf(fd, "#endif\n");
			if (m_loss)
			{	fprintf(fd, "\t\t{\n\t\tm=3; loss++;\n");
				fprintf(fd, "#ifdef DEBUG\n\t\t");
				fprintf(fd, "printf(\"loss on chan");
				putname(fd, " ", now->lft, m, "\\n\");\n");
				fprintf(fd, "#endif\n\t\t");
				push_loss(fd, now, 0);
				fprintf(fd, "goto P999;\n\t\t}\n\t\t");
			} else
				fprintf(fd, "\t\t\tcontinue;\n\t\t");
			putname(fd, "qsend(", now->lft, m, "");
			for (v = now->rgt, i = 0; v; v = v->rgt, i++)
			{	cat2(", ", v->lft);
			}
			if (i > Mpars)
				fatal("too many pars in send", "");
			for ( ; i < Mpars; i++)
				fprintf(fd, ", 0");
			fprintf(fd, ");\n");
			fprintf(fd, "#if SYNC\n#if ASYNC==0\n");
			putname(fd, "\t\tboq = ", now->lft, m, ";\n");
			fprintf(fd, "#else\n\t\t");
			putname(fd, "if (q_zero(", now->lft, m, ")) ");
			putname(fd, "boq = ",now->lft,m,";\n");
			fprintf(fd, "#endif\n#endif\n\t\t");
			break;
	case 'r':	fprintf(fd, "\n#if SYNC\n#if ASYNC==0\n");
			putname(fd, "\t\tif (boq != ", now->lft,m,")");
			fprintf(fd, " continue;\n#else\n");
			putname(fd, "\t\tif (q_zero(", now->lft,m,"))");
			fprintf(fd, "\n\t\t");
			putname(fd, "{	if (boq != ",  now->lft,m,")");
			fprintf(fd, " continue;\n\t\t} else\n\t\t");
			fprintf(fd, "{	if (boq != -1) continue;\n\t\t");
			fprintf(fd, "}\n#endif\n#endif\n\t\t");
			putname(fd, "if (q_len(", now->lft, m, ") == 0)");
			fprintf(fd, " continue");
	/* test */	for (v = now->rgt, i=j=0; v; v = v->rgt, i++)
			{	if (v->lft->ntyp != CONST)
				{	j++; continue;
				}
				fprintf(fd, ";\n\t\t");
				cat3("if (", v->lft, " != ");
				putname(fd, "qrecv(", now->lft, m, ", ");
				fprintf(fd, "0, %d, 0)) continue", i);
			}
			if (j > 0)
				fprintf(fd, ";\n\t\tsv_save()");
	/* set */	for (v = now->rgt, i = 0; v; v = v->rgt, i++)
			{	if (v->lft->ntyp == CONST && v->rgt)
					continue;
				fprintf(fd, ";\n\t\t");
				if (v->lft->ntyp != CONST)
				{	nocast=1;
					putstmnt(fd, v->lft, m);
					nocast=0; fprintf(fd, " = ");
				}
				putname(fd, "qrecv(", now->lft, m, "");
				fprintf(fd, ", 0, %d, ", i);
				fprintf(fd, "%d)", (v->rgt)?0:1);
			}
			fprintf(fd, ";\n#if SYNC\n");
			putname(fd, "\t\tif (q_zero(", now->lft, m, "");
			fprintf(fd, ")) boq = -1;\n#endif\n\t\t");
			break;
	case 'R':	putname(fd, "(q_len(", now->lft, m, ") > 0");
	/* test */	for (v = now->rgt, i=j=0; v; v = v->rgt, i++)
			{	if (v->lft->ntyp != CONST)
				{	j++; continue;
				}
				fprintf(fd, "\n\t\t&& qrecv(");
				putname(fd, "", now->lft, m, "");
				fprintf(fd, ", 0, %d, 0) == ", i);
				putstmnt(fd, v->lft, m);
			}
			fprintf(fd, ")");
			break;

	case 'c':	cat3("if (!(", now->lft, "))\n");
			fprintf(fd, "\t\t\tcontinue");
			break;
	case ASGN:	cat3("(trpt+1)->oval = ", now->lft, ";\n\t\t");
			nocast = 1; putstmnt(fd,now->lft,m); nocast = 0;
			fprintf(fd," = ");
			putstmnt(fd,now->rgt,m);
			break;
	case PRINT:	fprintf(fd, "printf(%s", now->nsym->name);
			for (v = now->lft; v; v = v->rgt)
			{	cat2(", ", v->lft);
			}
			fprintf(fd, ")");
			break;
	case NAME:	if (!nocast && now->nsym
			&&  now->nsym->type < SHORT)
				putname(fd, "((int)", now, m, ")");
			else
				putname(fd, "", now, m, "");
			break;
	case   'p':	putremote(fd, now, m);
			break;
	case   'q':	if (terse)
				fprintf(fd, "%s", now->nsym->name);
			else
				fprintf(fd, "%d", remotelab(now));
			break;
	case ASSERT:	cat3("assert(", now->lft, ", ");
			terse = nocast = 1;
			cat3("\"", now->lft, "\\n\", II, tt, t)");
			terse = nocast = 0;
			break;
	case   '.':
	case BREAK:
	case  GOTO:	putskip(m);
			break;
	case   '@':	if (EVAL_runs)
			{	fprintf(fd, "if (i+1 != now._nr_pr) continue");
				break;
			}
			fprintf(fd, "if (!delproc(1, II)) continue");
			fprintf(th, "#define endstate%d	%d\n", Pid, m);
			break;
	default   :	printf("spin: bad node type %d (.m)\n", now->ntyp);
			fflush(tm); fflush(tb);
			fflush(tc); fflush(th); fflush(tt);
			exit(1);
	}
}

putfair(fd, now, m, u)
	FILE *fd;
	Node *now;
{
	Node *v;
	int i, j;


	if (!now) { fprintf(fd, "0"); return; }
	switch (now->ntyp) {
	default:	fprintf(fd, "\tcase  %d:\n\t\t", u);
			EVAL_runs = 1;	/* don't execute a RUN or @ */
			putstmnt(fd, now, m);
			EVAL_runs = 0;
			fprintf(fd, ";\n\t\tbreak;\n");
			break;
	case ASSERT:
	case   '.':
	case BREAK:
	case  GOTO:
	case ASGN:
	case PRINT:	fprintf(fd, "\tcase  %d: break;\n", u);
			break;

	case 's':	if (m_loss)
			{	fprintf(fd, "\tcase  %d: break;\n", u);
				break;
			}
			fprintf(fd, "\tcase  %d:", u);
			fprintf(fd, "\n#if (SYNC>0 && ASYNC==0)\n\t\t");
			putname(fd, "if (q_len(", now->lft, m, ")) ");
			fprintf(fd, "\n#else\n\t\t");
			putname(fd, "if (q_full(", now->lft, m, ")) ");
			fprintf(fd, "\n#endif\n\t\t\t");
			fprintf(fd, "continue;\n");
			fprintf(fd, "\t\tbreak;\n");
			break;
	case 'r':	fprintf(fd, "\tcase  %d:", u);
			fprintf(fd, "\n#if SYNC\n#if ASYNC==0\n");
			putname(fd, "\t\tif (boq != ", now->lft,m,")");
			fprintf(fd, " continue;\n#else\n");
			putname(fd, "\t\tif (q_zero(", now->lft,m,"))");
			fprintf(fd, "\n\t\t");
			putname(fd, "{	if (boq != ",  now->lft,m,")");
			fprintf(fd, " continue;\n\t\t} else\n\t\t");
			fprintf(fd, "{	if (boq != -1) continue;\n\t\t");
			fprintf(fd, "}\n#endif\n#endif\n\t\t");
			putname(fd, "if (q_len(", now->lft, m, ") == 0)");
			fprintf(fd, " continue");
	/* test */	for (v = now->rgt, i=j=0; v; v = v->rgt, i++)
			{	if (v->lft->ntyp != CONST)
				{	j++; continue;
				}
				fprintf(fd, ";\n\t\t");
				cat3("if (", v->lft, " != ");
				putname(fd, "qrecv(", now->lft, m, ", ");
				fprintf(fd, "0, %d, 0)) continue", i);
			}
			fprintf(fd, ";\n\t\tbreak;\n");
			break;
	}
}

void
putbase(fd, what, when, n)
	FILE *fd;
	char *what;
	Node *n;
{
	if (n->nsym->context)
		return;	/* not a global */

	Countm++;
	fprintf(fd, "push_act(II, %s, %s, t->forw, CS_",
		what, (when == 0)?"REL":"BLOCK");
	fprintf(fd, "%s", n->nsym->name);
	if (n->nsym->nel > 1)
	{	fprintf(fd, "+");
		putstmnt(fd, n->lft, 0);
	}
	fprintf(fd, ");\n\t\t");
}

void
putindex(fd, n, How)
	FILE *fd;
	Node *n;
{
	if (Mustwrite != 0)
		fprintf(stderr, "cannot happen putindex\n");
	if (n->nsym->nel != 1)
		push_cs(fd, n->lft, How);

}

void
coll_indx(n)
	Node *n;
{
	if (n->nsym->nel != 1)
		coll_cs(n->lft);
}

void
coll_base(what, when, cause, n)
	char *what;
	Node *n;
{
	if (n && n->nsym->context)
		return;	/* not a global */
	push_ast(what, when, cause, n);
}

void
putname(fd, pre, n, m, suff)	/* varref */
	FILE *fd;
	Node *n;
	char *pre, *suff;
{
	Symbol *s = n->nsym;
	if (!s)
		fatal("no name - putname", "");
	if (!s->type)
		yyerror("undeclared name `%s'", s->name);

	if (!s->context || s->type == CHAN)
		Globalname = 1;
	fprintf(fd, pre);
	if (s->context || !strcmp(s->name, "_p"))
	{	if (!terse) fprintf(fd, "((P%d *)this)->", Pid);
		fprintf(fd, "%s", s->name);
	} else
	{	if (!terse) fprintf(fd, "now.");
		fprintf(fd, "%s", s->name);
	}
	if (s->nel != 1)
	{	cat3("[ Index(", n->lft, ", ");	/* BOUNDCHECK */
		fprintf(fd, "%d) ]", s->nel);	/* BOUNDCHECK */
	}
	fprintf(fd, suff);
}

void
putremote(fd, n, m)		/* remote reference */
	FILE *fd;
	Node *n;
{
	int promoted = 0;

	if (terse)
	{	fprintf(fd, "%s[", n->lft->nsym->name);
		putstmnt(fd, n->lft->lft, m);
		if (strcmp(n->nsym->name, "_p") == 0)
			fprintf(fd, "]:");
		else
			fprintf(fd, "].%s", n->nsym->name);
	} else
	{	if (n->nsym->type < SHORT && !nocast)
		{	promoted = 1;
			fprintf(fd, "((int)");
		}
		fprintf(fd, "((P%d *)Pptr(loops+",
			fproc(n->lft->nsym->name));
		if (claimproc) fprintf(fd, "1+");
		putstmnt(fd, n->lft->lft, m);
		fprintf(fd, "))->%s", n->nsym->name);
#if 0
		if (strcmp(n->nsym->name, "_p") == 0)
			XXXXX READING _p XXXXX
#endif
	}
	if (n->rgt)
	{	fprintf(fd, "[");	/* cannot do BOUNDCHECK */
		putstmnt(fd, n->rgt, m);
		fprintf(fd, "]");
	}
	if (promoted) fprintf(fd, ")");
}

getweight(n)
	Node *n;
{
	switch (n->ntyp) {
	case 'r':     return 4;
	case 's':     return 2;
	case TIMEOUT: return 1;	/* lowest priority */
	case 'c':     if (has_typ(n->lft, TIMEOUT)) return 1;
	}
	return 3;
}

has_typ(n, m)
	Node *n;
	short m;
{
	if (!n) return 0;
	if (n->ntyp == m) return 1;
	return (has_typ(n->lft, m) || has_typ(n->rgt, m));
}
