/***** spin: pangen1.h *****/

char *Header[] = {
	"#define qptr(x)	(((uchar *)&now)+q_offset[x])",
	"#define pptr(x)	(((uchar *)&now)+proc_offset[x])",
	"#define Pptr(x)	((proc_offset[x])?pptr(x):noptr)",
	"#define q_sz(x)	(((Q0 *)qptr(x))->Qlen)\n",
	"#define MAXQ   	255",
	"#define MAXPROC	255",
	"#define WS		sizeof(long)   /* word size in bytes */",
	"#ifndef VECTORSZ",
	"#define VECTORSZ	1024           /* sv   size in bytes */",
	"#endif",
	"extern char *malloc(), *memcpy(), *memset();",
	"extern void exit();",
	"extern int abort();\n",
	"typedef struct Stack  {	 /* for queues and processes */",
	"	short o_delta;",
	"	short o_offset;",
	"	short o_skip;",
	"	short o_delqs;",
	"	char *body;",
	"	struct Stack *nxt;",
	"	struct Stack *lst;",
	"} Stack;\n",
	"typedef struct Svtack { /* for complete state vector */",
	"	short o_delta;	 /* current size of frame */",
	"	short m_delta;	 /* maximum size of frame */",
	"#if SYNC",
	"	short o_boq;",
	"#endif",
	"	int j1, j2;	/* loop detection */",
	"	char *body;",
	"	struct Svtack *nxt;",
	"	struct Svtack *lst;",
	"} Svtack;\n",
#ifdef VARSTACK
	"typedef struct Varstack {",
	"	int val;",
	"	int cksum;	/* debugging only */",
	"	struct Varstack *nxt;",
	"	struct Varstack *lst;",
	"} Varstack;\n",
#endif
#ifdef GODEF
	"#define UNUSED	0",
	"#define R_LOCK		0",
	"#define W_LOCK		1",
	"#define Snd_LOCK	2",
	"#define Rcv_LOCK	3",
	"#define NLOCKS		4",
	"#define BLOCK	1",
	"#define REL	2",	
	"typedef struct CS_stack {",
	"	short status;	/* -1,0,1,2 = pending, unused, blocked, released */",
	"	short reason;	/*  0..NLOCKS = blocked by R,W,Snd, or Rcv */",
	"	short delta;	/* the amount of an increment or decrement */",
	"	short pid, stmnt, cs;",
	"	int depth;",
	"	struct CS_stack *nxt;",
	"	struct CS_stack *lst;",
	"} CS_stack;\n",
#endif
	"typedef struct Trans {",
	"	short atom;	/* is this an atomic transition */",
	"	short st;	/* the nextstate */",
	"	short ist;	/* intermediate state */",
#ifdef GODEF
	"	short local;	/* 1 iff this option is local */",
	"	short Local;	/* 1 iff all other options are also local */",
#endif
	"	char *tp;	/* source text of the forward move */",
	"	char ntp;	/* ntyp of the state, e.g. `r', `c' etc */",
	"	int forw;	/* index for forward transition */",
	"	int back;	/* index for return  transition */",
	"	struct Trans *nxt;",
	"} Trans;\n",
	"Trans ***trans;	/* 1 ptr per state per proctype */\n",
	"int depthfound = -1;	/* loop detection */",
	"short proc_offset[MAXPROC], proc_skip[MAXPROC];",
	"short q_offset[MAXQ], q_skip[MAXQ];",
	"short vsize;		/* vector size in bytes */",
	"short boq = -1;	/* blocked_on_queue status */",
#ifdef GODEF
	"short tratable[MAXPROC]; /* no of 1st trans of each proctype */",
#endif
	"typedef struct State {",
	"	uchar _nr_pr;",
	"	uchar _nr_qs;",
	"	uchar _p_t; /* loop detection */",
	"	uchar _a_t; /* acceptance cycle dectection */",
	0,
};

char *Addp0[] = {
	/* addproc(....parlist... */ ")",
	"{",
	"	int j, h = now._nr_pr;",
	"	if (h >= MAXPROC)",
	"		Uerror(\"too many processes\");",
	"	switch (n) {",
	"	case 0: j = sizeof(P0); break;",
	0,
};

char *Addp1[] = {
	"	default: Uerror(\"bad proc - addproc\");",
	"	}",
	"	if (vsize%%WS && (j > WS-(vsize%%WS)))",
	"	{	proc_skip[h] = WS-(vsize%%WS);",
	"		vsize += proc_skip[h];",
	"	} else",
	"		proc_skip[h] = 0;",
	"	proc_offset[h] = vsize;",
	"	now._nr_pr += 1;",
	"	vsize += j;",
	"	hmax = max(hmax, vsize);",
	"	if (vsize >= VECTORSZ)",
	"		Uerror(\"VECTORSZ is too small, edit pan.h\");",
	"	memset((char *)pptr(h), 0, j);",
	"#ifdef DEBUG",
	"	printf(\"added proc %%d type %%d\\n\", h, n);",
	"#endif",
	"	switch (n) {",
	0,
};

char *Addq0[] = {
	"addqueue(n)",
	"{	int j=0, i = now._nr_qs;",
	"	if (i >= MAXQ)",
	"		Uerror(\"too many queues\");",
	"	switch (n) {",
	0,
};

char *Addq1[] = {
	"	default: Uerror(\"bad queue - addqueue\");",
	"	}",
	"	if (vsize%%WS && (j > WS-(vsize%%WS)))",
	"	{	q_skip[i] = WS-(vsize%%WS);",
	"		vsize += q_skip[i];",
	"	} else",
	"		q_skip[i] = 0;",
	"	q_offset[i] = vsize;",
	"	now._nr_qs += 1;",
	"	vsize += j;",
	"	hmax = max(hmax, vsize);",
	"	if (vsize >= VECTORSZ)",
	"		Uerror(\"VECTORSZ is too small, edit pan.h\");",
	"	memset((char *)qptr(i), 0, j);",
	"	((Q0 *)qptr(i))->_t = n;",
	"#ifdef DEBUG",
	"	printf(\"added q %%d type %%d\\n\", i, n);",
	"#endif",
	"	return i+1;",
	"}\n",
	0,
};

char *Addq11[] = {
	"{	int j; uchar *z;\n",
	"	if (!into--)",
	"	uerror(\"reference to uninitialized chan name (sending)\");",
	"	if (into >= now._nr_qs || into < 0)",
	"		Uerror(\"qsend bad queue#\");",
	"	z = qptr(into);",
	"	switch (((Q0 *)qptr(into))->_t) {",
	0,
};

char *Addq2[] = {
	"	case 0: printf(\"queue was deleted\\n\");",
	"	default: Uerror(\"bad queue - qsend\");",
	"	}",
	"#ifdef DEBUG",
	"#if SYNC+ASYNC",
	"	printf(\"sent to %%d(%%d,..) [%%d]\\n\", into,fld0,j);",
	"#endif",
	"#endif",
	"}\n",
	"#if SYNC==0",
	"q_zero(from) { /* for picky compilers */ }",
	"#endif",
	"#if SYNC",
	"q_zero(from)",
	"{",
	"	if (!from--)",
	"	uerror(\"reference to uninitialized chan name (receiving)\");",
	"	switch(((Q0 *)qptr(from))->_t) {",
	0,
};

char *Addq3[] = {
	"	case 0: printf(\"queue was deleted\\n\");",
	"	}",
	"	Uerror(\"bad queue q-zero\");",
	"}",
	"#endif",
	"q_len(x)",
	"{	if (!x--) uerror(\"reference to uninitialized chan name\");",
	"	return ((Q0 *)qptr(x))->Qlen;",
	"}\n",
	"q_full(from)",
	"{	if (!from--)",
	"	uerror(\"reference to uninitialized chan name (sending)\");",
	"	switch(((Q0 *)qptr(from))->_t) {",
	0,
};

char *Addq4[] = {
	"	case 0: printf(\"queue was deleted\\n\");",
	"	}",
	"	Uerror(\"bad queue - q_full\");",
	"}\n",
	"qrecv(from, slot, fld, done)",
	"{	uchar *z;",
	"	int j, k, r=0;",
	"	if (!from--)",
	"	uerror(\"reference to uninitialized chan name (receiving)\");",
	"	if (from >= now._nr_qs || from < 0)",
	"		Uerror(\"qrecv bad queue#\");",
	"	z = qptr(from);",
	"	switch (((Q0 *)qptr(from))->_t) {",
	0,
};

char *Addq5[] = {
	"	case 0: printf(\"queue was deleted\\n\");",
	"	default: Uerror(\"bad queue - qrecv\");",
	"	}",
	"#ifdef DEBUG",
	"	printf(\"recv from %%d,%%d,%%d,%%d = %%d\\n\",",
	"			from, slot, fld, done, r);",
	"#endif",
	"	return r;",
	"}\n",
	0,
};

char *Code0[] = {
	"run()",
	"{	memset((char *)&now, 0, sizeof(State));",
	"	vsize = sizeof(State) - VECTORSZ;",
	"	settable();",
	0,
};
char *Code1[] = {
	"#define CONNECT	%d /* accept labels */",
	0,
};
char *Code2[] = {
	"	UnBlock;	/* disable rendez-vous */",
	"#ifdef BITSTATE",
	"	SS = (uchar *) emalloc(1<<(ssize-3));",
	"	if (loops)",
	"	LL = (uchar *) emalloc(1<<(ssize-3));",
	"#else",
	"	hinit();",
	"#endif",
	"	stack	= ( Stack *) emalloc(sizeof(Stack));",
	"	svtack	= (Svtack *) emalloc(sizeof(Svtack));",
#ifdef VARSTACK
	"	varstack= (Varstack *) emalloc(sizeof(Varstack));",
#endif
#ifdef GODEF
	"	cs_stack= (CS_stack *) emalloc(sizeof(CS_stack));",
	"	cs_stack->depth = -1;	/* avoid a false match */",
#endif
	"	/* a place to point for Pptr of non-running procs: */",
	"	noptr	= (uchar *) emalloc(Maxbody * sizeof(char));",
	"	addproc(0);	/* init */",
	"	depth=mreached=0;",
	"	trpt = &trail[depth];",
	"	new_state();",
	"}\n",

	"#ifdef JUMBO",
	"/** EXPERIMENTAL **/",
	"Trans *",
	"jumbostep(short II)",
	"{	register Trans *t, *T = 0; char m, ot; short tt;",
	"	/* assume this has already been set */",
	"#ifdef ALG3",
	"	printf(\"sorry: cannot combine -DJUMBO with -DALG3\\n\");",
	"	exit(1);",
	"#endif",

	"	sv_save();	/* remember where we came from */",
	"#ifdef DEBUG",
	"	printf(\"%%d: process %%d sv jumbo starter\\n\", depth, II);",
	"	fflush(stdout);",
	"#endif",
	"	tt = (short) ((P0 *)this)->_p;",
	"	ot = (uchar) ((P0 *)this)->_t;",
	"chain:",
	"	for (t = trans[ot][tt]; t; t = t->nxt)",
	"#include \"pan.m\"",
	"P999:",
	"	if (m == 0)",
	"	{	printf(\"cannot happen - jumbostep\\n\");",
	"		return;",
	"	}",
	"#ifdef DEBUG",
	"	printf(\"%%3d: proc %%d exec %%d, jumbostep from %%d to %%d\", ",
	"		depth, II, t->forw, tt, t->st);",
	"	printf(\" %%s\\n\", Moves[t->forw]);",
	"#endif",
	"	if (!T) T = t;",
	"	if (t->st)",
	"	{	tt = ((P0 *)this)->_p = t->st;",
	"		reached[ot][t->st] = 1;",
	"		if (trans[ot][tt]->Local > 1)",
	"			goto chain;",
	"	}",
	"	return T;",
	"}",
	"/** END **/",
	"#endif",

	"new_state()",
	"{	register Trans *t;",
	"	char n, m, ot, match_type;",
	"	short II, tt;\n",
	"	short From = now._nr_pr-1;",
	"	short To = 0;",
#ifdef GODEF
	"	char presel;",
#endif
	"Down:",
#ifdef GODEF
	"	presel=0;",
#endif
	"	if (now._p_t && prognow()) /* loop detection */",
#ifdef GODEF
	"	{	trpt->tau |= 16; /* pm for 1 level up */",
	"		goto Up;",
	"	}",
#else
	"		goto Up;",
#endif
	"	if (depth >= maxdepth)",
	"	{	truncs++;",
	"#ifdef DEBUG",
	"		printf(\"depth limit!\\n\");",
	"#endif",
	"#if SYNC",
	"		(trpt+1)->o_n = 1; /* not a deadlock */",
	"#endif",
	"		goto Up;",
	"	}",
	"#ifdef DEBUG",
	"	printf(\"down %%d\\n\", depth); fflush(stdout);",
	"#endif",
	"#ifdef VERI",
	"	if (!(trpt->tau&4))	/* if no claim move */",
	"#endif",
	"#if SYNC>0",
	"	if (boq == -1)		/* if not mid-rv */",
	"#endif",
	"	if (!(trpt->tau&8))	/* if no atomic move */",
	"	{",
	"#ifdef BITSTATE",
	"		d_hash((uchar *) &now, vsize);",
	"		j3 = (1<<(J1&7)); j1 = J1>>3;",
	"		j4 = (1<<(J2&7)); j2 = J2>>3;",
	"		if ((SS[j2]&j3) && (SS[j1]&j4))",
	"#else",

	"#ifdef CACHE",
	"		if ((match_type = nh_store((char *)&now, vsize)) != 0)",
	"#else",
	"		if ((match_type = hstore((char *)&now, vsize)) != 0)",
	"#endif",

	"#endif",
	"		{	truncs++;",
	"#ifdef DEBUG",
	"			printf(\"truncated %%s (tau is %%d)\\n\",",
	"				(match_type==2)?\"on stack\":\"\", trpt->tau);",
	"#endif",
	"			if (match_type == 2)",
	"				trpt->tau |= 16; /* pm for 1 level up */",

	"#if CONNECT>0",
	"			if (now._a_t && depth > A_depth)",
	"			{	if (memcmp((char *)&A_Root, (char *)&now, vsize) == 0)",
	"				{	if (fair_cycle())",
	"					uerror(\"acceptance cycle\");",
	"					if (depth > 0) goto Up; else return;",
	"				}",
	"#ifdef DEBUG",
	"				else printf(\"acceptor: not a match\\n\");",
	"#endif",
	"			}",
	"#endif",

	"#ifdef BITSTATE",
	"			if (loops && now._p_t",
	"			&& LL[j1] && LL[j2] && onstack())",
	"			{	if (fair_cycle())",
	"				uerror(\"non-progress cycle\");",
	"			}",
	"#endif",
	"			if (depth > 0) goto Up; else return;",
	"		}",
	"#ifdef BITSTATE",
	"		SS[j2] |= j3; SS[j1] |= j4;",
	"		if (loops)",
	"		{	sv_save();",
	"			LL[j1]++; LL[j2]++;",
	"			svtack->j1 = J1;",
	"			svtack->j2 = J2;",
	"		}",
	"#endif",
	"		nstates++;",
	"	}",
	"	if (depth > mreached)",
	"		mreached = depth;",
	"	n = 0;",
	"#if SYNC",
	"	(trpt+1)->o_n = 0;",
	"#endif",
	"#ifdef VERI",
	"	if (now._nr_pr < 2",
	"	|| ((P0 *)pptr(1))->_p == endclaim)",
	"		uerror(\"claim violated!\");",
	"	if (stopstate[VERI][((P0 *)pptr(1))->_p])",
	"		uerror(\"endstate in claim reached\");",
	"Stutter:",
	"	if (trpt->tau&4)	/* must make a claimmove */",
	"	{	II = 1;",
	"		goto Veri0;",
	"	}",
	"#endif",
#ifdef GODEF
	"	if (boq != -1) nlinks++;	/* compatibility with patrice */",
	"#ifndef NOALG2",
	"	if (boq == -1 && From != To)",
	"	for (II = From; II >= To; II -= 1)	/* pre-scan */",
	"	{",
	"Resume:	/* pick up here when a first pre-selection failed */",
	"#ifdef VERI",
	"		if (II == 1) continue;",
	"#endif",
	"		this = pptr(II);",
	"		tt = (short) ((P0 *)this)->_p;",
	"		ot = (uchar) ((P0 *)this)->_t;",
	"		for (t = trans[ot][tt]; t; t = t->nxt)",
	"		{	if (!t->local)",
	"				goto Trynext;",
	"		}",
	"		From = To = II;	/* all moves are local */",
	"		presel = 1;	/* in case we get stuck */",
	"#ifdef DEBUG",
	"		printf(\"%%d: PRESELECT proc %%d\\n\", depth, II);",
	"#endif",
	"		break;",
	"Trynext:	;",
	"	}",
	"#endif",
#endif
	"\nAgain:",
	"	for (II = From; II >= To; II -= 1)",
	"	{",
	"#ifdef VERI",
	"		if (II == 1) continue;",
	"#endif",
	"Veri0:		this = pptr(II);",
	"		tt = (short) ((P0 *)this)->_p;",
	"		ot = (uchar) ((P0 *)this)->_t;",
	"#ifdef JUMBO",
	"/** EXPERIMENTAL **/",
	"		if(trans[ot][tt]->Local > 1)",
	"		{	t = jumbostep(II);",
	"			m = 3;",
	"			depth++; trpt++;",
	"			trpt->pr = II;",
	"			trpt->st = tt;",
	"			goto Q999;",
	"		}",
	"/** END **/",
	"#endif",
	"#ifdef DEBUG",
	"		printf(\"%%d: proc %%d, state %%d\\n\", depth, II, tt);",
	"		fflush(stdout);",
	"#endif",
	"		for (t = trans[ot][tt]; t; t = t->nxt)",
	"		{",
#ifdef GODEF
	"#ifdef ALG3",
	"			if (now._p_t == 0)",
	"			if (csets[II][t->forw] > 0)",
	"			{",
	"#ifdef DEBUG",
	"printf(\"%%d: proc %%d / %%d BLOCKED from %%d to %%d\\n\", ",
	"		depth, II, t->forw, tt, t->st);",
	"	{ int xx; for (xx = 0; xx < TOPQ; xx++)",
	"	  { if (nwait[xx]) printf(\"\\tnwait[%%d]=%%d\\n\", xx, nwait[xx]);",
	"	    if (csems[II][xx]) printf(\"\\tcsems[pid][%%d]=%%d\\n\", xx, csems[II][xx]);",
	"	  }",
	"	}",
	"#endif",
	"				continue;",
	"			}",
	"#endif",
#endif
	"#include \"pan.m\"",
	"P999:			/* jumps here when move succeeds */",
	"#ifdef ALG3",
	"			if (Nwait > 0)",
	"				rel_all_blocks(II);",
	"#endif",
	"#ifdef VERBOSE",
	"	printf(\"%%3d: proc %%d exec %%d, from %%d to %%d %%s\\n\", ",
	"		depth, II, t->forw, tt, t->st, Moves[t->forw]);",
	"#ifdef ALG3",
	"			dumpsleep(\"new_state\");",
	"#endif",
	"#endif",
	"			depth++; trpt++;",
	"			trpt->pr = II;",
	"			trpt->st = tt;",
	"			if (t->st)",
	"			{	((P0 *)this)->_p = t->st;",
#if 0
					XXXXX WRITING _p XXXXX
#endif
	"				reached[ot][t->st] = 1;",
	"			}",
	"Q999:			trpt->o_t  =  t; trpt->o_n  = n;",
	"			trpt->o_ot = ot; trpt->o_tt = tt;",
	"			trpt->o_To = To; trpt->o_m  = m;",
	"			trpt->tau = 0;",
	"			if (t->atom&2)",
	"			{	trpt->tau |= 8;",
	"#ifdef VERI",
	"				if((trpt-1)->tau&4)",
	"				  trpt->tau |= 4;",
	"				else",
	"				  trpt->tau &= ~4;",
	"			} else",
	"			{	if ((trpt-1)->tau&4)",
	"					trpt->tau &= ~4;",
	"				else",
	"					trpt->tau |= 4;",
	"			}",
	"#else",
	"			} else",
	"				trpt->tau &= ~8;",
	"#endif",
	"			if (boq == -1 && t->atom&2)",
	"			{	From = To = II; nlinks++;",
	"			} else",
	"			{	From = now._nr_pr-1; To = 0;",
	"			}",
#ifdef GODEF
	"			if (presel)",
	"			{",
	"#ifdef DEBUG",
	"	printf(\"%%d: confirming preselection\\n\", depth);",
	"#endif",
	"				(trpt-1)->tau |= 32;",
	"			} else {",
	"#ifdef DEBUG",
	"	printf(\"%%d: no preselection\\n\", depth);",
	"#endif",
	"				(trpt-1)->tau &= ~32;",
	"			}",
#endif
	"			goto Down;	/* pseudo-recursion */",
	"Up:",
#ifdef GODEF
	"			presel=0;",
#endif
	"#if CONNECT>0",
	"			if (now._a_t && depth <= A_depth)",
	"			{",
	"#ifdef DEBUG",
	"				printf(\"%%d Return\\n\", depth);",
	"#endif",
	"				return;	/* we came from checkaccept() */",
	"			}",
	"#endif",
	"			t  = trpt->o_t;  n  = trpt->o_n;",
	"			ot = trpt->o_ot; II = trpt->pr;",
	"			tt = trpt->o_tt; this = pptr(II);",
	"			To = trpt->o_To; m  = trpt->o_m;",
	"#ifdef VERI",
	"#if SYNC",
	"/* preserve rendez-vous completion status: */",
	"/* if the next level was a claim, copy through */",
	"			if (trpt->tau&4)",
	"				trpt->o_n = (trpt+1)->o_n;",
	"#endif",
	"#endif",

	"#ifdef JUMBO",
	"/** EXPERIMENTAL **/",
	"			if (trans[ot][tt]->Local > 1)",
	"			{",
	"#ifdef DEBUG",
	"	printf(\"%%d: process %%d sv jumbo backtracks %%d - from %%d\\n\", ",
	"		depth, II, t->forw, tt);",
	"#endif",
	"				sv_restor();",
	"				goto R999;",
	"			}",
	"/** END **/",
	"#endif",

	"#include \"pan.b\"",
	"R999:			/* jumps here when done */",
	"#ifdef VERBOSE",
	"	printf(\"%%3d: proc %%d reverses %%d, from %%d to %%d\", ",
	"		depth, II, t->forw, tt, t->st);",
	"	printf(\" %%s	tau %%d tau-1 %%d\\n\", Moves[t->forw],",
	"		trpt->tau, (trpt-1)->tau);",
	"#endif",
#ifdef GODEF
	"#ifdef ALG3",
	"			unrelease(); /* undo status 2 forward releases */",
	"#endif",
	"			/* truncated on stack or on a      */",
	"			/* progress state with now._p_t==1 */",
	"			if (trpt->tau&16)",
	"			{	if ((trpt-1)->tau&8)	/* atomic */",
	"				{	(trpt-1)->tau |= 16;",
	"#ifdef DEBUG",
	"					printf(\"%%d: PASS 16\\n\",depth);",
	"#endif",
	"				}",
	"			} else",
	"			{	(trpt-1)->tau |= 64;	/* remember it */",
	"#ifdef DEBUG",
	"				printf(\"%%d: save trunc status\\n\",depth);",
	"#endif",
	"			}",
#endif
	"			depth--; trpt--;",
	"			if (m > n) n = m;",
	"			((P0 *)this)->_p = tt;",
	"		} /* all options */",
#ifdef GODEF
	"		push_commit();	/* activate process blocks */",
#endif
	"#ifdef VERI",
	"		if (II == 1) break;",
	"#endif",
	"	} /* all processes */",
#ifdef GODEF
	"#ifdef ALG3",
	"	unpush();	/* unpush status 1 blocks */",
	"#endif",
	"#ifndef NOALG2",

	"	if (!(trpt->tau&64)  /* no nxtstates outside stack  */",
	"	&&    trpt->tau&32)  /* last moves were preselected */",
	"	{",
	"#ifdef DEBUG",
	"			printf(\"%%d: UNSELECT proc %%d\\n\", depth, II);",
	"#endif",
	"			presel = 0;",
	"			From = now._nr_pr-1; To = 0;",
	"			II--;	/* next preselection victim */",
	"			if (II >= 0)",
	"				goto Resume;",
	"			else",
	"				goto Again;",
	"	}",

	"	if (presel == 1)",
	"	{	if (n == 0) /* preselected process could not move */",
	"		{",
	"#ifdef DEBUG",
	"			printf(\"%%d: UNSELECT proc %%d\\n\", depth, II);",
	"#endif",
	"			presel = 0;",
	"			From = now._nr_pr-1; To = 0;",
	"			II--;	/* next preselection victim */",
	"			if (II >= 0)",
	"				goto Resume;",
	"			else",
	"				goto Again;",
	"		} else if (loops && now._p_t == 0)",
	"		{	/* must still run progress checker */",
	"			From = To = 1;	/* it has pid 1 */",
	"			goto Again;",
	"		}",
	"	}",
	"#endif",
	"#ifdef ALG3",
	"	if (Nwait == nwait[CS_timeout])",
	"#endif",
#endif
	"	if (n == 0)",
	"	{",
	"#ifdef VERI",
	"		if (trpt->tau&4) goto Done;	/* ok if a claim blocks */",
	"#endif",
	"#if SYNC",
	"		if (boq == -1)",
	"#endif",
	"		if (!endstate() && now._nr_pr ",
	"		&&  depth < maxdepth-1)",
	"		{	if (!((trpt->tau)&1))	/* timeout */",
	"			{	trpt->tau |= 1;",
	"#ifdef DEBUG",
	"				printf(\"timeout\\n\");",
	"#endif",
	"				push_act(0, W_LOCK, REL, 0, CS_timeout);",
	"	/* if this releases any procs - they are automatically",
	"	   unreleased by the first process returning to this level",
	"	 */",
	"				goto Again;",
	"			}",
	"#ifdef VERI",
	"			if (n >= 0)	/* Claim Stutter */",
	"#ifndef NOSTUTTER",
	"			{	trpt->tau |= 4;",
	"			{	trpt->tau |= 128;",
	"#ifdef DEBUG",
	"				printf(\"Stutter move\\n\");",
	"#endif",
	"				goto Stutter;",
	"			}",
	"#else",
	"				goto Done;	/* i.e., always */",
	"#endif",
	"#else",
	"			if (loops) goto Done;	/* do loop det. only */",
	"#endif",
	"			if (!(trpt->tau&8))	/* not an atomic move */",
	"			{",
	"#ifdef VERI",
	"				printf(\"claim at\");",
	"				xrefsrc(claimline,1,((P0 *)pptr(1))->_p);",
	"#endif",
	"				uerror(\"invalid endstate\");",
	"			} else",
	"				Uerror(\"atomic seq blocks\");",
	"		}",
	"#ifdef VERI",
	"#ifndef NOSTUTTER",
	"		else",
	"		{	trpt->tau |= 4;",
	"			trpt->tau |= 128;	/* Stutter mark */",
	"#ifdef DEBUG",
	"			printf(\"Stutter Move\\n\");",
	"#endif",
	"			goto Stutter;",
	"		}",
	"#endif",
	"#endif",
	"	}",
	"Done:",
	"#ifdef DEBUG",
	"	printf(\"up %%d\\n\", depth);",
	"#endif",
#ifdef GODEF
	"	if (!(trpt->tau&8))",
#else
	"#ifdef CACHE",
	"	if (!(trpt->tau&8))",
	"#else",
	"	if (loops && !(trpt->tau&8))",
	"#endif",
#endif
	"#ifdef VERI",
	"	if (!(trpt->tau&4))",
	"#endif",
	"#if SYNC>0",
	"	if (boq == -1)",
	"#endif",
	"	{",
	"#ifdef BITSTATE",
	"		LL[(svtack->j1)>>3]--;",
	"		LL[(svtack->j2)>>3]--;",
	"		svtack = svtack->lst;",
	"		if (trpt->tau&2)	/* state marked dirty: remove */",
	"		{	SS[(svtack->j2)>>3] &= ~(1<<((svtack->j1)&7));",
	"			SS[(svtack->j1)>>3] &= ~(1<<((svtack->j2)&7));",
	"		}",
	"#else",
	"		htag((char *)&now, vsize);",
	"#endif",
	"	}",
	"#if CONNECT>0",
	"#ifdef VERI",
	"	if ((!(trpt->tau&4))",
	"	||  (trpt->tau&128))	/* no claim move, unless Stutter */",
	"#endif",
	"	if (acycles		/* -a option is used */",
	"	&&  !(trpt->tau&8))	/* not an atomic move */",
	"		checkaccept();	/* check for acceptance-cycles */",
	"#endif",
	"	if (depth > 0) goto Up;",
	"}\n",
#ifdef GODEF
	"#ifdef ALG3",
	"rel_all_blocks(pid)	/* not thoroughly tested */",
	"{	int kk, mm, k, s, r, F, T, Cn, effect=0;",
	"	F = tratable[((P0 *)pptr(pid))->_t];",
	"	T = tratable[((P0 *)pptr(pid))->_t+1];",
	"	for (s = F; s < T; s++)",
	"	{	if (csets[pid][s] == 0) continue;",
	"		for (kk = 1; kk < 1+Csels_c[s][0]; kk++)",
	"		{	if (Csels_p[s][kk] != pid) continue;",
	"			k = Csels_c[s][kk];",
	"			r = Csels_r[s][kk];",
	"			Cn = Csels_c[s][0]--;",
	"			if (Cn < 1) Uerror(\"cannot happen - rel_all\");",
	"			for (mm = kk; mm < Cn; mm++)",
	"			{	Csels_c[s][mm] = Csels_c[s][mm+1];",
	"				Csels_r[s][mm] = Csels_r[s][mm+1];",
	"				Csels_p[s][mm] = Csels_p[s][mm+1];",
	"			}",
	"			csems[pid][k]--;",
	"			csets[pid][s]--;",
	"			if (nwait[k] <= 0)",
	"			{	printf(\"nwait[%%d] = %%d (%%d)\\n\", ",
	"					k, nwait[k], Nwait);",
	"				Uerror(\"nWait\");",
	"			}",
	"			nwait[k]--; Nwait--; effect=1;",
	"			push_cs_el(pid,s,k,depth+1,2,r,1);",
	"			kk--;",
	"		}",
	"	}",
	"#ifdef VERBOSE",
	"	if (effect) dumpsleep(\"rel_blocks\");",
	"#endif",
	"}",
	"	char *LCK[] = { \"Read\", \"Write\", \"Send\", \"Recv\" };",
	"dumpsleep(str)",
	"	char *str;",
	"{	int pid, xx, yy, zz, kk, F, T;",
	"	for (pid = 0; pid < now._nr_pr; pid++)",
	"	{ F = tratable[((P0 *)pptr(pid))->_t];",
	"	  T = tratable[((P0 *)pptr(pid))->_t+1];",
	"	  for (xx = F; xx < T; xx++)",
	"	  {	if (csets[pid][xx] == 0) continue;",
	"	  	printf(\"sleepset proc %%d: \", pid);",
	"	  	printf(\" trans %%2d, cs { \", xx);",
	"		for (kk = 1; kk < 1+Csels_c[xx][0]; kk++)",
	"		{	yy = Csels_r[xx][kk];",
	"			zz = Csels_c[xx][kk];",
	"			if (pid == Csels_p[xx][kk])",
	"			{	if (zz < MAXCONFL)",
	"					printf(\"%%s on var %%s, \",",
	"					LCK[yy], CS_names[zz]);",
	"				else if (zz == MAXCONFL)",
	"					printf(\"<local>, \");",
	"				else",
	"					printf(\"%%s on qid %%d, \",",
	"					LCK[yy], zz);",
	"			}",
	"		}",
	"#ifdef DEBUG",
	"		printf(\"}\t%%s\\n\", str);",
	"#else",
	"		printf(\"}\\n\");",
	"#endif",
	"	} }",
	"}",
	"push_cs_el(pid, stmnt, cs, dp, st, rs, dt)",
	"{",
	"	if (stmnt == 0) return;	/* timeouts map onto 0 */",
	"	if (cs_stack->depth > dp)",
	"	{	push2_cs_el(pid, stmnt, cs, dp, st, rs, dt);",
	"		return;",
	"	}",
	"	if (!cs_stack->nxt)",
	"	{	cs_stack->nxt = (CS_stack *)",
	"			emalloc(sizeof(CS_stack));",
	"		cs_stack->nxt->lst = cs_stack;",
	"		cs_max++;",
	"	}",
	"	cs_stack = cs_stack->nxt;",
	"	cs_stack->pid    = pid;",
	"	cs_stack->stmnt  = stmnt;",
	"	cs_stack->cs     = cs;",
	"	cs_stack->delta  = dt;",
	"	cs_stack->depth  = dp;",
	"	cs_stack->status = st;",
	"	cs_stack->reason = rs;",
	"#ifdef DEBUG",
	"	printf(\"%%d: push_cs_el %%d,%%d,%%d %%d %%d %%d\\n\",",
	"			depth, pid, stmnt, cs, st, rs, dt);",
	"#endif",
	"}\n",
	/* reach up in cs_stack and insert at correct depth */
	"push2_cs_el(pid, stmnt, cs, dp, st, rs, dt)",
	"{	CS_stack *k, *twiddle;",
	"	cs_max++;",
	"	twiddle = (CS_stack *) emalloc(sizeof(CS_stack));",
	"	twiddle->pid    = pid;",
	"	twiddle->stmnt  = stmnt;",
	"	twiddle->cs     = cs;",
	"	twiddle->delta  = dt;",
	"	twiddle->depth  = dp;",
	"	twiddle->status = st;",
	"	twiddle->reason = rs;",
	"	for (k = cs_stack; k && k->depth > dp; k = k->lst)",
	"		;",
	"	if (k)",
	"	{	twiddle->nxt = k->nxt;",
	"		k->nxt->lst = twiddle;",
	"		twiddle->lst = k;",
	"		k->nxt = twiddle;",
	"	} else",
	"		cs_stack = twiddle;",
	"#ifdef DEBUG",
	"	printf(\"%%d: push2_cs_el %%d,%%d,%%d %%d %%d %%d\\n\",",
	"			depth, pid, stmnt, cs, st, rs, dt);",
	"#endif",
	"}\n",
	"push_commit()	/* commit to a pending lock */",
	"{	CS_stack *k; int mv, Cn, effect=0;",
	"	for (k = cs_stack; k && k->depth == depth+1; k = k->lst)",
	"	{	if (k->status != -1) continue;",
	"		k->status = 1; mv = k->stmnt;",
	"#ifdef DEBUG",
	"	printf(\"%%d: BLOCK process %%d %%d %%d, nwait -> %%d (%%d)\\n\", ",
	"	depth, k->pid, k->stmnt, k->cs, nwait[k->cs]+1, Nwait+1);",
	"#endif",
	"		Cn = ++Csels_c[mv][0];",
	"		if (Cn > MULT_MAXCS)",
	"		{	printf(\"error: recompile with MULT>%%d\\n\",MULT);",
	"			exit(1);",
	"		}",
	"		Csels_c[mv][Cn] = k->cs;",
	"		Csels_r[mv][Cn] = k->reason;",
	"		Csels_p[mv][Cn] = k->pid;",
	"		csems[k->pid][k->cs]++;",
	"		csets[k->pid][mv]++;",
	"		nwait[k->cs]++;",
	"		Nwait++; effect=1;",
	"	}",
	"#ifdef VERBOSE",
	"	if (effect) dumpsleep(\"push_commit\");",
	"#endif",
	"}\n",
	"char Conflict[NLOCKS][NLOCKS] = { /* 1 == DEP, 0 == IND */",
	" /*			   R_LOCK, W_LOCK, Snd_LOCK, Rcv_LOCK */",
	" /* R_LOCK */		{   0,	    1,		1,	    1 },",
	" /* W_LOCK */		{   1,	    1,		1,	    1 },",
	" /* Snd_LOCK */	{   1,	    1,		1,	    M_LOSS },",
	" /* Rcv_LOCK */	{   1,	    1,		M_LOSS,	    1 },",
	"};",
	"/* when m_loss is set (on SPIN's -m flag) sends and receives",
	" * on the same queue are really only dependent when the queue",
	" * is full - the above version is therefore a little conservative",
	" */",
	"push_act(pid, what, when, stmnt, cs)	/* log a global action */",
	"{	int i, j, k, r, F, R, T, maxk, delta, kk, own; int effect=0;",
	"",
	"	if (when == BLOCK)	/* set a pending lock */",
	"#ifndef NOPELED",
	"	{	if (!(trpt->tau&16))	/* PELED's PROVISO */",
	"#else",
	"	{",
	"#endif",
	"		push_cs_el(pid, stmnt, cs, depth, -1, what, 1);",
	"		return;",
	"	} /* else release */",
	"#ifdef DEBUG",
	"	printf(\"%%d: push REL %%d, cs %%d (nwait %%d) Nwait %%d\\n\", ",
	"		depth, stmnt, cs, nwait[cs], Nwait);",
	"#endif",
	"	maxk = 1+MAXCONFL+now._nr_qs;",
	"	if (nwait[cs] > 0)",
	"	for (i = 0; i < now._nr_pr; i++)",
	"	if (csems[i][cs] > 0)",
	"	{ F = tratable[((P0 *)pptr(i))->_t];",
	"	  T = tratable[((P0 *)pptr(i))->_t+1];",
	"	  for (j = F; j < T; j++)",
	"	  {	for (kk = 1; kk < 1+Csels_c[j][0]; kk++)",
	"		{	if (Csels_c[j][kk] == cs",
	"			&&  Conflict[what][Csels_r[j][kk]])",
	"			{	/* clear all blocks on j */",
	"				for (kk = 1; kk < 1+Csels_c[j][0]; kk++)",
	"				{	r   = Csels_r[j][kk];",
	"					k   = Csels_c[j][kk];",
	"					own = Csels_p[j][kk];",
	"					csems[own][k]--;",
	"					csets[own][j]--;",
	"					nwait[k]--;",
	"					Nwait--;",
	"#ifdef DEBUG",
	"	printf(\"%%d: REL proc %%d / %%d cs %%d, by %%d,\",",
	"		depth, own, j, k, stmnt);",
	"	printf(\" csems[pid][cs] = %%d,\", csems[own][k]);",
	"	printf(\" nwait[cs] = %%d (Nwait %%d), maxk %%d\\n\",",
	"		nwait[k], Nwait, maxk);",
	"#endif",
	"					push_cs_el(own,j,k,depth+1,2,r,1);",
	"					effect = 1;",
	"				}",
	"				Csels_c[j][0] = 0;",
	"				break;",
	"		}	}",
	"	  }",
	"	}",
	"out:	if (nwait[cs] < 0)",
	"		Uerror(\"nwait negative\");",
	"#ifdef VERBOSE",
	"	if (effect) dumpsleep(\"act\");",
	"#endif",
	"}\n",
	"unrelease()",
	"{	int k, p, s, dt, Cn, effect=0;",
	"	CS_stack *K;",
	"	for (K = cs_stack; K && K->depth == depth; K = K->lst)",
	"	{	k = K->cs;",
	"		p = K->pid;",
	"		s = K->stmnt;",
	"		if (K->status == 2)",
	"		{",
	"			for (dt = 0; dt < K->delta; dt++)",
	"			{	Cn = ++Csels_c[s][0];",
	"				if (Cn > MULT_MAXCS)",
	"				Uerror(\"cannot happen - Csels1\");",
	"				Csels_c[s][Cn] = k;",
	"				Csels_r[s][Cn] = K->reason;",
	"				Csels_p[s][Cn] = p;",
	"				csems[p][k]++;",
	"				csets[p][s]++;",
	"				nwait[k]++; Nwait++;",
	"			}",
	"			K->status = 3;",
	"			effect=1;",
	"#ifdef DEBUG",
	"printf(\"%%d: unrelease mv %%d, cs %%d, dt %%d nwait => %%d (%%d)\\n\", ",
	"		depth, s, k, dt, nwait[k], Nwait);",
	"#endif",
	"		}",
	"	}",
	"#ifdef VERBOSE",
	"	if (effect) dumpsleep(\"unrelease\");",
	"#endif",
	"}\n",
	"unpush()",
	"{	int k, p, r, s, kk, mm, Cn, oCn, effect=0;",
	"	while (cs_stack && cs_stack->depth == depth+1)",
	"	{	k = cs_stack->cs;",
	"		p = cs_stack->pid;",
	"		s = cs_stack->stmnt;",
	"		r = cs_stack->reason;",
	"		if (cs_stack->status == 1)",
	"		{",
	"			oCn = Csels_c[s][0];",
	"#ifdef DEBUG",
	"	printf(\"%%d: try unpush %%d,%%d [%%d] nwait => %%d (%%d) %%d\\n\",",
	"		depth, s, k, r, nwait[k], Nwait, oCn);",
	"#endif",
	"			for (kk = 1; kk < 1+Csels_c[s][0]; kk++)",
	"			if (Csels_r[s][kk] == r",
	"			&&  Csels_c[s][kk] == k",
	"			&&  Csels_p[s][kk] == p)",
	"			{	Cn = Csels_c[s][0]--;",
	"				if (Cn < 1)",
	"				Uerror(\"cannot happen - Csels2\");",
	"				for (mm = kk; mm < Cn; mm++)",
	"				{ Csels_c[s][mm] = Csels_c[s][mm+1];",
	"				  Csels_r[s][mm] = Csels_r[s][mm+1];",
	"				  Csels_p[s][mm] = Csels_p[s][mm+1];",
	"				}",
	"				break;",
	"			}",
	"			if (oCn == Csels_c[s][0])",
	"			{",
	"	printf(\"cannot find %%d,%%d in\\n\", r, k);",
	"	for (kk = 1; kk < 1+Csels_c[s][0]; kk++)",
	"	printf(\"\t%%d,%%d\\n\", Csels_r[s][kk], Csels_c[s][kk]);",
	"				Uerror(\"cannot happen Cs unpush\");",
	"			}",
	"			csems[p][k]--;",
	"			csets[p][s]--;",
	"			if (nwait[k] <= 0)",
	"			{	printf(\"nwait[%%d] = %%d (%%d)\\n\", ",
	"					k, nwait[k], Nwait);",
	"				Uerror(\"nwait\");",
	"			}",
	"			nwait[k]--; Nwait--; effect=1;",
	"		} else if (cs_stack->status != 3)",
	"		{	printf(\"cs = %%d, mv = %%d\\n\", ",
	"				cs_stack->cs, cs_stack->stmnt);",
	"			printf(\"Bad status: %%d\\n\", cs_stack->status);",
	"			Uerror(\"unpush\");",
	"		}",
	"#ifdef DEBUG",
	"	printf(\"%%d: unpush %%d,%%d [%%d] nwait => %%d (%%d)\\n\", depth, ",
	"		s, k, cs_stack->status,",
	"		nwait[k], Nwait);",
	"#endif",
	"		cs_stack->status = cs_stack->reason = 0;",
	"		cs_stack = cs_stack->lst;",
	"	}",
	"#ifdef VERBOSE",
	"	if (effect) dumpsleep(\"unpush\");",
	"#endif",
	"}\n",
	"#endif",
#endif
	"assert(a, s, ii, tt, t)",
	"	char *s;",
	"	Trans *t;",
	"{	if (!a)",
	"	{	printf(\"assertion violated %%s\", s);",
	"		depth++; trpt++;",
	"		trpt->pr = ii;",
	"		trpt->st = tt;",
	"		trpt->o_t = t;",
	"		uerror(\"aborted\");",
	"		depth--; trpt--;",
	"	}",
	"}",
	"#ifndef NOBOUNDCHECK",
	"Boundcheck(x, y, a1, a2, a3)",
	"	Trans *a3;",
	"{	assert((x >= 0 && x < y), \"- invalid array index\\n\", a1, a2, a3);",
	"	return x;",
	"}",
	"#endif",
	"#ifdef MEMCNT",
	"int memcnt=0;",
#ifdef DEBUG
	"int logger[1024];",
#endif
	"#endif",
	"void",
	"wrapup()",
	"{",
	"#ifdef BITSTATE",
	"	double a, b;\n",
	"	printf(\"bit statespace search \");",
	"#else",
	"	printf(\"full statespace search \");",
	"#endif",
	"#ifdef VERI",
	"	printf(\"on behavior restricted to claim \");",
	"#endif",
	"	printf(\"for:\\n\tassertion violations\");",
	"#ifndef VERI",
	"	if (loops)",
	"		printf(\" and %%s non-progress loops\",",
	"			fairness?\"FAIR\":\"\");",
	"	else",
	"		printf(\" and invalid endstates\");",
	"#endif",
	"#if CONNECT>0",
	"	if (acycles && !loops)",
	"		printf(\"\\n\\tand %%s acceptance cycles\",",
	"			fairness?\"FAIR\":\"\");",
	"#endif",
	"	if (!done) printf(\"\\nsearch was not completed\");",
	"	printf(\"\\nvector %%d byte, depth reached %%d\", ",
	"					hmax, mreached);",
	"	if (loops)",
	"	{  printf(\", non-progress loops: %%d\\n\", errors);",
	"	} else",
	"	  printf(\", errors: %%d\\n\", errors);",
	"	printf(\"%%8d states, stored\", nstates - recycled);",
	"	if (recycled) printf(\" (%%d recycled)\", recycled);",
	"	printf(\"\\n%%8d states, linked\\n\", nlinks);",
	"	printf(\"%%8d states, matched\t   total: %%8d\\n\",",
	"	truncs, nstates+nlinks+truncs);",
	"#ifdef BITSTATE",
	"	a = (double) (1<<ssize);",
	"	b = (double) nstates+1.;",
	"	printf(\"hash factor: %%f \", a/b);",
	"	printf(\"(best coverage if >100)\\n\");",
	"#else",
	"	printf(\"hash conflicts: %%d (resolved)\\n\", hcmp);",
	"#endif",
	"	printf(\"(max size 2^%%d states, \", ssize);",
#ifdef VARSTACK
	"	printf(\"varstack: %%d, \", vmax);",
#endif
#ifdef GODEF
	"	printf(\"cs_stack: %%d, \", cs_max);",
#endif
	"	printf(\"stackframes: %%d/%%d)\\n\\n\", smax, svmax);",
	"	if (M_LOSS) printf(\"total messages lost: %%d\\n\\n\", loss);",
	"#ifdef MEMCNT",
	"	printf(\"memory used: %%d\\n\", memcnt);",
	"#endif",
	"	if (done && !loops) do_reach();",
#ifdef GODEF
	"#ifdef ALG3",
	"#ifdef VERBOSE",
	"	if (done)",
	"	{	int i,j,k,r;",
	"		for (j = 0; j < MAXSTATE; j++)",
	"		{	if (Csels_c[j][0] != 0)",
	"			printf(\"Csels_c[%%d][0] = %%d\\n\",",
	"				j, Csels_c[j][0]);",
	"		}",
	"		for (i = 0; i < MAXPROC; i++)",
	"			for (k = 0; k < TOPQ; k++)",
	"				if (csems[i][k] != 0)",
	"				printf(\"\tcsem %%d,%%d = %%d\\n\", ",
	"				i,k, csems[i][k]);",

	"		for (j = 0; j < TOPQ; j++)",
	"			if (nwait[j] != 0)",
	"				printf(\"\tnwait %%d = %%d\\n\", ",
	"				j, nwait[j]);",
	"		if (Nwait != 0)",
	"			printf(\"Nwait = %%d\\n\", Nwait);",
	"	}",
	"#endif",
	"#endif",
#endif
	"	exit(0);",
	"}\n",
	"d_hash(cp, om)",
	"	uchar *cp;",
	"{",
	"	register long z = 0x88888EEFL;",
	"	register long *q, *r;",
	"	register int h;",
	"	register m, n;\n",
	"	h = (om+3)/4;",
	"	m = n = -1;",
	"	q = r = (long *) cp;",
	"	r += (long) h;",
	"	do {",
	"		m += m;",
	"		if (m < 0)",
	"			m ^= z;",
	"		m ^= *q++;",
	"		n += n;",
	"		if (n < 0)",
	"			n ^= z;",
	"		n ^= *--r;",
	"	} while (--h > 0);",
	"	J1 = (m ^ (m>>(8*sizeof(unsigned)-ssize)))&mask;",
	"	J2 = (n ^ (n>>(8*sizeof(unsigned)-ssize)))&mask;",
	"}\n",
	"s_hash(cp, om)",
	"	uchar *cp;",
	"{",
	"#ifdef ALTHASH",
	"	d_hash(cp,om);",
	"	j1 = (J1^J2)&mask;",
	"#else",
	"	register long z = 0x88888EEFL;",
	"	register long *q;",
	"	register int h;\n",
	"	register m = -1;",
	"	h = (om+3)/4;",
	"	q = (long *) cp;",
	"	do {",
	"		m += m;",
	"		if (m < 0)",
	"			m ^= z;",
	"		m ^= *q++;",
	"	} while (--h > 0);",
	"	j1 = (m ^ (m>>(8*sizeof(unsigned)-ssize)))&mask;",
	"#endif",
	"}\n",
	"main(argc, argv)",
	"	char *argv[];",
	"{",
	"	while (argc > 1 && argv[1][0] == '-')",
	"	{	switch (argv[1][1]) {",
	"#if CONNECT>0",
	"		case 'a': acycles = 1; break;",
	"#endif",
	"		case 'c': upto  = atoi(&argv[1][2]); break;",
	"		case 'd': state_tables++; break;",
	"		case 'f': fairness = 1; break;",
	"		case 'H': homomorphism = 1;",
	"			  if (argc < 4) { usage(); exit(); }",
	"			  hom_target = argv[2]; hom_source = argv[3];",
	"			  printf(\"short trans;\\n\");",
	"			  break;",
	"#ifndef VERI",
	"		case 'l': loops = 1; break;",
	"#endif",
	"		case 'm': maxdepth = atoi(&argv[1][2]); break;",
	"		case 'w': ssize = atoi(&argv[1][2]); break;",
#ifdef PAIRS
	"		case 't': tree_before=1; break;",
#endif
	"		default : usage(); exit(1);",
	"		}",
	"		argc--; argv++;",
	"	}",
	"	if (acycles && loops)",
	"	{	fprintf(stderr, \"sorry: cannot combine -a and -l\\n\");",
	"		usage(); exit(1);",
	"	}",
	"	if (fairness && !acycles && !loops)",
	"	{	fprintf(stderr, \"sorry: option -f only has effect when\");",
	"		fprintf(stderr, \" combined with -a or -l\\n\");",
	"		usage(); exit(1);",
	"	}",
	"	signal(SIGINT, wrapup);",
	"	mask = ((1<<ssize)-1);	/* hash init */",
	"	trail = (Trail *) emalloc((maxdepth+2)*sizeof(Trail));",
	"	run();",
	"	done = 1;",
	"	wrapup();",
	"}\n",
	"usage()",
	"{	fprintf(stderr, \"unknown option\\n\");",
	"#if CONNECT>0",
	"	fprintf(stderr, \"-a  find acceptance cycles\\n\");",
	"#else",
	"	fprintf(stderr, \"-a  disabled (no accept labels are defined)\\n\");",
	"#endif",
	"	fprintf(stderr, \"-cN stop at Nth error \");",
	"	fprintf(stderr, \"(default=1)\\n\");",
	"	fprintf(stderr, \"-d  print state tables and stop\\n\");",
	"	fprintf(stderr, \"-d -d  print un-optimized state tables\\n\");",
	"	fprintf(stderr, \"-f  enforce weak fairness in cycles\\n\");",
	"	fprintf(stderr, \"-H  target_proctype source_proctype\\n\");",
	"	fprintf(stderr, \"    produce a model for proving homomorphism\\n\");",
	"#ifndef VERI",
	"	fprintf(stderr, \"-l  find non-progress cycles\\n\");",
	"#else",
	"	fprintf(stderr, \"-l  disabled (by presence of never claim)\\n\");",
	"#endif",
	"	fprintf(stderr, \"-mN max depth N (default=10k)\\n\");",
	"	fprintf(stderr, \"-wN hashtable of 2^N entries \");",
	"	fprintf(stderr, \"(default=%%d)\\n\", ssize);",
	"}\n",
#if 0
	"char *",
	"emalloc(n)",
	"{	char *tmp = malloc(n);",
	"#ifdef MEMCNT",
	"	if (!tmp || memcnt > 1<<MEMCNT)",
	"#else",
	"	if (!tmp)",
	"#endif",
	"	{	printf(\"pan: out of memory\\n\");",
	"		wrapup();",
	"	}",
	"#ifdef MEMCNT",
#ifdef DEBUG
	"if (n<1020) logger[n]++;",
	"else { logger[1021]++;",
	"if (!logger[1022]) logger[1022] = n;",
	"else logger[1023] = n; }",
#endif
	"	memcnt += n;",
	"#endif",
	"	memset(tmp, 0, n);",
	"	return tmp;",
	"}\n",
#else
	"/* include realloc and free to keep sysV libc",
	" * from including them and",
	" * finding multiple references",
	" */",
	"char *",
	"realloc(s)",
	"	char *s;",
	"{	printf(\"aborting: cannot happen - call on realloc()\\n\");",
	"	wrapup();",
	"}",
	"",
	"free(s)",
	"	char *s;",
	"{	/* never called - simply ignore it */",
	"}",
	"",
	"char *",
	"malloc(n)",
	"	unsigned n;",
	"{",
	"	char *tmp;",
	"	extern char *sbrk();",
	"	tmp = sbrk(n);",
	"#ifdef MEMCNT",
	"	if ((int) tmp == -1 || memcnt > 1<<MEMCNT)",
	"#else",
	"	if ((int) tmp == -1)",
	"#endif",
	"	{       printf(\"aborting: out of memory\\n\");",
	"		wrapup();",
	"	}",
	"#ifdef MEMCNT",
	"	memcnt += n;",
	"#endif",
	"	return tmp;",
	"}",
	"",
	"#define CHUNK	4096",
	"",
	"char *",
	"emalloc(n)      /* memory is never released or reallocated */",
	"	unsigned n;",
	"{",
	"	char *tmp;",
	"	static char *have;",
	"	static long left = 0L;",
	"	static long fragment = 0L;",
	"",
	"	if (n == 0)",
	"	        return (char *) NULL;",
	"	if (n&3)",
	"	        n += 4-(n&3);	/* for proper alignment */",
	"	if (left < n)",
	"	{       unsigned grow = (n < CHUNK) ? CHUNK : n;",
	"	        have = malloc(grow);",
	"	        fragment += left;",
	"	        left = grow;",
	"	}",
	"	tmp = have;",
	"	have += (long) n;",
	"	left -= (long) n;",
	"	memset(tmp, 0, n);",
	"	return tmp;",
	"}",
#endif
	"Uerror(str)",
	"	char *str;",
	"{	/* always fatal */",
	"	errors = upto-1;",
	"	uerror(str);",
	"	wrapup();",
	"}\n",
	"uerror(str)",
	"	char *str;",
	"{",
	"	if (++errors == upto)",
	"	{	printf(\"pan: %%s (at depth %%d)\\n\", str,",
	"		(depthfound==-1)?depth:depthfound);",
	"		putrail();",
	"		wrapup();",
	"	}",
	"	return 1;",
	"}\n",
	"r_ck(which, N, M, src)",
	"	uchar *which;",
	"	short *src;",
	"{	int i, m=0;\n",
	"#ifdef VERI",
	"	if (M == VERI) return;	/* no useful info there */",
	"#endif",
	"	printf(\"unreached in proctype %%s:\\n\", procname[M]);",
	"	for (i = 1; i < N; i++)",
	"	  if (which[i] == 0)",
	"	  	xrefsrc(src[i], M, i);",
	"	  else",
	"		m++;",
	"	printf(\"\t(%%d of %%d states)\\n\", N-1-m, N-1);",
	"}\n",
	"xrefsrc(lno, M, i)",
	"{",
	"	printf(\"\\tline %%d (state %%d)\", lno, i);",
	"	xrefstmnt(M, i);",
	"}",
	"xrefstmnt(M, i)",
	"{",
	"	if (trans[M][i] && trans[M][i]->tp)",
	"	{	if (strcmp(trans[M][i]->tp, \"\") != 0)",
	"			printf(\", \\\"%%s\\\"\", trans[M][i]->tp);",
	"		else if (stopstate[M][i])",
	"			printf(\", -endstate-\");",
	"	} else",
	"		printf(\", ?\");",
	"	printf(\"\\n\");",
	"}\n",
	"putrail()",
	"{	int fd, i, j, q;",
	"	char snap[64];\n",
	"	if ((fd = creat(\"pan.trail\", 0666)) <= 0)",
	"	{	printf(\"cannot create pan.trail\\n\");",
	"		return;",
	"	}",
	"#ifdef VERI",
	"	sprintf(snap, \"-2:%%d:-2:-2\\n\", VERI);",
	"	write(fd, snap, strlen(snap));",
	"#endif",
	"	for (i = 1, j = 0; i <= depth; i++)",
	"	{	q = trail[i].pr;",
	"		if (i == depthfound)",
	"			write(fd, \"-1:-1:-1:-1\\n\", 12);",
	"		if (loops)",
	"#ifdef VERI",
	"		{	if (q == 2) continue;",
	"			if (q  > 2) q -= 2;",
	"		}",
	"#else",
	"		{	if (q == 1) continue;",
	"			if (q  > 1) q--;",
	"		}",
	"#endif",
	"		if (trail[i].o_t->ist)",
	"		{  sprintf(snap, \"%%d:%%d:%%d:%%d\\n\", j++,",
	"				q, trail[i].o_t->ist, i);",
	"		   write(fd, snap, strlen(snap));",
	"		}",
	"		sprintf(snap, \"%%d:%%d:%%d:%%d\\n\", j++, ",
	"			q, trail[i].o_t->st, i);",
	"		write(fd, snap, strlen(snap));",
	"	}",
	"	printf(\"pan: wrote pan.trail\\n\");",
	"	close(fd);",
	"}\n",
	"sv_save()	/* push state vector onto save stack */",
	"{	if (!svtack->nxt)",
	"	{  svtack->nxt = (Svtack *) emalloc(sizeof(Svtack));",
	"	   svtack->nxt->body = emalloc(vsize*sizeof(char));",
	"	   svtack->nxt->lst = svtack;",
	"	   svtack->nxt->m_delta = vsize;",
	"	   svmax++;",
	"	} else if (vsize > svtack->nxt->m_delta)",
	"	{  svtack->nxt->body = emalloc(vsize*sizeof(char));",
	"	   svtack->nxt->lst = svtack;",
	"	   svtack->nxt->m_delta = vsize;",
	"	   svmax++;",
	"	}",
	"	svtack = svtack->nxt;",
	"#if SYNC",
	"	svtack->o_boq = boq;",
	"#endif",
	"	svtack->o_delta = vsize;",
	"	memcpy((char *)(svtack->body), (char *)&now, vsize);",
	"#ifdef DEBUG",
	"	printf(\"%%d: sv_save %%d (%%u)\\n\", depth, vsize, svtack);",
	"#endif",
	"}\n",
	"sv_restor()	/* pop state vector from save stack */",
	"{	memcpy((char *)&now, svtack->body, svtack->o_delta);",
	"#if SYNC",
	"	boq = svtack->o_boq;",
	"#endif",
	"#ifdef DEBUG",
	"	printf(\"%%d: sv_restor %%d %%d (%%u)\\n\", depth, vsize, svtack->o_delta,svtack);",
	"#endif",
	"	if (vsize != svtack->o_delta)",
	"		Uerror(\"sv_restor\");",
	"	if (!svtack->lst)",
	"		Uerror(\"error: v_restor\");",
	"	svtack  = svtack->lst;",
	"}\n",
	"p_restor(h)",
	"{	int i; char *z = (char *) &now;",
	"	proc_offset[h] = stack->o_offset;",
	"	proc_skip[h]   = stack->o_skip;",
	"	vsize += stack->o_skip;",
	"	memcpy(z+vsize, stack->body, stack->o_delta);",
	"	vsize += stack->o_delta;",
	"	i = stack->o_delqs;",
	"	now._nr_pr += 1;",
	"	if (!stack->lst)	/* debugging */",
	"		Uerror(\"error: p_restor\");",
	"	stack = stack->lst;",
	"	this = pptr(h);",
	"	while (i-- > 0)",
	"		q_restor();",
	"}\n",
	"q_restor()",
	"{	char *z = (char *) &now;",
	"	q_offset[now._nr_qs] = stack->o_offset;",
	"	q_skip[now._nr_qs]   = stack->o_skip;",
	"	vsize += stack->o_skip;",
	"	memcpy(z+vsize, stack->body, stack->o_delta);",
	"	vsize += stack->o_delta;",
	"	now._nr_qs += 1;",
	"	if (!stack->lst)	/* debugging */",
	"		Uerror(\"error: q_restor\");",
	"	stack = stack->lst;",
	"}\n",
	"delproc(sav, h)",
	"{	int d, i=0;",
	"",
	"	if (h+1 != now._nr_pr) return 0;",
	"",
	"	while (now._nr_qs",
	"	&&     q_offset[now._nr_qs-1] > proc_offset[h])",
	"	{	delq(sav);",
	"		i++;",
	"	}",
	"	d = vsize - proc_offset[h];",
	"	if (sav)",
	"	{	if (!stack->nxt)",
	"		{	stack->nxt = (Stack *)",
	"				emalloc(sizeof(Stack));",
	"			stack->nxt->body = ",
	"				emalloc(Maxbody*sizeof(char));",
	"			stack->nxt->lst = stack;",
	"			smax++;",
	"		}",
	"		stack = stack->nxt;",
	"		stack->o_offset = proc_offset[h];",
	"		stack->o_skip   = proc_skip[h];",
	"		stack->o_delta  = d;",
	"		stack->o_delqs  = i;",
	"		memcpy(stack->body, (char *)pptr(h), d);",
	"	}",
	"	vsize = proc_offset[h];",
	"	now._nr_pr = now._nr_pr - 1;",
	"	memset((char *)pptr(h), 0, d);",
	"	vsize -= proc_skip[h];",
	"#ifdef DEBUG",
	"	printf(\"del proc %%d\\n\", h);",
	"#endif",
	"	return 1;",
	"}\n",
#ifdef VARSTACK
	"pushvarval(v, ck)",
	"{	if (!varstack->nxt)",
	"	{	varstack->nxt = (Varstack *)",
	"			emalloc(sizeof(Varstack));",
	"		varstack->nxt->lst = varstack;",
	"		vmax++;",
	"	}",
	"	varstack = varstack->nxt;",
	"	varstack->val = v;",
	"	varstack->cksum = ck;",
	"}\n",
	"popvarval(ck)",
	"{	if (!varstack->lst)",
	"		Uerror(\"error: popvar\");",
	"	if (varstack->cksum != ck)",
	"	{	printf(\"%%d <-> %%d\\n\", varstack->cksum, ck);",
	"		Uerror(\"mismatch varstack\");",
	"	}",
	"	varstack = varstack->lst;",
	"	return varstack->nxt->val;",
	"}\n",
#endif
	"delq(sav)",
	"{	int h = now._nr_qs - 1;",
	"	int d = vsize - q_offset[now._nr_qs - 1];",
	"	if (sav)",
	"	{	if (!stack->nxt)",
	"		{	stack->nxt = (Stack *)",
	"				emalloc(sizeof(Stack));",
	"			stack->nxt->body = ",
	"				emalloc(Maxbody*sizeof(char));",
	"			stack->nxt->lst = stack;",
	"			smax++;",
	"		}",
	"		stack = stack->nxt;",
	"		stack->o_offset = q_offset[h];",
	"		stack->o_skip   = q_skip[h];",
	"		stack->o_delta  = d;",
	"		memcpy(stack->body, (char *)qptr(h), d);",
	"	}",
	"	vsize = q_offset[h];",
	"	now._nr_qs = now._nr_qs - 1;",
	"	memset((char *)qptr(h), 0, d);",
	"	vsize -= q_skip[h];",
	"#ifdef DEBUG",
	"	printf(\"del queue %%d\\n\", h);",
	"#endif",
	"}\n",
	"prognow()",
	"{",
	"	int i; P0 *ptr;",
	"	for (i = 0; i < now._nr_pr; i++)",
	"	{	ptr = (P0 *) pptr(i);",
	"		if (progstate[ptr->_t][ptr->_p])",
	"			return 1;",
	"	}",
	"	return 0;",
	"}\n",
	"endstate()",
	"{	int i; P0 *ptr;",
	"	for (i = 0; i < now._nr_pr; i++)",
	"	{",
	"#ifdef VERI",
	"		if (i == 1) continue;",
	"#endif",
	"		ptr = (P0 *) pptr(i);",
	"		if (!stopstate[ptr->_t][ptr->_p])",
	"			return 0;",
	"	}",
	"	if (loops)",
	"		uerror(\"non progress sequence\");",
	"	return 1;",
	"}\n",
	"onstack()",
	"{	register Svtack *ptr;",
	"	register char *won = (char *)&now;",
	"	register int j=depth;",
	"	for (ptr = svtack; ptr; ptr = ptr->lst, j--)",
	"	if (ptr->o_delta == vsize",
	"	&&  ptr->j1 == J1 && ptr->j2 == J2",
	"	&&  memcmp(ptr->body, won, vsize) == 0)",
	"	{	depthfound = j;",
	"		return 1;",
	"	}",
	"	return 0;",
	"}\n",
	"fair_cycle()",
	"{	int i, j, q, II;",
	"	Trans *t;",
	"	short tt;",
	"	char ot;",
	"	uchar moved[MAXPROC];",
	"",
	"	if (!fairness) return 1;",
	"	memset(moved, 0, MAXPROC);",
	"#ifdef VERI",
	"	moved[1] = 1;",
	"	if (loops) moved[2] = 1;",
	"#else",
	"	if (loops) moved[1] = 1;",
	"#endif",
	"	for (i = depthfound; i <= depth; i++)",
	"	{	q = trail[i].pr;",
	"#ifdef VERI",
	"		if (q == 1 || (loops && q == 2)) continue;",
	"#else",
	"		if (loops && q == 1) continue;",
	"#endif",
	"		moved[q] = 1;",
	"	}",
	"	for (II = 0; II < now._nr_pr; II++)",
	"	{	if (!moved[II])",
	"		{	this = pptr(II);",
	"#ifdef DEBUG",
	"			printf(\"no move in process %%s (%%d)\\n\",",
	"				procname[((P0 *)pptr(II))->_t], II);",
	"#endif",
	"			tt = (short) ((P0 *)this)->_p;",
	"			ot = (uchar) ((P0 *)this)->_t;",
	"			for (t = trans[ot][tt]; t; t = t->nxt)",
	"			{",
	"#include \"pan.f\"",
	"#ifdef DEBUG",
	"				printf(\"process %%s (%%d) could'a moved\\n\",",
	"				procname[((P0 *)pptr(II))->_t], II);",
	"				printf(\"	(move %%d)\\n\", t->forw);",
	"#endif",
	"				goto not_fair;",
	"			}",
	"		}",
	"	}",
	"	/* a fair cycle was detected */",
	"	for (i = depthfound-1; i <= depth; i++)",
	"		trail[i].tau &= ~2;	/* unmark states in SCC */",
	"	return 1;",
	"not_fair:",
	"	/* mark all states in the SCC dirty - to avoid missing fair */",
	"	/* traversals of the same SCC that could be generated later */",
	"	for (i = depthfound-1; i <= depth; i++)",
	"		trail[i].tau |= 2;",
	"	return 0;",
	"}\n",

	"#if CONNECT>0",
	"checkaccept()",
	"{	int i;",
	"       for (i = 0; i < now._nr_pr; i++)",
	"       {       P0 *ptr = (P0 *) pptr(i);",
	"               if (accpstate[ptr->_t][ptr->_p])",
	"			break;",
	"	}",
	"	if (i == now._nr_pr)",
	"		return;",
	"	if (now._a_t)",
	"	{",
	"#ifdef DEBUG",
	"		printf(\"%%d second accept\\n\", depth);",
	"#endif",
	"		return;",
	"	}",
	"#ifdef DEBUG",
	"	printf(\"%%d check_accept start (%%d)\\n\", depth, i);",
	"#endif",
	"	now._a_t = 13;	/* 13 to help the hasher */",
	"	A_depth = depth;",
	"	memcpy((char *)&A_Root, (char *)&now, vsize);",
	"	depthfound = depth;",
	"	new_state();	/* the 2nd search */",
	"	depthfound = -1;",
	"#ifdef DEBUG",
	"	printf(\"%%d check_accept returns\\n\", depth);",
	"#endif",
	"	now._a_t = 0;",
	"}",
	"#endif\n",

	"#ifndef BITSTATE",
	"struct H_el {",
	"	struct H_el *nxt;",
#if 0
	"#ifdef CACHE",
	"	struct H_el *lst, *unxt;",
	"	unsigned hslot;",	/* hash table slot   */
	"#endif",
#endif
	"	unsigned sz;",		/* state vector size */
	"	unsigned tagged;",	/* bits 30 and 31 are special */
	"	unsigned state;",
	"} **H_tab;\n",

	"hinit()",
	"{	H_tab = (struct H_el **)",
	"		emalloc((1<<ssize)*sizeof(struct H_el *));",
#if 0
	"	printf(\"hash table uses %%d bytes\\n\", ",
	"		(1<<ssize)*sizeof(struct H_el *));",
	"	fflush(stdout);",
#endif
	"}\n",
	"#ifdef CACHE",
	"#include \"nh_store.c\"",
	"#endif",

	"struct H_el *Free_list = 0;	/* recycles removed states  */",
	"",
	"recycle_state(v, n)",
	"	struct H_el *v;",
	"	short n;",
	"{",
	"	struct H_el *tmp, *last = 0;",
	"	v->tagged = n;",
	"	v->nxt = 0;",
	"	for (tmp = Free_list; tmp; last = tmp, tmp = tmp->nxt)",
	"	{	if (tmp->tagged >= n)",
	"		{	if (last)",
	"			{	v->nxt = tmp->nxt;",
	"				last->nxt = v;",
	"			} else",
	"			{	v->nxt = Free_list;",
	"				Free_list = v;",
	"			}",
	"			return;",
	"		}",
	"		if (!tmp->nxt)",
	"		{	tmp->nxt = v;",
	"			return;",
	"	}	}",
	"	Free_list = v;",
	"}",
	"",
	"struct H_el *",
	"grab_state(n)",
	"{	struct H_el *tmp, *last = 0;",
	"",
	"	for (tmp = Free_list; tmp; last = tmp, tmp = tmp->nxt)",
	"		if (tmp->tagged == n)",
	"		{	if (last)",
	"				last->nxt = tmp->nxt;",
	"			else",
	"				Free_list = tmp->nxt;",
	"			tmp->nxt = 0;",
	"			recycled++;",
	"			return tmp;",
	"		}",
	"	return (struct H_el *)",
	"	      emalloc(sizeof(struct H_el)+n-sizeof(unsigned));",
	"}",
	"",

	"htag(V, N)",
	"	char *V;",
	"	short N;",
	"{",
	"	register struct H_el *tmp, *last = 0;",
	"	char *v; short n;",
	"#ifdef COMPRESS",
	"	n = compress(&v, V, N);",
	"#else",
	"	n = N; v = V;",
	"#endif",
	"	s_hash(v, n);",
	"	for (tmp = H_tab[j1]; tmp; last = tmp, tmp = tmp->nxt)",
	"	{	if (",
	"#ifdef CACHE",
	"		    tmp->sz == n &&",
	"#endif",
	"		    memcmp(((char *)&(tmp->state)), v, n) == 0)",
	"		{",
	"#ifdef CACHE",
	"	if (tmp->tagged & (1<<31)) Uerror(\"Double Htag\");",
	"#endif",
	"			tmp->tagged &= (1<<30); /* preserve only bit 30 */",
	"#if CONNECT==0",
	"#ifdef CACHE",
	"			tmp->tagged |= (1<<31); /* set bit 31 */",
	"#endif",
	"#endif",
	"			if (trpt->tau&2) /* state marked dirty: remove */",
	"			{	if (last)",
	"					last->nxt = tmp->nxt;",
	"				else",
	"					H_tab[j1] = tmp->nxt;",
	"				recycle_state(tmp, n);",
	"			}",
	"			return;",
	"		}",
	"	}",
	"	for (tmp = H_tab[j1], n=0; tmp; tmp = tmp->nxt)",
	"		n++;",
	"	printf(\"cannot happen, htag, length of list is %%d\\n\", n);",
	"	fflush(stdout);",
	"/*	Uerror(\"cannot happen, htag\");	*/",
	"}\n",
	"#ifdef COMPRESS",
#include "compress.h"
	"#endif",

	"#ifndef CACHE",
	"hstore(V, N)",
	"	char *V;",
	"	short N;",
	"{",
	"	register struct H_el *tmp;\n",
	"	char *v; short n;",
	"#ifdef COMPRESS",
	"	n = compress(&v, V, N);",
	"#else",
	"	n = N; v = V;",
	"#endif",
	"	if (Normalize) return 1;",
	"	s_hash((uchar *)v, n);",
	"	tmp = H_tab[j1];",
	"	if (!tmp)",
	"	{  tmp = grab_state(n);",
	"	   H_tab[j1] = tmp;",
	"	} else",
	"	{  for (;; hcmp++)",
	"	   {   if (memcmp(&(tmp->state), v, n) == 0)",
	"	       {	if (tmp->tagged & ~((1<<30)|(1<<31)))",
	"			{	if (loops && now._p_t)",
	"				{	depthfound = tmp->tagged&~(1<<30);",
	"					if (fair_cycle())",
	"					uerror(\"non-progress cycle\");",
	"				}",
	"#ifdef DEBUG",
	" printf(\"match on stack %%d %%d %%d %%d\\n\",",
	"	tmp->tagged, tmp->tagged&(1<<30), ",
	"	tmp->tagged&(1<<31), tmp->tagged& ~((1<<30)|(1<<31)));",
	"#endif",
	"				return 2; /* match on stack */",
	"			} else",
	"				return 1; /* match outside stack */",
	"	       }",
	"	       if (!tmp->nxt) break;",
	"	       tmp = tmp->nxt;",
	"	   }",
	"	   tmp->nxt = grab_state(n);",
	"	   tmp = tmp->nxt;",
	"	}",
	"	tmp->tagged = depth+1; /* non-zero while on stack */",
	"	memcpy(((char *)&(tmp->state)), v, n);",
#ifdef PAIRS
	"#ifdef PAIRS",
	"	if (boq == -1) pairs();",
	"#endif",
#endif
	"	return 0;",
	"}",
	"#endif",
	"#endif",
	"#include \"pan.t\"",
	"",
	"do_reach()",
	"{",
	0,
};
