/*
 * build Huffman tree based on measured probabilities of
 * byte value occurences in the spin state vector
 * (values less than 8 account for 96.4% of all bytes seen)
 */

float prob [256] = {
	0.614,		/* values 0-7, measured on fmodem protocol */
	0.098,
	0.068,
	0.047,
	0.084,
	0.023,
	0.014,
	0.016,
	0		/* values 8-255, all equal (0.8/248) */
};

typedef struct Node {
	float prob;	/* sum of childrens prob's */
	int leaf;
	struct Node *left, *right;
} Node;

Node *Nodes[256]; int nNodes=0;
Node Code[256];
extern char *malloc();

char *
emalloc(n)
{	char *tmp = malloc(n);
	if (!tmp)
	{	printf("out of memory\n");
		exit(1);
	}
	memset(tmp, 0, n);
	return tmp;
}

Node *
rmlowest()
{	Node *tmp;
	int i, victim=-1; float low = 1.0;

	for (i = 0; i < 256; i++)
		if (Nodes[i] && Nodes[i]->prob < low)
		{	low = Nodes[i]->prob;
			victim = i;
		}
	if (victim < 0)
	{	printf("cannot happen - rmnode\n");
		exit(1);
	}
	tmp = Nodes[victim];
	Nodes[victim] = (Node *) 0;
	nNodes--;
	return tmp;
}

addnode(n)
	Node *n;
{
	int i;
	for (i = 0; i < 256; i++)
		if (!Nodes[i])
		{	Nodes[i] = n;
			nNodes++;
			return;
		}
	printf("cannot happen - addnode\n");
	exit(1);
}

buildtree()
{	int r, s; Node *n0, *n1, *tmp;

	while (nNodes > 1)
	{	n0 = rmlowest();
		n1 = rmlowest();

		tmp = (Node *) emalloc(sizeof(Node));
		tmp->left = n0;
		tmp->right = n1;
		tmp->prob = n0->prob + n1->prob;
		addnode(tmp);
	}
}

char string[16]; int nstr=0;
dfs(n)
	Node *n;
{
	int children=0;

	if (n->left)
	{	string[nstr++] = '0';
		dfs(n->left);
		nstr--;
		children++;
	}
	if (n->right)
	{	string[nstr++] = '1';
		dfs(n->right);
		nstr--;
		children++;
	}
	if (children == 0)
	{	string[nstr] = '\0';
		printf("%3d	%s\n", n->leaf-1, string);
	} else if (children == 1)
		printf("cannot happen - children\n");
}

printtree()
{	int i, cnt; Node *ptr;

	for (i = 0; i < 256; i++)
		if (Nodes[i])	/* the root */
		{	dfs(Nodes[i]);
			break;
		}
}

init()
{	int i; float sum, rem;
	for (i = 0; i < 8; i++)
	{	Code[i].prob = prob[i];
		Code[i].leaf = i+1;
		Nodes[nNodes++] = &Code[i];
		sum += prob[i];
	}
	rem = (1.0 - sum)/(256-8);
	for (i = 8; i < 256; i++)
	{	Code[i].prob = rem;
		Code[i].leaf = i+1;
		Nodes[nNodes++] = &Code[i];
	}
}

main()
{
	init();
	buildtree();
	printtree();
}
