/***** spin: main.c *****/

#include <stdio.h>
#include "spin.h"
#include "y.tab.h"

extern int lineno;
FILE	*yyin;
Symbol	*Fname;
int	verbose = 0;
int	analyze = 0;
int	s_trail = 0;
int	m_loss  = 0;
#ifdef DEBUGa
int	auto_a  = 0;
#endif

void
main(argc, argv)
	char *argv[];
{
	Symbol *s;
	char outfile[17];
	int T = (int) time((long *)0);

	outfile[0] = '\0';
	while (argc > 1 && argv[1][0] == '-')
	{	switch (argv[1][1]) {
		case 'a': analyze  =  1; break;
		case 'g': verbose +=  1; break;
		case 'l': verbose +=  2; break;
		case 'm': m_loss   =  1; break;
		case 'n': T = atoi(&argv[1][2]); break;
		case 'p': verbose +=  4; break;
#ifdef DEBUGa
		case 'q': auto_a   =  1; break;
#endif
		case 'r': verbose +=  8; break;
		case 's': verbose += 16; break;
		case 'v': verbose += 32; break;
		case 't': s_trail  =  1; break;
		default : printf("use: spin -[agmlpqrst] [-nN] file\n");
			  printf("\t-a produce an analyzer\n");
			  printf("\t-g print all global variables\n");
			  printf("\t-l print all local variables\n");
			  printf("\t-m lose msgs sent to full queues\n");
			  printf("\t-nN seed for random nr generator\n");
			  printf("\t-p print all statements\n");
#ifdef DEBUGa
			  printf("\t-q find atomicable stmnts \n");
#endif
			  printf("\t-r print receive events\n");
			  printf("\t-s print send events\n");
			  printf("\t-v verbose, more warnings\n");
			  printf("\t-t follow a simulation trail\n");
			  exit(1);
		}
		argc--, argv++;
	}
	if (argc > 1)
	{	char cmd[64];
		Fname = lookup(argv[1]);
		mktemp(strcpy(outfile, "/tmp/spin.XXXXXX"));
#ifdef PLAN9
		sprintf(cmd, "cpp %s | sed 's/#line/#/' > %s", argv[1], outfile);
		if (system(cmd))
		{	remove(outfile);
			exit(1);
		} else if (!(yyin = fopen(outfile, "r")))
		{	printf("cannot open %s\n", outfile);
			exit(1);
		}
#else
		sprintf(cmd, "/lib/cpp %s > %s", argv[1], outfile);
		if (system(cmd))
		{	unlink(outfile);
			exit(1);
		} else if (!(yyin = fopen(outfile, "r")))
		{	printf("cannot open %s\n", outfile);
			exit(1);
		}
		unlink(outfile);
#endif
	} else
		Fname = lookup("<stdin>");
	srand(T);
	s = lookup("_p"); s->type = PREDEF;
	yyparse();
#ifdef PLAN9
	if (strlen(outfile)) remove(outfile);
#endif
	exit(0);
}

yywrap()	/* dummy routine */
{
	return 1;
}

yyerror(s1, s2)
	char *s1, *s2;
{
	extern int yychar;
	printf("spin: %s line %d: ", Fname->name, lineno);
	if (s2)
		printf(s1, s2);
	else
		printf(s1);
	if (yychar) printf("	saw '%d'.\n", yychar);
	printf("\n"); fflush(stdout);
}

void
fatal(s1, s2)
	char *s1, *s2;
{
	yyerror(s1, s2);
	fflush(stdout);
	exit(1);
}

char *
emalloc(n)
{	char *tmp = malloc(n);

	if (!tmp)
		fatal("not enough memory", (char *)0);
	memset(tmp, 0, n);
	return tmp;
}

Node *
nn(s, v, t, l, r)
	Symbol *s;
	Node *l, *r;
{
	Node *n = (Node *) emalloc(sizeof(Node));
	n->nval = v;
	n->ntyp = t;
	n->nsym = s;
	n->fname = Fname;
	n->lft  = l;
	n->rgt  = r;
	return n;
}

Node *
rem_lab(a, b, c)
	Symbol *a, *c;
	Node *b;
{
	return	nn((Symbol *)0, 0, EQ,
		nn(lookup("_p"), 0, 'p', nn(a, 0, '?', b, (Node *)0), (Node *)0),
		nn(c, 0, 'q', nn(a, 0, NAME, (Node *)0, (Node *)0), (Node *)0));
}

Node *
rem_var(a, b, c)
	Symbol *a;
	Node *b, *c;
{
	Node *tmp;
	tmp = nn(a, 0, '?', b, (Node *)0);
	return nn(c->nsym, 0, 'p', tmp, c->lft);
}
