/***** spin: lex.l *****/

%{
/* #define YYLMAX		4096	/* size of yytext */
#include "spin.h"
#include "y.tab.h"

int		lineno=1;
unsigned char	in_comment=0;
extern Symbol	*Fname;

#define Token	if (!in_comment) return
%}

%%
"/*"	{ in_comment=1; }
"*/"	{ in_comment=0; }
\n    	{ lineno++; }
[ \t]	{ /* ignore white space */ }
[0-9]+	{ yylval.val = atoi(yytext); Token CONST; }
\#\ [0-9]+\ \"[^\"]*\"[ 0-9]* {	/* preprocessor directive */
		int i=1;
		while (yytext[i] == ' ') i++;
		lineno = atoi(&yytext[i])-1;
		while (yytext[i] != ' ') i++;
		Fname = lookup(&yytext[i+1]);
	}
\".*\"	{ yylval.sym = lookup(yytext); Token STRING; }
"never" { yylval.sym = lookup(":never:"); Token CLAIM; }
"init"	{ yylval.sym = lookup("_init"); Token INIT; }
"int"	{ yylval.val =   INT; Token TYPE; }
"short"	{ yylval.val = SHORT; Token TYPE; }
"byte"	{ yylval.val =  BYTE; Token TYPE; }
"bool"	{ yylval.val =   BIT; Token TYPE; }
"bit"	{ yylval.val =   BIT; Token TYPE; }
"chan"	{ yylval.val =  CHAN; Token TYPE; }
"skip"	{ yylval.val =  1; Token CONST; }
[a-zA-Z_][a-zA-Z_0-9]* { Token check_name(yytext); }
"::"	{ yylval.val = lineno; Token SEP; }
"=" 	{ yylval.val = lineno; Token ASGN; }
"!" 	{ yylval.val = lineno; Token SND; }
"?" 	{ yylval.val = lineno; Token RCV; }
"->"	{ Token ';'; /* statement separator */ }
"<<"	{ Token LSHIFT; /* shift bits left  */ }
">>"	{ Token RSHIFT; /* shift bits right */ }
"<="	{ Token     LE; /* less than or equal to */ }
">="	{ Token     GE; /* greater than or equal to */ }
"=="	{ Token     EQ; /* equal to */ }
"!="	{ Token     NE; /* not equal to */ }
"&&"	{ Token    AND; /* logical and */ }
"||"	{ Token     OR; /* logical or */ }
.      	{ Token yytext[0]; }
%%

static struct {
	char *s;	int tok;
} Names[] = {
	"assert",	ASSERT,
	"atomic",	ATOMIC,
	"break",	BREAK,
	"do",		DO,
	"fi",		FI,
	"goto",		GOTO,
	"if",		IF,
	"len",		LEN,
	"mtype",	MTYPE,
	"od",		OD,
	"of",		OF,
	"printf",	PRINT,
	"proctype",	PROCTYPE,
	"run",		RUN,
	"timeout",	TIMEOUT,
	0, 		0,
};

check_name(s)
	char *s;
{
	register int i;
	for (i = 0; Names[i].s; i++)
		if (strcmp(s, Names[i].s) == 0)
		{	yylval.val = lineno;
			return Names[i].tok;
		}
	if (yylval.val = ismtype(s))
		return CONST;
	yylval.sym = lookup(s);	/* symbol table */
	return NAME;
}
