#include <stdio.h>
#include "spin.h"
#include "y.tab.h"

typedef struct HitStack {
	Element *e;
	struct HitStack *lst;
} HitStack;

HitStack  *hitstack = (HitStack *) 0;

int Lastread;
extern int Cksum;	/* debugging only */

void
hit_push(f)
	Element *f;
{
	struct HitStack *hs = (HitStack *) emalloc(sizeof(HitStack));
	hs->e = f;
	hs->lst = hitstack;
	hitstack = hs;
}

void
hit_pop()
{
	while (hitstack)
	{	hitstack->e->status &= ~HIT;
		hitstack = hitstack->lst;
	}
#ifdef DEBUGd
	printf("POP\n");
#endif
}

int
baseocc(nm, n)
	Symbol *nm;
	Node   *n;
{
	if (!n || n->ntyp != NAME)
		return 0;
	if (strcmp(n->nsym->name, nm->name) == 0)
		return 1;
	return 0;
}

int
base2occ(nm, n)
	Symbol *nm;
	Node   *n;
{
	if (!n) return 0;
	return baseocc(nm, n->lft) || base2occ(nm, n->rgt);
}

int
occurs(nm, n)
	Symbol *nm;
	 Node  *n;
{
	if (!n)
		return 0;
	if (n->ntyp == NAME
	&& (strcmp(n->nsym->name, nm->name) == 0) || occurs(nm, n->lft))
		return 1;
	return (occurs(nm, n->lft) || occurs(nm, n->rgt));
}

void
checknames(fd, n, m, f, topush)
	FILE  *fd;
	Node  *n;
	Element *f;
{
	if (!n) return;
	if (n->ntyp == NAME)
	{	hit_pop();
		if (lastread(n->nsym, m, f))
		{	char rbuf[32];
			if (topush)
			{	sprintf(rbuf, ", %d)", Cksum);
				putname(fd, ";\n\t\tpushvarval(", n, m, rbuf);
				putname(fd, ";\n\t\t", n, m, " = 0;");
#ifdef DEBUGd
				putname(stdout,"	pushvarval(", n, m, rbuf);
				printf("\n");
#endif
				Lastread = 1;
			} else
			{	sprintf(rbuf, " = popvarval(%d);\n\t\t", Cksum);
				putname(fd, "", n, m, rbuf);
		}	}
	} else
		checknames(fd, n->rgt, m, f, topush);
	checknames(fd, n->lft, m, f, topush);
}

int
checklast(fd, n, f, seqno, topush)
	FILE   *fd;
	Node    *n;
	Element *f;
{
	Lastread = 0;
	switch (n->ntyp) {
	case   ASGN:
		checknames(fd, n->rgt, seqno, f, topush);
		break;
	case  PRINT:
	case    RUN:
	case    'c':
	case ASSERT:
		checknames(fd, n->lft, seqno, f, topush);
		break;
	case    's':
		checknames(fd, n, seqno, f, topush);
		break;
	case    'r':
	case    'R':
		checknames(fd, n->lft, seqno, f, topush);
		break;
	default:
		break;
	}
	return Lastread;
}

int
lastread(nm, seqno, f)
	Symbol  *nm;
	Element *f;
{
	Element *e;
	SeqList *h;
#ifdef DEBUGd
	printf("lastread %s %d f:<%u> status %d",
		nm->name, seqno, f, f?(f->status&HIT):-1);
#endif
	if (!f || !f->n || f->status & HIT)
#ifdef DEBUGd
	{	printf("\t!f || !f->n || f->status & HIT\n");
#endif
		return 1;
#ifdef DEBUGd
	}
	printf("\n");
#endif
	f->status |= HIT;
	hit_push(f);
	e = f->nxt;

	switch (f->n->ntyp) {
	case   ASGN:	if (occurs(nm, f->n->rgt)) return 0;
			if (baseocc(nm, f->n->lft)) return 1;
			break;
	case    ':':
	case  PRINT:
	case    'c':
	case ASSERT:	if (occurs(nm, f->n->lft)) return 0;
			break;
	case   GOTO:	e = huntele(get_lab(f->n->nsym), f->status);
			break;
	case    's':	if (occurs(nm, f->n)) return 0; break;
	case    'r':	if (occurs(nm, f->n->lft)) return 0;
			if (base2occ(nm, f->n->rgt)) return 1;
			break;
	case    'R':	if (occurs(nm, f->n->lft)) return 0;
			break;
	case ATOMIC:	e = f->n->seql->this->frst;
			break;
	case IF: case DO:
			if (f->sub)
			{	for (h = f->sub; h; h = h->nxt)
				{	e = h->this->frst;
#ifdef DEBUGd
					if (e) printf("IF/DO--%u--", f->sub);
#endif
					if (e && !lastread(nm, e->seqno, e))
						return 0;
				}
				return 1;
			}
			printf("error dflow: if/do wout sub\n");
			return 1;
	default:	break;
	}
	return lastread(nm, e?e->seqno:0, e);
}
