/***** spin: debug.c *****/

#include <stdio.h>
#include "spin.h"
#include "y.tab.h"

void
explain(q)
	Node *q;
{
	if (!q)
		printf("NULL\n");
	else switch (q->ntyp) {
	case ATOMIC:	printf("ATOMIC\n"); break;
	case IF:	printf("IF\n"); break;
	case DO:	printf("DO\n"); break;
	case BREAK:	printf("BREAK\n"); break;
	case GOTO:	printf("GOTO\n"); break;
	case ASSERT:	printf("ASSERT\n"); break;
	case TIMEOUT:	printf("TIMEOUT\n"); break;
	case LEN:	printf("LEN\n"); break;
	case RUN:	printf("RUN %s\n", q->nsym->name); break;
	case PRINT:	printf("PRINT \"%s\"\n", q->nsym->name); break;
	case CONST:	printf("CONST (%d)\n", q->nval); break;
	case NAME:	printf("NAME (%s)\n",q->nsym->name);
			printf("\t[%d] type %d\n", q->nsym->nel,
				q->nsym->type);
			if (q->nsym->context)
				printf("\t>>%s<<\n",
				q->nsym->context->name);
			break;
	case UMIN:	printf("UMIN\n"); break;
	case OR:	printf("OR\n"); break;
	case AND:	printf("AND\n"); break;
	case NE:	printf("NE\n"); break;
	case EQ:	printf("EQ\n"); break;
	case GE:	printf("GE\n"); break;
	case LE:	printf("LE\n"); break;
	case LSHIFT:	printf("<<\n"); break;
	case RSHIFT:	printf(">>\n"); break;
	case ASGN:	printf("%s =\n", q->nsym->name); break;
	case 'c':	printf("CONDITION:\n\t"); explain(q->lft); break;
	case '@':	printf("stopped\n"); break;
	default:	printf("`%c'\n", q->ntyp); break;
	}
	fflush(stdout);
}
