#include <stdio.h>
#include "spin.h"
#include "y.tab.h"
#include <ctype.h>

#define Cat0(x)   	comwork(fd,now->lft,m); fprintf(fd, x); \
			comwork(fd,now->rgt,m)
#define Cat1(x)		fprintf(fd,"("); Cat0(x); fprintf(fd,")")
#define Cat2(x,y)  	fprintf(fd,x); comwork(fd,y,m)
#define Cat3(x,y,z)	fprintf(fd,x); comwork(fd,y,m); fprintf(fd,z)

extern int Mpars, terse, nocast;

comment(fd, now, m)
	FILE *fd;
	Node *now;
{
	terse=nocast=1;
	comwork(fd, now, m);
	terse=nocast=0;
}

comwork(fd, now, m)
	FILE *fd;
	Node *now;
{
	Node *v;
	int i, j;

	if (!now) { fprintf(fd, "0"); return; }
	switch (now->ntyp) {
	case CONST:	fprintf(fd, "%d", now->nval); break;
	case '!':	Cat3("!(", now->lft, ")"); break;
	case UMIN:	Cat3("-(", now->lft, ")"); break;
	case '~':	Cat3("~(", now->lft, ")"); break;

	case '/':	Cat1("/");  break;
	case '*':	Cat1("*");  break;
	case '-':	Cat1("-");  break;
	case '+':	Cat1("+");  break;
	case '%':	Cat1("%%"); break;
	case '<':	Cat1("<");  break;
	case '>':	Cat1(">");  break;
	case '&':	Cat1("&");  break;
	case '|':	Cat1("|");  break;
	case LE:	Cat1("<="); break;
	case GE:	Cat1(">="); break;
	case NE:	Cat1("!="); break;
	case EQ:	Cat1("=="); break;
	case OR:	Cat1("||"); break;
	case AND:	Cat1("&&"); break;
	case LSHIFT:	Cat1("<<"); break;
	case RSHIFT:	Cat1(">>"); break;

	case RUN:	fprintf(fd, "run %s(", now->nsym->name);
			for (v = now->lft; v; v = v->rgt)
				if (v == now->lft)
				{	Cat2("", v->lft);
				} else
				{	Cat2(",", v->lft);
				}
			fprintf(fd, ")");
			break;
	case LEN:	putname(fd, "len(", now->lft, m, ")");
			break;

	case 's':	putname(fd, "", now->lft, m, "!");
			for (v = now->rgt, i = 0; v; v = v->rgt, i++)
			{	if (v != now->rgt) fprintf(fd,",");
				if (v->lft->ntyp == CONST)
					symbolic(fd,v->lft->nval);
				else
					comwork(fd,v->lft,m);
			}
			for ( ; i < Mpars; i++)
				fprintf(fd, ", 0");
			break;
	case 'r':	putname(fd, "", now->lft, m, "?");
			for (v = now->rgt, i=j=0; v; v = v->rgt, i++)
			{	if (v != now->rgt) fprintf(fd,",");
				if (v->lft->ntyp == CONST)
					symbolic(fd,v->lft->nval);
				else
					comwork(fd,v->lft,m);
			}
			break;
	case 'R':	putname(fd, "", now->lft, m, "?[");
			for (v = now->rgt, i=j=0; v; v = v->rgt, i++)
			for (v = now->rgt, i=j=0; v; v = v->rgt, i++)
			{	if (v != now->rgt) fprintf(fd,",");
				if (v->lft->ntyp == CONST)
					symbolic(fd,v->lft->nval);
				else
					comwork(fd,v->lft,m);
			}
			fprintf(fd, "]");
			break;

	case 'c':	Cat3("(", now->lft, ")");
			break;
	case ASGN:	comwork(fd,now->lft,m);
			fprintf(fd," = ");
			comwork(fd,now->rgt,m);
			break;
	case PRINT:	fprintf(fd, "printf(%s", now->nsym->name);
			for (v = now->lft; v; v = v->rgt)
				Cat2(",", v->lft);
			fprintf(fd, ")");
			break;
	case NAME:	putname(fd, "", now, m, "");
			break;
	case   'p':	putremote(fd, now, m);
			break;
	case   'q':	fprintf(fd, "%s", now->nsym->name);
			break;
	case ASSERT:	Cat3("assert(", now->lft, ",");
			Cat3("\"", now->lft, "\\n\", II, tt, t)");
			break;
	case   '.':
	case BREAK:
	case  GOTO:	fprintf(fd, "goto", m); break;
	case   '@':	break;

	case ATOMIC:	fprintf(fd, "ATOMIC"); break;
	case IF:	fprintf(fd, "IF"); break;
	case DO:	fprintf(fd, "DO"); break;
	case TIMEOUT:	fprintf(fd, "timeout"); break;
	default:	if (isprint(now->ntyp))
				fprintf(fd, "`%c'", now->ntyp);
			else
				fprintf(fd, "%d", now->ntyp);
			break;
	}
}

symbolic(fd, v)
	FILE *fd;
{
	extern Node *Mtype;
	Node *n;
	int cnt = 1;

	for (n = Mtype; n; n = n->rgt, cnt++)
		if (cnt == v)
		{	fprintf(fd, "%s", n->lft->nsym->name);
			break;
		}
	if (!n)
		fprintf(fd, "%d", v);
}
