/***** spin: auto_atom.c *****/

#include <stdio.h>
#include "spin.h"
#include "y.tab.h"

void
auto_atomic(s)
	Sequence *s;
{
	auto0(s);
	auto1(s);
	auto2(s);
}

#define FREE	8
	
auto0(s)
	Sequence *s;
{
	Element *f;
	SeqList *h;
	/* label every state that is free of sync reqs */
	for (f = s->frst; ; f = f->nxt)
	{	if (f->status & FREE || f->status & ATOM)
			break;
		if (atomicable(f->n))
			f->status |= FREE;
		for (h = f->sub; h; h = h->nxt)
			if (!auto0(h->this))
				f->status &= ~FREE;
		if (f == s->last)
			break;
	}
	return (s->frst->status & FREE);
}
	
auto1(s)
	Sequence *s;
{
	Element *f, *g;
	SeqList *h;
	/* label every state for which we know
	   that its successor is sync free
	*/
	for (f = s->frst; ; f = f->nxt)
	{	if (f->status & ATOM)
			break;
		switch (f->n->ntyp) {
		case GOTO:
			g = get_lab(f->n->nsym);
			if (g->status & FREE)
				f->status |= ATOM;
			if (f->sub)
			yyerror("Cannot Happen Auto", (char *)0);
			break;
		case ATOMIC: case IF: case DO:
			f->status |= ATOM;
			for (h = f->sub; h; h = h->nxt)
				if (!auto1(h->this))
					f->status &= ~ATOM;
			break;
		default:
			if (f->nxt && f->nxt->status & FREE)
				f->status |= ATOM;
			if (f->sub)
			yyerror("Cannot Happen Auto", (char *)0);
			break;
		}
		if (f == s->last)
			break;
	}
	return (s->frst->status & FREE);
}

void
auto2(s)
	Sequence *s;
{
	Element *f, *g;
	SeqList *h;
	/* label the tail of a chain */
	for (f = s->frst; ; f = f->nxt)
	{	if (f->status & ATOM)
		{	switch (f->n->ntyp) {
			case GOTO:
				g = get_lab(f->n->nsym);
				if (!(g->status & ATOM))
					g->status |= L_ATOM;
				break;
			case IF: case DO: case ATOMIC:
				for (h = f->sub; h; h = h->nxt)
				if (!(h->this->frst->status & ATOM))
				h->this->frst->status |= L_ATOM;
				break;
			default:
				if (!f->nxt)
				{	f->status &=  ~ATOM;
					f->status |= L_ATOM;
				} else
				if (!(f->nxt->status & ATOM))
					f->nxt->status |= L_ATOM;
				break;
		}	}
		for (h = f->sub; h; h = h->nxt)
			auto2(h->this);
		if (f == s->last)
			break;
	}
}

atomicable(now)
	Node *now;
{
	if (!now) return 1;
	switch (now->ntyp) {
	case ATOMIC:
	case RUN: case TIMEOUT:
	case LEN: case '@': case 'p': case 'q':
	case 's': case 'r': case 'R':
		return 0;

	case CONST: case PRINT: case GOTO:
	case IF: case DO: case BREAK: case '.':
		return 1;

	case '!': case UMIN: case '~':
	case 'c': case ASSERT:
		return atomicable(now->lft);

	case   '/': case   '*': case   '-':
	case   '+': case   '%': case   '<':
	case   '>': case   '&': case   '|':
	case    LE: case    GE: case    NE:
	case    EQ: case    OR: case   AND:
	case LSHIFT: case RSHIFT:
		return (atomicable(now->lft) && atomicable(now->rgt));

	case   '=':
		if (now->lft->nsym->context && now->lft->nsym->type)
			return atomicable(now->rgt);
		else
			return 0;
	case  NAME:
		if (now->nsym->context && now->nsym->type)
			return atomicable(now->lft);
		else
			return 0;
	}
	printf("spin: bad node type %d (auto)\n", now->ntyp);
	fflush(stdout);
	exit(1);
}
