/***** spin: vars.c *****/

#include "spin.h"

getval(s, n)
	Symbol *s;
{
	if (s->context && s->type)
		return getlocal(s, n);
	if (!s->type)	/* not declared locally */
		s = lookup(s->name); /* try global */
	return getglobal(s, n);
}

setval(v, n)
	Node *v;
{
	if (v->nsym->context && v->nsym->type)
		return setlocal(v, n);
	if (!v->nsym->type)
		v->nsym = lookup(v->nsym->name);
	return setglobal(v, n);
}

checkvar(s, n)
	Symbol *s;
{
	int i;
	if (n >= s->nel || n < 0)
	{	yyerror("array indexing error %s", s->name);
		return 0;
	}
	if (s->val == (int *) 0)
	{	/* allocate storage and initialize */
		s->val = (int *) emalloc(s->nel*sizeof(int));
		for (i = 0; i < s->nel; i++)
			s->val[i] = s->ini;
	}
	if (s->type == 0)
	{	yyerror("undeclared variable `%s'", s->name);
		s->type = 32;	/* assume int */
	}
	return 1;
}

getglobal(s, n)
	Symbol *s;
{
	if (checkvar(s, n))
		return cast_val(s->type, s->val[n]);
	return 0;
}

cast_val(t, v)
{	switch (t) {
	case 32: return v;
	case 16: return (short) v;
	case  8: return v&255;
	case  1: return v&1;
	}
	return 0;
}

setglobal(v, m)
	Node *v;
{
	int n = eval(v->lft);

	if (checkvar(v->nsym, n))
		v->nsym->val[n] = m;
	return 1;
}
