/***** spin: spin.y *****/

%{
#include "spin.h"
#define YYDEBUG	10
#define Stop	nn(0,lineno,'@',0,0)
extern Symbol	*context;
extern int	lineno;
int yydebug = 0;
%}

%union{
	int      val;
	Node     *node;
	Symbol   *sym;
	Sequence *seq;
	SeqList  *seql;
}

%token	<val>	CHAN RUN LEN DEL OF
%token	<val>	CONST TYPE ASGN
%token	<sym>	NAME
%token	<sym>	STRING INIT
%token	<val>	ASSERT BLOCK
%token	<val>	GOTO BREAK MTYPE SEP
%token	<val>	IF FI DO OD ATOMIC
%token	<val>	SND RCV PRINT TIMEOUT 
%token	<val>	PROCTYPE

%type	<sym>	var ivar
%type	<node>	expr var_list stmnt
%type	<node>	args arg typ_list decl
%type	<node>	decl_lst one_decl any_decl
%type	<node>	prargs margs lvalue step
%type	<seql>	options
%type	<seq>	option body

%right		ASGN
%left		SND RCV
%left		OR
%left		AND
%left		'|'
%left		'&'
%left		EQ NE
%left		'>' '<' GE LE
%left		LSHIFT RSHIFT
%left		'+' '-'
%left		'*' '/' '%'
%right		'~' UMIN NEG
%%

/** Grammar Rules **/

program : units			{ sched(); }
	;
units	: unit | units unit
	;
unit	: proc
	| init
	| one_decl
	| mtype
	;
proc	: PROCTYPE NAME		{ context = $2; }
		'(' decl ')'
	  body			{ ready($2, $5, $7);
				  context = (Symbol *) 0;
				}
	;
init	: INIT			{ context = $1; }
	  body			{ runnable($3, $1);
				  context = (Symbol *) 0;
				}
	;
mtype	: MTYPE ASGN '{' args '}' { setmtype($4); }
	| ';'	/* optional ; as separator of units */
	;
body	: '{'			{ open_seq(1); }
	     sequence		{ add_seq(Stop); }
	  '}'			{ $$ = close_seq(); }
	;
sequence: step			{ add_seq($1); }
	| sequence ';' step	{ add_seq($3); }
	;
step	: any_decl stmnt	{ $$ = $2; }
	;
any_decl: /* empty */		{ $$ = (Node *) 0; }
	| one_decl ';' any_decl	{ $$ = nn(0, 0, ',', $1, $3); }
	;
one_decl: TYPE var_list		{ settype($2, $1); $$ = $2; }
	;
decl_lst: one_decl		{ $$ = nn(0, 0, ',', $1,  0); }
	| one_decl ';' decl_lst	{ $$ = nn(0, 0, ',', $1, $3); }
	;
decl	: /* empty */		{ $$ = (Node *) 0; }
	| decl_lst		{ $$ = $1; }
	;
var_list: ivar			{ $$ = nn($1, 0, TYPE,  0,  0); }
	| ivar ',' var_list	{ $$ = nn($1, 0, TYPE,  0, $3); }
	;
ivar	: var			{ $$ = $1; }
	| var ASGN CONST	{ $1->ini = $3; $$ = $1; }
	;
var	: NAME			{ $$ = $1; }
	| NAME '[' CONST ']'	{ $1->nel = $3; $$ = $1; }
	;
lvalue	: NAME			{ $$ = nn($1, 0,  NAME,  0,  0); }
	| NAME '[' expr ']'	{ $$ = nn($1, 0,  NAME, $3,  0); }
	;
stmnt	: lvalue ASGN expr	{ $$ = nn( 0,$2,   '=', $1, $3); }
	| PRINT '(' STRING prargs ')' { $$ = nn($3,$1, PRINT, $4, 0); }
	| ASSERT expr		{ $$ = nn(0, $1, ASSERT, $2,  0); }
	| BLOCK			{ $$ = nn(0, $1, ASSERT,  0,  0); }
	| GOTO NAME		{ $$ = nn($2,$1,   GOTO,  0,  0); }
	| expr			{ $$ = nn(0,lineno, 'c', $1,  0); }
	| expr RCV margs	{ $$ = nn(0, $2, 'r', $1, $3); }
	| expr SND margs	{ $$ = nn(0, $2, 's', $1, $3); }
	| NAME ':' stmnt	{ $$ = nn($1,$3->nval,':',$3, 0); }
	| IF options FI		{ $$ = nn(0, $1, IF, 0, 0);
				  $$->seql = $2;
				}
	| DO			{ pushbreak(); }
	  options OD		{ $$ = nn(0, $1, DO, 0, 0);
				  $$->seql = $3;
				}
	| BREAK			{ $$ = nn(break_dest(),$1,GOTO,0,0); }
	| ATOMIC
	  '{'			{ open_seq(0); }
	     sequence
	  '}'			{ $$ = nn(0,$1, ATOMIC, 0, 0);
				  $$->seql = seqlist(close_seq(), 0);
				  make_atomic($$->seql->this);
				}
	;
options	: option		{ $$ = seqlist($1, 0); }
	| option options	{ $$ = seqlist($1, $2); }
	;
option	: SEP			{ open_seq(0); }
	  sequence		{ $$ = close_seq(); }
	;
expr	: '(' expr ')'		{ $$ = $2; }
	| expr '+' expr		{ $$ = nn(0, 0,  '+', $1, $3); }
	| expr '-' expr		{ $$ = nn(0, 0,  '-', $1, $3); }
	| expr '*' expr		{ $$ = nn(0, 0,  '*', $1, $3); }
	| expr '/' expr		{ $$ = nn(0, 0,  '/', $1, $3); }
	| expr '%' expr		{ $$ = nn(0, 0,  '%', $1, $3); }
	| expr '>' expr		{ $$ = nn(0, 0,  '>', $1, $3); }
	| expr '<' expr		{ $$ = nn(0, 0,  '<', $1, $3); }
	| expr '&' expr		{ $$ = nn(0, 0,  '&', $1, $3); }
	| expr '|' expr		{ $$ = nn(0, 0,  '|', $1, $3); }
	| expr GE  expr		{ $$ = nn(0, 0,   GE, $1, $3); }
	| expr LE  expr		{ $$ = nn(0, 0,   LE, $1, $3); }
	| expr EQ  expr		{ $$ = nn(0, 0,   EQ, $1, $3); }
	| expr NE  expr		{ $$ = nn(0, 0,   NE, $1, $3); }
	| expr AND expr		{ $$ = nn(0, 0,  AND, $1, $3); }
	| expr OR  expr		{ $$ = nn(0, 0,   OR, $1, $3); }
	| expr LSHIFT expr	{ $$ = nn(0, 0,LSHIFT,$1, $3); }
	| expr RSHIFT expr	{ $$ = nn(0, 0,RSHIFT,$1, $3); }
	| '~' expr		{ $$ = nn(0, 0,  '~', $2,  0); }
	| '-' expr %prec UMIN	{ $$ = nn(0, 0, UMIN, $2,  0); }
	| SND expr %prec NEG	{ $$ = nn(0, 0,  '!', $2,  0); }
	| RUN NAME '(' args ')'	{ $$ = nn($2,$1, RUN, $4,  0); }
	| LEN  '(' expr ')'	{ $$ = nn(0, $1, LEN, $3,  0); }
	| DEL  '(' expr ')'	{ $$ = nn(0, $1, DEL, $3,  0); }
	| CHAN '[' CONST ']' OF '{' typ_list '}'
				{ $$ = nn(0,$3,   CHAN,  0, $7); }
	| NAME '[' expr ']'	{ $$ = nn($1,0,   NAME, $3,  0); }
	| NAME			{ $$ = nn($1,0,   NAME,  0,  0); }
	| CONST			{ $$ = nn(0,$1,  CONST,  0,  0); }
	| TIMEOUT		{ $$ = nn(0,$1,TIMEOUT,  0,  0); }
	;
args	: /* empty */		{ $$ = (Node *) 0; }
	| arg			{ $$ = $1; }
	;
arg	: expr			{ $$ = nn(0, 0, ',', $1,  0); }
	| expr ',' arg		{ $$ = nn(0, 0, ',', $1, $3); }
	;
typ_list: TYPE			{ $$ = nn(0, 0, $1, 0,  0); }
	| TYPE ',' typ_list	{ $$ = nn(0, 0, $1, 0, $3); }
	;
prargs	: /* empty */		{ $$ = (Node *) 0; }
	| ',' arg		{ $$ = $2; }
	;
margs	: args			{ $$ = $1; }
	| expr '(' args ')'	{ $$ = nn(0, 0, ',', $1, $3); }
	;
%%
