/***** spin: spin.h *****/

typedef struct Symbol {
	char *name;
	short type;		/* width in bits, 1,8,16 or 32 */
	int ini;		/* initial value, default is 0 */
	int nel;		/* 1 if scalar, size if array  */
	int *val;		/* runtime value(s) */
	struct Symbol *context;	/* 0 if global, else *procname */
	struct Symbol *next;
} Symbol;

typedef struct Node {
	int   nval;		/* value attribute   */
	short ntyp;		/* node type         */
	Symbol *nsym;		/* new attribute     */
	struct SeqList *seql;	/* list of sequences */
	struct Node *lft, *rgt;	/* hooks parse tree  */
} Node;

typedef struct Queue {
	short qlen;             /* nr messages stored  */
	short qid;		/* address of this q   */
	short nslots, nflds;	/* capacity, flds/slot */
	short *fld_width;       /* type of each field  */
	int *contents;          /* the actual buffer   */
	struct Queue *nxt;      /* the next queue      */
} Queue;

typedef struct Element {
	Node *n;		/* defines the type & contents */
	int seqno;		/* uniquely identifies this el */
	unsigned char status;	/* used by analyzer generator  */
	struct SeqList *sub;	/* subsequences, for compounds */
	struct Element *nxt;	/* linked list */
} Element;

typedef struct Sequence {
	Element *frst;
	Element *last;
} Sequence;

typedef struct SeqList {
	Sequence *this;		/* one sequence */
	struct SeqList *nxt;	/* linked list  */
} SeqList;

typedef struct Label {
	Symbol *s;
	Element *e;
	struct Label *nxt;
} Label;

typedef struct Lbreak {
	Symbol *l;
	struct Lbreak *nxt;
} Lbreak;

typedef struct RunList {
	Symbol *n;	/* name */
	int pid;	/* process id */
	int maxseq;	/* used by analyzer generator */
	Element *pc;	/* current stmnt */
	Symbol *symtab;	/* local variables */
	struct RunList *nxt;
} RunList;

typedef struct ProcList {
	Symbol *n;	/* name */
	Node *p;	/* parameters */
	Sequence *s;	/* body */
	struct ProcList *nxt;
} ProcList;

extern Sequence	*close_seq();	/* end sequence */
extern SeqList	*seqlist();	/* linked list */
extern Symbol	*break_dest();	/* destination break */
extern Symbol	*lookup();	/* symbol table */
extern Node	*nn();		/* new node */
extern char	*emalloc();	/* interface to malloc */
extern void	exit();		/* library functions */
extern char	*strcpy(), *strcat();
extern char	*mktemp();
extern long	time();		/* seeds random nr gen */

#define DONE	1      		/* status bits of elements */
#define ATOM	2      		/* part of an atomic chain */
#define L_ATOM	4      		/* last element in a chain */
#define Nhash	255    		/* size of hash table */

#define max(a,b) (((a)<(b)) ? (b) : (a))
