/***** spin: sched.c *****/
#include <stdio.h>
#include "spin.h"
#include "y.tab.h"

int nproc = 0;
int nstop = 0;
int Tval  = 0;
int Rvous = 0;

RunList  *run = (RunList  *) 0;
RunList  *X = (RunList  *) 0;
ProcList *rdy = (ProcList *) 0;
Element *eval_sub();
extern int verbose, lineno, s_trail, analyze;

runnable(s, n)
	Sequence *s;	/* body */
	Symbol *n;	/* name */
{
	RunList *r = (RunList *) emalloc(sizeof(RunList));
	r->n = n;
	r->pid = nproc++;
	r->pc = s->frst;
	r->maxseq = s->last->seqno;
	r->nxt = run;
	run = r;
}

ready(n, p, s)
	Symbol *n;	/* process name */
	Node *p;	/* formal parameters */
	Sequence *s;	/* process body */
{
	ProcList *r = (ProcList *) emalloc(sizeof(ProcList));
	r->n = n;
	r->p = p;
	r->s = s;
	r->nxt = rdy;
	rdy = r;
}

enable(s, n)
	Symbol *s;	/* process name */
	Node *n;	/* actual parameters */
{
	ProcList *p;
	for (p = rdy; p; p = p->nxt)
		if (strcmp(s->name, p->n->name) == 0)
		{	runnable(p->s, p->n);
			setparams(run, p, n);
			return 1;
		}
	return 0; /* process not found */
}

sched()
{	Element *e;
	RunList *Y;	/* previous process in run queue */
	int i;

	if (analyze)
	{	gensrc();
		return;
	} else if (s_trail)
	{	match_trail();
		return;
	}
	for (Tval=i=0; Tval < 2; Tval++, i=0)
	{	while (i < nproc-nstop)
		for (X=run, Y=(RunList *)0, i=0; X; X = X->nxt)
		{	lineno = X->pc->n->nval;
#ifdef DEBUG
			printf("process %s\n", X->n->name);
#endif
			if (e = eval_sub(X->pc))
			{	X->pc = e; Tval=0;
				talk(e, X->symtab);
			} else
			{	if (X->pc->n->ntyp == '@')
				{	if (Y)
						Y->nxt = X->nxt;
					else
						run = X->nxt;
					nstop++; Tval=0;
					if (verbose&4)
					{	whoruns();
						printf("terminates\n");
					}
				} else
					i++;
			}
			Y = X;
	}	}
	wrapup();
}

wrapup()
{	extern int depth;
	if (depth)	/* for guided simulations, Chapter 12 */
		printf("step %d, ", depth);
	if (nproc != nstop)
	{	printf("#processes blocked: %d\n", nproc-nstop);
		allglobals();
		verbose &= ~1;	/* no more globals */
		verbose |=  4;	/* add process states */
		for (X = run; X; X = X->nxt)
			talk(X->pc, X->symtab);
	}
	printf("%d processes created\n", nproc);
}

complete_rendez()
{	RunList *orun = X;
	Element *e;
	int res=0;

	if (s_trail)	/* for guided simulations, Chapter 12 */
		return 1;
	Rvous = 1;
	for (X = run; X; X = X->nxt)
		if (X != orun && (e = eval_sub(X->pc)))
		{	X->pc = e;
			if (verbose&4)
			{	printf("rendez vous: %s ", X->n->name);
				printf("<-> %s\n", orun->n->name);
			}
			res = 1;
			break;
		}
	Rvous = 0;
	X = orun;
	return res;
}

/***** Local Variables *****/

addsymbol(r, s, v)
	RunList *r;
	Symbol  *s;
{
	Symbol *t = (Symbol *) emalloc(sizeof(Symbol));
	int i;

	t->name = s->name;
	t->type = s->type;
	t->nel  = s->nel;
	t->val  = (int *) emalloc(s->nel*sizeof(int));
	for (i = 0; i < s->nel; i++)
		t->val[i] = v;
	t->next = r->symtab;
	r->symtab = t;
}

setparams(r, p, q)
	RunList *r;
	ProcList *p;
	Node *q;
{
	Node *f, *a;	/* formal and actual pars */
	Node *t;	/* list of pars of 1 type */

	for (f = p->p, a = q; f; f = f->rgt)
	for (t = f->lft; t; t = t->rgt, a = (a)?a->rgt:a)
		addsymbol(r, t->nsym, a?eval(a->lft):0);
}

Symbol *
findloc(s, n)
	Symbol *s;
{
	Symbol *r;

	if (n >= s->nel || n < 0)
	{	yyerror("array indexing error %s", s->name);
		return (Symbol *) 0;
	}
	for (r = X->symtab; r; r = r->next)
		if (strcmp(r->name, s->name) == 0)
			break;
	if (!r)
	{	addsymbol(X, s, s->ini);
		r = X->symtab;
	}
	if (r->type == 0)
	{	yyerror("undeclared local variable `%s'", r->name);
		r->type = 32;	/* assume int */
	}
	return r;
}

getlocal(s, n)
	Symbol *s;
{
	Symbol *r = findloc(s, n);
	if (r) return cast_val(r->type, r->val[n]);
	return 0;
}

setlocal(p, m)
	Node *p;
{
	int n = eval(p->lft);
	Symbol *r = findloc(p->nsym, n);
	if (r) r->val[n] = m;
	return 1;
}

whoruns()
{
	if (X) printf("proc %2d (%s)	", X->pid, X->n->name);
}

talk(e, s)
	Element *e;
	Symbol *s;
{
	if (verbose&4)
	{	p_talk(e);
		if (verbose&1) allglobals();
		if (verbose&2) dumplocal(s);
	}
}

p_talk(e)
	Element *e;
{
	whoruns();
	printf("line %d (state %d)\n",
		(e && e->n && e->n->nval)?e->n->nval:-1, e->seqno);
}
