/***** spin: run.c *****/

#include "spin.h"
#include "y.tab.h"

Element *
eval_sub(e)
	Element *e;
{
	Element *f, *g, *get_lab();
	SeqList *z;
	int i, j, k;
	extern int Rvous;

	if (!e->n)
		return (Element *)0;
	if (e->n->ntyp == GOTO)
		return get_lab(e->n->nsym);
	if (e->sub)
	{	for (z = e->sub, j=0; z; z = z->nxt)
			j++;
		k = rand()%(j);	/* non-determinism */
		for (i = 0, z = e->sub; i < j+k; i++)
		{	if (i >= k)
				if (f = eval_sub(z->this->frst))
					return f;
			z = (z->nxt)?z->nxt:e->sub;
		}
	} else
	{	if (e->n->ntyp == ATOMIC)
		{	f = e->n->seql->this->frst;
			g = e->n->seql->this->last;
			g->nxt = e->nxt;
			if (!(g = eval_sub(f)))
				return (Element *)0;
			Rvous=0;
			while (g && !(f->status & L_ATOM))
			{	f = g;
				g = eval_sub(f);
			}
			if (!g)
				fatal("atomic sequence blocked");
			return g;
		} else if (Rvous)
		{	if (eval_sync(e->n))
				return e->nxt;
		} else
			return (eval(e->n))?e->nxt:(Element *)0;
	}
	return (Element *)0;
}

eval_sync(now)
	Node *now;
{	/* allow only synchronous receives
	/* and related node types    */

	if (now)
	switch (now->ntyp) {
	case TIMEOUT:	case PRINT:	case ASSERT:
	case RUN:	case CHAN:	case LEN:
	case 's':	case 'c':	case '=':
	case IF:	case DO:	case BREAK:
	case '.':	case DEL:
			return 0;
	case 'r':	if (!q_is_sync(now)) return 0;
	default:	break;
	}
	return eval(now);
}

eval(now)
	Node *now;
{
	extern int Tval;
#ifdef DEBUG
	explain(now);
#endif
	if (now)
	switch (now->ntyp) {
	case CONST: return now->nval;
	case   '!': return !eval(now->lft);
	case  UMIN: return -eval(now->lft);
	case   '~': return ~eval(now->lft);

	case   '/': return (eval(now->lft) / eval(now->rgt));
	case   '*': return (eval(now->lft) * eval(now->rgt));
	case   '-': return (eval(now->lft) - eval(now->rgt));
	case   '+': return (eval(now->lft) + eval(now->rgt));
	case   '%': return (eval(now->lft) % eval(now->rgt));
	case   '<': return (eval(now->lft) <  eval(now->rgt));
	case   '>': return (eval(now->lft) >  eval(now->rgt));
	case   '&': return (eval(now->lft) &  eval(now->rgt));
	case   '|': return (eval(now->lft) |  eval(now->rgt));
	case    LE: return (eval(now->lft) <= eval(now->rgt));
	case    GE: return (eval(now->lft) >= eval(now->rgt));
	case    NE: return (eval(now->lft) != eval(now->rgt));
	case    EQ: return (eval(now->lft) == eval(now->rgt));
	case    OR: return (eval(now->lft) || eval(now->rgt));
	case   AND: return (eval(now->lft) && eval(now->rgt));
	case LSHIFT: return (eval(now->lft) << eval(now->rgt));
	case RSHIFT: return (eval(now->lft) >> eval(now->rgt));

	case TIMEOUT: return Tval;

	case   RUN: return enable(now->nsym, now->lft);
	case  CHAN: return qmake(now);
	case   LEN: return qlen(now);
	case   DEL: return qdel(now);
	case   's': return qsend(now);		/* send      */
	case   'r': return qrecv(now);		/* receive   */
	case   'c': return eval(now->lft);	/* condition */
	case   '=': return setval(now->lft, eval(now->rgt));
	case PRINT: return interprint(now);
	case  NAME: return getval(now->nsym, eval(now->lft));
	case ASSERT: if (eval(now->lft)) return 1;
		     yyerror("assertion violated", (char *) 0);
		     wrapup(); exit(1);
	case  IF: case DO: case BREAK:	/* compound structure */
	case   '.': return 1;	/* return label for compound */
	case   '@': return 0;	/* stop state */
	default   : printf("spin: bad node type %d\n", now->ntyp);
		    exit(1);
	}
	return 0;
}

interprint(n)
	Node *n;
{
	Node *tmp = n->lft;
	char c, *s = n->nsym->name;
	int i, j;
	
	for (i = 0; i < strlen(s); i++)
		switch (s[i]) {
		default:   putchar(s[i]); break;
		case '\"': break; /* ignore */
		case '\\':
			 switch(s[++i]) {
			 case 't': putchar('\t'); break;
			 case 'n': putchar('\n'); break;
			 default:  putchar(s[i]); break;
			 }
			 break;
		case  '%':
			 if ((c = s[++i]) == '%')
			 {	putchar('%'); /* literal */
				break;
			 }
			 if (!tmp)
			 {	yyerror("too few print args %s", s);
				break;
			 }
			 j = eval(tmp->lft);
			 tmp = tmp->rgt;
			 switch(c) {
			 case 'd': printf("%d", j); break;
			 case 'o': printf("%o", j); break;
			 case 'u': printf("%u", j); break;
			 case 'x': printf("%x", j); break;
			 default:  break; /* ignore */
			 }
			 break;
		}
	return 1;
}
