/***** spin: pangen5.c *****/

#include <stdio.h>
#include "spin.h"
#include "y.tab.h"

extern int	nproc, nstop, Tval, Rvous;
extern RunList	*run, *X;
extern ProcList	*rdy;
extern Element	*d_eval_sub(), *huntele(), *get_lab();
extern int	verbose, lineno;
int		depth=0;

match_trail()
{	FILE *fd;
	int i, pno, nst;

	if (!(fd = fopen("pan.trail", "r")))
	{	printf("spin -t: cannot find `pan.trail'\n");
		exit(1);
	}
	Tval = 1; /* timeouts may be part of the trail */
	while (fscanf(fd, "%d:%d:%d:%d\n", &depth, &pno, &nst, &i) == 4)
	{	i = nproc - nstop;
		if (nst == 0)
		{	if (pno == i-1 && run->pc->n->ntyp == '@')
			{	run = run->nxt;
#ifdef DEBUG
				printf("%d: proc %d stopped\n", depth, pno);
#endif
				nstop++;
				continue;
			} else
			{	printf("step %d: stop error, %d %d %c\n",
					depth, pno, i, run->pc->n->ntyp);
				exit(1);
		}	}
#ifdef DEBUG
		printf("process %d, newstate %d\n", pno, nst);
#endif
		for (X = run; X; X = X->nxt)
		{
#ifdef DEBUG
			printf("%d: check %s\n", i, X->n->name);
#endif
			if (--i == pno)
				break;
		}
#ifdef DEBUG
		printf("pick %s (%d in %d - %d)\n",
			(X)?X->n->name:"none", pno, nproc, nstop);
#endif
		if (!X)
		{	printf("step %d: lost trail (proc .%d state %d)\n",
				depth, pno, nst);
			wrapup();
			exit(1);
		}
		lineno = X->pc->n->nval;
		do
		{	X->pc = d_eval_sub(X->pc, pno, nst);
#ifdef DEBUG
		printf("%d: move to %d\n", depth, (X&&X->pc)?X->pc->seqno:0);
fflush(stdout);
#endif
		} while (X && X->pc && X->pc->seqno != nst);
		if (!X || !X->pc)
		{	printf("step %d: lost trail (proc %d state %d.)\n",
				depth, pno, nst);
			wrapup();
			exit(1);
		}
		talk(X->pc, X->symtab);
	}
	printf("spin: trail ends after %d steps\n", depth);
	wrapup();
}

dumplocal(s)
	Symbol *s;
{
	int i;
	Symbol *S = s;
	for (; S; S = S->next)
	if (S->nel > 1)
		for (i = 0; i < S->nel; i++)
		printf("\t\t%s[%d] = %d\n",
				S->name, i, getval(S,i));
	else
		printf("\t\t%s = %d\n", S->name, getval(S,0));
}

allglobals()
{	extern Symbol *symtab[Nhash+1];
	register Symbol *sp;
	register int i, j, k, n, m;

	for (i = 0; i <= Nhash; i++)
	for (sp = symtab[i]; sp; sp = sp->next)
	{	if (!sp->type || sp->context)
			continue;
		for (j=0, m=-1; j < sp->nel; j++)
		{	n = getglobal(sp, j);
			if (j == 0 || n != k)
			{	if (m != j-1)
					printf("\t\t...\n");
				printf("\t\t%s[%d] = %d\n",
					sp->name, j, n);
				m = j;
			}
			k = n;
		}
	}
	allqueues();
}

allqueues()
{	extern Queue *qtab;
	Queue *q;
	int j, k;
	for (q = qtab; q; q = q->nxt)
	for (k = 0; k < q->qlen; k++)
	{	printf("queue %d msg %d: ", q->qid, k);
		for (j = 0; j < q->nflds; j++)
			sr_mesg(q->contents[k*q->nflds+j], j);
		printf("\n");
	}
}

dumpglobal(str)
	char *str;
{
	Symbol *s = lookup(str);
	int n;

	for (n = 0; n < s->nel; n++)
	printf("\t\t%s[%d] = %d\n", str, n, getglobal(s, n));
}

Element *
walk_sub(e, pno, nst)
	Element *e;
{
	SeqList *z;
	Element *f, *huntele();
#ifdef DEBUG
	printf("walk_sub starts\n");
#endif
	for (z = e->sub; z; z = z->nxt)
	{
#ifdef DEBUG
	explain(z->this->frst->n);
#endif
		if (!z->this->frst->nxt)
			fatal("cannot happen", "walk_sub");
		if (z->this->frst->sub)
		{	f = walk_sub(z->this->frst, pno, nst);
			if (f) return f;
		}
		f = huntele(z->this->frst);
		if (f->seqno == nst)
			return f;
		if (f->sub && (f = walk_sub(f, pno, nst)))
			return f;
		if (f->n->ntyp == ATOMIC)
		{	f = f->n->seql->this->frst;
			if (f->seqno == nst)
				return f;
		}
#ifdef DEBUG
		printf("walksub no match, want %d saw %d\n",
				nst, z->this->frst->seqno);
#endif
	}
#ifdef DEBUG
	printf("walk_sub failed\n");
#endif
	return (Element *) 0;
}

Element *
d_eval_sub(s, pno, nst)
	Element *s;
{
	Element *e=s;

	if (e->n->ntyp == GOTO)
	{
#ifdef DEBUG
	printf("d_eval: goto\n"); fflush(stdout);
#endif
		return get_lab(e->n->nsym);
	}
	if (e->sub)
	{	if (e = walk_sub(e, pno, nst))
		{
#ifdef DEBUG
	printf("d_eval: walk_sub\n"); fflush(stdout);
#endif
			return e;
		}
#ifdef DEBUG
	printf("d_eval: !walk_sub\n"); fflush(stdout);
#endif
	} else if (e->n && e->n->ntyp == ATOMIC)
	{	e->n->seql->this->last->nxt = e->nxt;
#ifdef DEBUG
	printf("d_eval: atomic\n"); fflush(stdout);
#endif
		if (e->n->seql->this->frst->seqno == nst)
			return e->n->seql->this->frst;
		return d_eval_sub(e->n->seql->this->frst, pno, nst);
	} else if (eval(e->n))
	{
#ifdef DEBUG
	printf("d_eval: nxt\n"); fflush(stdout);
#endif
		return e->nxt;
	}
#ifdef DEBUG
	else
	{	printf("unexecutable:\t"); fflush(stdout);
		explain(e->n);
	}
#endif
	if (e && (nst == e->seqno))
	{
		printf("step %d: returning %u\n", depth, e); fflush(stdout);
		return e;
	}
	printf("step %d: lost trail (proc %d state .%d) [stuck in %d]\n",
				depth, pno, nst, (e)?e->seqno:-1);
	fflush(stdout);
	wrapup(1);
	exit(1);
}
