/***** spin: pangen4.c *****/

#include <stdio.h>
#include "spin.h"
#include "y.tab.h"

extern FILE	*tc, *tb;
extern Queue	*qtab;

#define cat0(x)   	undostmnt(now->lft,m,pid); fprintf(tb," x "); \
			undostmnt(now->rgt,m,pid)
#define cat1(x)		fprintf(tb,"("); cat0(x); fprintf(tb,")")
#define cat2(x,y)  	fprintf(tb,x); undostmnt(y,m,pid)
#define cat3(x,y,z)	fprintf(tb,x); undostmnt(y,m,pid); fprintf(tb,z)
#define cat4(x,y,z,a)	fprintf(tb,x); undostmnt(y,m,pid); fprintf(tb,z,a)

undostmnt(now, m, pid)
	Node *now;
{
	Node *v;
	int i, j;

	if (!now)
		fprintf(tb, "0");
	else switch (now->ntyp) {
	case CONST:	case '!':	case UMIN:
	case '~':	case '/':	case '*':
	case '-':	case '+':	case '%':
	case '<':	case '>':	case '&':
	case '|':	case LE:	case GE:
	case NE:	case EQ:	case OR:
	case AND:	case LSHIFT:	case RSHIFT:
	case TIMEOUT:	case LEN:	case NAME:
			putstmnt(tb, now, m, pid);
			break;
	case RUN:	fprintf(tb, "delproc(0, now.nr_pr-1)");
			break;
	case CHAN:	fprintf(tb, "delq(0, now.nr_qs-1)");
			break;
	case 's':	cat3("m = unsend(", now->lft, ")");
			break;
	case 'r':	for (v = now->rgt, j = 0; v; v = v->rgt)
				if (v->lft->ntyp != CONST)
					j++;
			if (j > 1)	/* j variables were set */
			{	fprintf(tb, "sv_restor()");
				break;
			}
			for (v = now->rgt, i = 0; v; v = v->rgt, i++)
			{	cat4("unrecv(", now->lft, ", 0, %d, ", i);
				undostmnt(v->lft, m, pid);
				fprintf(tb, ", %d);\n\t\t", (i==0)?1:0);
				if (j == 1 && v->lft->ntyp != CONST)
				{	putstmnt(tb, v->lft, m, pid);
					fprintf(tb, " = trpt->oval;\n\t\t");
				}
			}
			break;
	case DEL:	cat3("q_restor(", now->lft, ")");
			break;
	case '@':	fprintf(tb, "p_restor(II)");
			break;
	case '=':	putstmnt(tb, now->lft, m, pid);
			fprintf(tb, " = trpt->oval");
			checkchan(now->rgt, m, pid);
			break;
	case 'c':	checkchan(now->lft, m, pid);
			break;
	case '.':
	case GOTO:
	case BREAK:	break;
	case ASSERT:
	case PRINT:	checkchan(now, m, pid);
			break;
	case ':':	/* label */ break;
	default:	printf("spin: bad node type %d\n", now->ntyp);
			exit(1);
	}
}

any_undo(now)
	Node *now;
{	/* is there anything to undo on a return move? */

	if (!now) return 1;
	switch (now->ntyp) {
	case 'c':	return any_chan(now->lft);
	case ASSERT:
	case PRINT:	return any_chan(now);
			break;
	case '.':
	case GOTO:
	case BREAK:	return 0;
	default:	return 1;
	}
}

any_chan(now)
	Node *now;
{	/* check if an expression refers to a channel or a process */
	if (!now) return 0;
	if (now->ntyp == DEL
	||  now->ntyp == CHAN
	||  now->ntyp == '@'
	||  now->ntyp == RUN)
		return 1;
	return (any_chan(now->lft) || any_chan(now->rgt));
}

checkchan(now, m, pid)
	Node *now;
{
	if (!now)
		return;
	if (now->ntyp == DEL
	||  now->ntyp == CHAN
	||  now->ntyp == '@'
	||  now->ntyp == RUN)
	{	fprintf(tb, ";\n\t\t");
		undostmnt(now, m, pid);
	}
	checkchan(now->lft, m, pid);
	checkchan(now->rgt, m, pid);
}

genunio()
{	Queue *q; int i;

	fprintf(tc, "unsend(into)\n");
	fprintf(tc, "{	int m, j; unsigned char *z;\n\n");
	fprintf(tc, "	z = qptr(into);\n");
	fprintf(tc, "	j = ((Q0 *)z)->Qlen;\n");
	fprintf(tc, "	((Q0 *)z)->Qlen = --j;\n");
	fprintf(tc, "	switch (((Q0 *)qptr(into))->_t) {\n");
	for (q = qtab; q; q = q->nxt)
	{	fprintf(tc, "	case %d:\n", q->qid);
		for (i = 0; i < q->nflds; i++)
		fprintf(tc, "\t\t((Q%d *)z)->contents[j].fld%d = 0;\n",
			q->qid, i);
		if (q->nslots==0) {
		/* check if rendez-vous succeeded, one level down */
		fprintf(tc, "		m = (trpt+1)->o_m;\n");
		fprintf(tc, "		UnBlock;\n");
		} else {
		fprintf(tc, "		m = trpt->o_m;\n");
		}
		fprintf(tc, "		break;\n");
	}
	fprintf(tc, "	default: uerror(\"bad queue - unsend\");\n");
	fprintf(tc, "	}\n");
	fprintf(tc, "#ifdef DEBUG\n");
	fprintf(tc, "	printf(\"%%d: unsent %%d,%%d\\n\", depth,into,j);\n");
	fprintf(tc, "#endif\n");
	fprintf(tc, "	return m;\n");
	fprintf(tc, "}\n\n");

	fprintf(tc, "unrecv(from, slot, fld, fldvar, strt)\n");
	fprintf(tc, "{	int j;\n");
	fprintf(tc, "	unsigned char *z = qptr(from);\n\n");
	fprintf(tc, "	j = ((Q0 *)z)->Qlen;\n");
	fprintf(tc, "	if (strt) ((Q0 *)z)->Qlen = j+1;\n");
	fprintf(tc, "	switch (((Q0 *)qptr(from))->_t) {\n");
	for (q = qtab; q; q = q->nxt)
	{	fprintf(tc, "	case %d:\n", q->qid);
		if (q->nslots == 0)
			fprintf(tc, "\t\tif (strt) boq = from;\n");
		else if (q->nslots > 1)	/* shift */
		{	fprintf(tc, "\t\tif (strt && slot<%d)\n",
				q->nslots-1);
			fprintf(tc, "\t\t{\tfor (j--; j >= slot; j--)\n");
			fprintf(tc, "\t\t\t{");
			for (i = 0; i < q->nflds; i++)
			{	fprintf(tc, "\t((Q%d *)z)->", q->qid);
				fprintf(tc, "contents[j+1].fld%d =\n", i);
				fprintf(tc, "\t\t\t\t((Q%d *)z)->", q->qid);
				fprintf(tc, "contents[j].fld%d;\n\t\t\t", i);
			}
			fprintf(tc, "}\n\t\t}\n");
		}
		if (q->nflds == 1)	/* set */
		{	fprintf(tc, "\t\tif (fld == 0)\n");
			fprintf(tc, "\t\t((Q%d *)z)->", q->qid);
			fprintf(tc, "contents[slot].fld0 = fldvar;\n");
		} else
		{	fprintf(tc, "\t\tswitch (fld) {\n");
			for (i = 0; i < q->nflds; i++)
			{	fprintf(tc, "\t\tcase %d:\n", i);
				fprintf(tc, "\t\t\t((Q%d *)z)->", q->qid);
				fprintf(tc, "contents[slot].fld%d = fldvar;\n", i);
				fprintf(tc, "\t\t\tbreak;\n");
			}
			fprintf(tc, "\t\t}\n");
		}
		fprintf(tc, "\t\tbreak;\n");
	}
	fprintf(tc, "	default: uerror(\"bad queue - qrecv\");\n");
	fprintf(tc, "	}\n");
	fprintf(tc, "#ifdef DEBUG\n");
	fprintf(tc, "	printf(\"%%d: unrecv %%d,%%d,%%d,%%d = %%d\\n\",\n");
	fprintf(tc, "		depth, from,slot,fld,strt,fldvar);\n");
	fprintf(tc, "#endif\n");
	fprintf(tc, "}\n\n");
}
