/***** spin: pangen2.c *****/

#include <stdio.h>
#include "spin.h"
#include "y.tab.h"
#include "pangen2.h"

extern ProcList	*rdy;
extern RunList	*run;
extern char	filename[];
extern Element	*huntele(), *get_lab();

FILE *tc, *th, *tt, *tm, *tb;
int u_sync=0, u_async=0;
int uniq=1;

whichproc(s)
	Symbol *s;
{
	ProcList *p;
	int i;

	for (p = rdy, i = 1; p; p = p->nxt, i++)
		if (strcmp(p->n->name, s->name) == 0)
			return i;
	return -1;	/* not found */
}

gensrc()
{	ProcList *p;
	int i;

	if (!(tc = fopen("pan.c", "w"))		/* main routines */
	||  !(th = fopen("pan.h", "w"))		/* header file   */
	||  !(tt = fopen("pan.t", "w"))		/* transition matrix */
	||  !(tm = fopen("pan.m", "w"))		/* forward  moves */
	||  !(tb = fopen("pan.b", "w")))	/* backward moves */
	{	printf("spin: cannot create pan.[chtmb]\n");
		exit(1);
	}
	fprintf(th, "char filename[] = %s;\n", filename);

	for (i = 0; Preamble[i]; i++)
		fprintf(tc, "%s\n", Preamble[i]);

	for (p = rdy, i = 1; p; p = p->nxt)
		i++;	/* count procs */

	fprintf(tt, "settable()\n{	Trans *T, *settr();\n\n");
	fprintf(tt, "\ttrans = (Trans ***) emalloc(%d*sizeof(Trans **));\n", i);
	fprintf(tm, "	switch (t->forw) {\n");
	fprintf(tb, "	switch (t->back) {\n");
	fprintf(tm, "	default: uerror(\"bad forward move\");\n");
	fprintf(tb, "	default: uerror(\"bad return move\");\n");
	fprintf(tb, "	case  0: goto R999;	/* nothing to undo */\n");

	putproc(run->n, run->pc, 0, run->maxseq);	/* init */
	for (p = rdy, i = 1; p; p = p->nxt, i++)
		putproc(p->n, p->s->frst, i, p->s->last->seqno);
	fprintf(tm, "	}\n\n");
	fprintf(tb, "	}\n\n");
	fprintf(tt, "}\n");
	for (i = 0; Tail[i]; i++)
		fprintf(tt, "%s\n", Tail[i]);
	putrest();
}

putproc(n, e, i, j)
	Symbol *n;
	Element *e;
{
	fprintf(th, "\nshort nstates%d=%d;\t/* %s */\n", i, j+1, n->name);
	fprintf(tm, "\n		 /* PROC %s */\n", n->name);
	fprintf(tb, "\n		 /* PROC %s */\n", n->name);
	fprintf(tt, "\n	/* proctype %d: %s */\n", i, n->name);
	fprintf(tt, "\n	trans[%d] = (Trans **)", i);
	fprintf(tt, " emalloc(%d*sizeof(Trans *));\n\n", j+1);
	putseq(e, i);
	dumpsrc(j, i);
}

putseq(f, pid)
	Element *f;
{
	Element *e;
	SeqList *h;
	int n, a;

	for (e = f; e; e = e->nxt)
	{	if (e->status & DONE) continue;
		e->status |= DONE;
		if (e->n->nval) putsrc(e->n->nval, e->seqno);
		if (e->sub)
		{	fprintf(tt, "\tT = trans[%d][%d] = ", pid, e->seqno);
			fprintf(tt, "settr(%d,0,0,0);\n", e->status);
			for (h = e->sub; h; h = h->nxt)
			{	putskip(h->this->frst->seqno);
				a = huntstart(h->this->frst);
				if (h->nxt)
					fprintf(tt, "\tT = T->nxt\t= ");
				else
					fprintf(tt, "\t    T->nxt\t= ");
				fprintf(tt, "settr(%d,%d,0,0);\n",e->status, a);
			}
			for (h = e->sub; h; h = h->nxt)
				putseq(h->this->frst, pid);
		} else
		{	if (e->n && e->n->ntyp == ATOMIC)
			{	patch_atomic(e->n->seql->this);
				putskip(e->n->seql->this->frst->seqno);
				a = huntstart(e->n->seql->this->frst);
				fprintf(tt, "\tT = trans[%d][%d] = ",
						pid, e->seqno);
				fprintf(tt, "settr(%d,0,0,0);\n", ATOM);
				fprintf(tt, "\t    T->nxt\t= ");
				fprintf(tt, "settr(%d,%d,0,0);\n", ATOM, a);
				e->n->seql->this->last->nxt = e->nxt;

				putseq(e->n->seql->this->frst, pid);
				break;
			}
			if (e->n->ntyp == GOTO)
				a = huntlink(get_lab(e->n->nsym));
			else
				a = (e->nxt)?huntlink(e->nxt):0;
			fprintf(tt, "\ttrans[%d][%d]\t= ", pid, e->seqno);
			if (any_undo(e->n))
				fprintf(tt, "settr(%d,%d,%d,%d);\n",
					e->status, a, uniq, uniq);
			else
				fprintf(tt, "settr(%d,%d,%d,0);\n",
					e->status, a, uniq);
			fprintf(tm, "\tcase  %d: /* STATE ", uniq++);
			fprintf(tm, "%d - type %d - line %d */\n\t\t",
				e->seqno, e->n->ntyp, e->n->nval);
			if (e->n && e->n->ntyp != 'r')
				fprintf(tm, "IfNotBlocked\n\t\t");
			putstmnt(tm, e->n, e->seqno, pid);
			n = getweight(e->n->ntyp);
			fprintf(tm, ";\n\t\tm = %d; goto P999;\n", n);
			if (any_undo(e->n))
			{	fprintf(tb, "\tcase  %d: ", uniq-1);
				fprintf(tb, "/* STATE %d */\n\t\t", e->seqno);
				undostmnt(e->n, e->seqno, pid);
				fprintf(tb, ";\n\t\tgoto R999;\n", n);
			}
		}
	}
}

make_atomic(s)
	Sequence *s;
{
	walk_atomic(s->frst, s->last);
	s->last->status &= ~ATOM;
	s->last->status |= L_ATOM;
}

patch_atomic(s)
	Sequence *s;
{	/* catch goto's that break the chain */
	Element *f, *g;
	SeqList *h;
	for (f = s->frst; ; f = f->nxt)
	{	if (f->n && f->n->ntyp == GOTO)
		{	g = get_lab(f->n->nsym);
			if (!(g->status & ATOM))
			{	f->status &= ~ATOM;
				f->status |= L_ATOM;
			}
		} else
		for (h = f->sub; h; h = h->nxt)
			patch_atomic(h->this);
		if (f == s->last)
			break;
	}
}

walk_atomic(a, b)
	Element *a, *b;
{
	Element *f;
	SeqList *h;
	for (f = a; ; f = f->nxt)
	{	f->status |= ATOM;
		for (h = f->sub; h; h = h->nxt)
			walk_atomic(h->this->frst, h->this->last);
		if (f == b)
			break;
	}
}

#define cat0(x)   	putstmnt(fd,now->lft,m,pid); fprintf(fd," %s ", x); \
			putstmnt(fd,now->rgt,m,pid)
#define cat1(x)		fprintf(fd,"("); cat0(x); fprintf(fd,")")
#define cat2(x,y)  	fprintf(fd,x); putstmnt(fd,y,m,pid)
#define cat3(x,y,z)	fprintf(fd,x); putstmnt(fd,y,m,pid); fprintf(fd,z)
#define cat4(x,y,z,a)	fprintf(fd,x); putstmnt(fd,y,m,pid); fprintf(fd,z,a)

putstmnt(fd, now, m, pid)
	FILE *fd;
	Node *now;
{
	Node *v; Symbol *s;
	int i, j;

	if (!now)
		fprintf(fd, "0");
	else switch (now->ntyp) {
	case CONST:	fprintf(fd, "%d", now->nval); break;
	case '!':	cat3("!(", now->lft, ")"); break;
	case UMIN:	cat3("-(", now->lft, ")"); break;
	case '~':	cat3("~(", now->lft, ")"); break;

	case '/':	cat1("/");  break;
	case '*':	cat1("*");  break;
	case '-':	cat1("-");  break;
	case '+':	cat1("+");  break;
	case '%':	cat1("%"); break;
	case '<':	cat1("<");  break;
	case '>':	cat1(">");  break;
	case '&':	cat1("&");  break;
	case '|':	cat1("|");  break;
	case LE:	cat1("<="); break;
	case GE:	cat1(">="); break;
	case NE:	cat1("!="); break;
	case EQ:	cat1("=="); break;
	case OR:	cat1("||"); break;
	case AND:	cat1("&&"); break;
	case LSHIFT:	cat1("<<"); break;
	case RSHIFT:	cat1(">>"); break;

	case TIMEOUT:	fprintf(fd, "(trpt->tau)"); break;

	case RUN:	fprintf(fd, "addproc(%d", whichproc(now->nsym));
			for (v = now->lft; v; v = v->rgt)
			{	cat2(", ", v->lft);
			}
			fprintf(fd, ")");
			break;
	case CHAN:	fprintf(fd, "addqueue(%d)", qmake(now));
			if (now->nval == 0)
				u_sync++;
			else
				u_async++;
			break;
	case LEN:	cat3("q_sz(", now->lft, ")");
			break;
	case DEL:	cat3("delq(1, ", now->lft, ")");
			break;

	case 's':	fprintf(fd, "\n#if (SYNC>0 && ASYNC==0)\n\t\t");
			cat3("if (q_sz(", now->lft, ")) continue;\n");
			fprintf(fd, "#else\n\t\t");
			cat3("if (q_full(", now->lft, ")) continue;\n");
			fprintf(fd, "#endif\n");
			for (v = now->rgt, i = 0; v; v = v->rgt, i++)
			{	cat4("\t\tqsend(", now->lft, ", %d", i);
				cat4(", ", v->lft, ", %d);\n", (v->rgt)?0:1);
			}
			fprintf(fd, "#if SYNC\n#if ASYNC==0\n");
			cat2("\t\tboq = ", now->lft);
			fprintf(fd, ";\n#else\n");
			cat3("\t\tif (q_zero(", now->lft, ")) ");
			cat2("boq = ", now->lft);
			fprintf(fd, ";\n#endif\n#endif\n\t\t");
			break;
	case 'r':	fprintf(fd, "\n#if SYNC\n#if ASYNC==0\n");
			cat3("\t\tif (boq != ", now->lft, ") continue;\n");
			fprintf(fd, "#else\n");
			cat3("\t\tif (q_zero(", now->lft, "))\n\t\t");
			cat3("{	if (boq != ",  now->lft, ") continue;\n");
			fprintf(fd, "\t\t} else\n\t\t");
			fprintf(fd, "{	if (boq != -1) continue;\n\t\t");
			fprintf(fd, "}\n#endif\n#endif\n\t\t");
			cat3("if (q_sz(", now->lft, ") == 0) continue");
	/* test */	for (v = now->rgt, i=j=0; v; v = v->rgt, i++)
			{	if (v->lft->ntyp != CONST)
				{	j++; continue;
				}
				fprintf(fd, ";\n\t\t");
				cat3("if (", v->lft, " != ");
				cat4("qrecv(", now->lft, ", 0, %d, ", i);
				fprintf(fd, "0)) continue");
			}
			if (j > 1)
				fprintf(fd, ";\n\t\tsv_save()");
	/* set */	for (v = now->rgt, i = 0; v; v = v->rgt, i++)
			{	if (v->lft->ntyp == CONST && v->rgt)
					continue;
				fprintf(fd, ";\n\t\t");
				if (v->lft->ntyp != CONST)
				{	if (j == 1) {
				cat3("(trpt+1)->oval = ", v->lft, ";\n\t\t");
					}
					putstmnt(fd, v->lft, m, pid);
					fprintf(fd, " = ");
				}
				cat4("qrecv(", now->lft, ", 0, %d", i);
				fprintf(fd, ", %d)", (v->rgt)?0:1);
			}
			fprintf(fd, ";\n#if SYNC\n");
			cat3("\t\tif (q_zero(", now->lft, ")) boq = -1;\n");
			fprintf(fd, "#endif\n\t\t");
			break;

	case 'c':	cat3("if (!(", now->lft, "))\n");
			fprintf(fd, "\t\t\tcontinue");
			break;
	case '=':	cat3("(trpt+1)->oval = ", now->lft, ";\n\t\t");
			cat0("=");
			break;
	case PRINT:	fprintf(fd, "printf(%s", now->nsym->name);
			for (v = now->lft; v; v = v->rgt)
			{	cat2(", ", v->lft);
			}
			fprintf(fd, ")");
			break;
	case NAME:	s = now->nsym;
			if (s->context
			&& !s->type)	/* not declared locally */
				s = lookup(s->name); /* mk global */
			if (s->context)
				fprintf(fd, "((P%d *)this)->%s", pid, s->name);
			else
				fprintf(fd, "now.%s", s->name);
			if (s->nel != 1)
			{	cat3("[", now->lft, "]");
			}
			break;
	case ASSERT:	cat3("assert(", now->lft, ", ");
			cat3("\"", now->lft, "\\n\", II, tt, t)");
			break;
	case   '.':
	case BREAK:
	case  GOTO:	putskip(m);
			break;
	case   '@':	fprintf(fd, "if (!delproc(1, II)) continue");
			fprintf(th, "#define endstate%d	%d\n", pid, m);
			break;
	case   ':':	/* label */ break;
	default   :	printf("spin: bad node type %d (%c, %s)\n",
				now->ntyp, now->ntyp, now->nsym->name);
			exit(1);
	}
}

getweight(n)
{
	switch (n) {
	case TIMEOUT: return 1;	/* lowest priority */
	case 's':     return 2;
	case 'r':     return 4;
	}
	return 3;
}
