/***** spin: pangen1.c *****/

#include <stdio.h>
#include <math.h>
#include "spin.h"
#include "y.tab.h"
#include "pangen1.h"

extern FILE	*tc, *th;
extern Node	*Mtype;
extern ProcList	*rdy;
extern Queue	*qtab;
extern RunList	*run;
extern Symbol	*symtab[Nhash+1];
extern int	nqs, u_sync, u_async;
extern Element	*get_lab();

int Npars=0;
enum { INIV, PUTV };

putrest()
{
	genheader();
	genaddproc();
	genaddqueue();
	genunio();
	genother();
}

end_labs(s, i)
	Symbol *s;
{
	extern Label *labtab;
	Label *l;
	for (l = labtab; l; l = l->nxt)
	{	if (strncmp(l->s->name, "end", 3) != 0)
			continue;
		if (strcmp(l->s->context->name, s->name) == 0)
		fprintf(tc, "\tstopstate[%d][%d] = 1;\n", i, l->e->seqno);
	}
}

genother()
{	ProcList *p;
	Queue *q;
	int i;

	for (i = 0; Code0[i]; i++)
		fprintf(tc, "%s\n", Code0[i]);
	end_labs(run->n, 0);
	for (p = rdy, i = 1; p; p = p->nxt, i++)
	{	fprintf(tc, "\tretrans(%d, nstates%d);\n", i, i);
		fprintf(tc, "\tMaxbody = max(Maxbody, sizeof(P%d));\n", i);
		fprintf(tc, "\treached[%d] = reached%d;\n", i, i);
		fprintf(tc, "\tstopstate[%d] = (unsigned char *)", i);
		fprintf(tc, " emalloc(nstates%d);\n", i);
		fprintf(tc, "\tstopstate[%d][endstate%d] = 1;\n", i, i);
		end_labs(p->n, i);
	}
	fprintf(th, "unsigned char *reached[%d];\n", i);
	fprintf(th, "unsigned char *stopstate[%d];\n", i);

	for (q = qtab; q; q = q->nxt)	/* find largest queue template */
		fprintf(tc, "\tMaxbody = max(Maxbody, sizeof(Q%d));\n", q->qid);

	doglobal(INIV);
	for (i = 0; Code1[i]; i++)
		fprintf(tc, "%s\n", Code1[i]);

	fprintf(tc, "do_reach()\n");
	fprintf(tc, "{	r_ck(reached0, nstates0, 0, src_ln0);\n");
	for (p = rdy, i = 1; p; p = p->nxt, i++)
	{	fprintf(tc, "\tr_ck(reached%d, nstates%d, ", i, i);
		fprintf(tc, "%d, src_ln%d);\n", i, i, i);
	}
	fprintf(tc, "}\n\n");
}

dolocal(dowhat, p, s)
	Symbol *s;
{
	int i;
	Symbol *sp;
	char buf[64];

	for (i = 0; i <= Nhash; i++)
	for (sp = symtab[i]; sp; sp = sp->next)
		if (sp->context && sp->type != 0
		&&  strcmp(s->name, sp->context->name) == 0)
		{	sprintf(buf, "((P%d *)pptr(h))->", p);
			do_var(dowhat, buf, sp);
		}
}

doglobal(dowhat)
{	Symbol *sp;
	int i;

	for (i = 0; i <= Nhash; i++)
	for (sp = symtab[i]; sp; sp = sp->next)
		if (!sp->context && sp->type)
			do_var(dowhat, "now.", sp);
}

do_var(dowhat, s, sp)
	char *s;
	Symbol *sp;
{
	int i;

	switch(dowhat) {
	case PUTV:
		typ2c(sp);
		break;
	case INIV:
		if (sp->ini == 0)
			break;
		if (sp->nel == 1)
		{	fprintf(tc, "\t\t%s%s = %d;\n",
				s, sp->name, sp->ini);
			break;
		} /* else */
		for (i = 0; i < sp->nel; i++)
			fprintf(tc, "\t\t%s%s[%d] = %d;\n",
				s, sp->name, i, sp->ini);
		break;
	}
}

put_ptype(s, p, i, m0, m1)
	Symbol *s;
	Node *p;
{
	Node *fp, *fpt;
	int j;

	fprintf(tc, "	\"%s\",\n", s->name);
	fprintf(th, "typedef struct P%d {	/* %s */\n", i, s->name);
	fprintf(th, "	unsigned _t : %d;	/* proctype */\n",
		1 + (int) (log((double)(m1))/log((double)2)));
	fprintf(th, "	unsigned _p : %d;	/* state    */\n",
		1 + (int) (log((double)(m0))/log((double)2)));
	dolocal(PUTV, i, s);	/* includes pars */
	fprintf(th, "} P%d;\n", i);

	for (fp  = p, j = 0;  fp;  fp = fp->rgt)
	for (fpt = fp->lft;  fpt; fpt = fpt->rgt)
		j++;	/* count # of parameters */
	Npars = max(Npars, j);
}

genheader()
{	ProcList *p;
	int mst;	/* maximum number of states */
	int i, j;

	fprintf(th, "#define SYNC	%d\n", u_sync);
	fprintf(th, "#define ASYNC	%d\n", u_async);
	fprintf(tc, "char *procname[] = {\n");

	mst = run->maxseq;
	for (p = rdy, j = 1; p; p = p->nxt, j++)
		mst = max(p->s->last->seqno, mst);
	fprintf(th, "\n");

	put_ptype(run->n, (Node *) 0, 0, mst, j);
	for (p = rdy, i = 1; p; p = p->nxt, i++)
		put_ptype(p->n, p->p, i, mst, j);
	fprintf(tc, "};\n\n");
	fprintf(th, "\n");

	for (i = 0; Header0[i]; i++)
		fprintf(th, "%s\n", Header0[i]);
	doglobal(PUTV);
	for (i = 0; Header1[i]; i++)
		fprintf(th, "%s\n", Header1[i]);
}

put_pinit(s, p, ini, i)
	Symbol *s;
	Node *p;
{
	Node *fp, *fpt;
	int j;

	fprintf(tc, "\tcase %d:	/* %s */\n", i, s->name);
	fprintf(tc, "\t\t((P%d *)pptr(h))->_t = %d;\n", i, i);
	fprintf(tc, "\t\t((P%d *)pptr(h))->_p = %d; reached%d[%d]=1;\n",
		i, ini, i, ini);
	dolocal(INIV, i, s);
	for (fp  = p, j=0; fp; fp = fp->rgt)
	for (fpt = fp->lft; fpt; fpt = fpt->rgt, j++)
		fprintf(tc, "\t\t((P%d *)pptr(h))->%s = par%d;\n",
				i, fpt->nsym->name, j);
	fprintf(tc, "\t	break;\n");
}

genaddproc()
{	ProcList *p;
	int i, j;

	fprintf(tc, "addproc(n");
	for (i = 0; i < Npars; i++)
		fprintf(tc, ", par%d", i);
	fprintf(tc, ")\n{\n");

	for (j = 0; Addp0[j]; j++)
		fprintf(tc, "%s\n", Addp0[j]);
	for (p = rdy, i = 1; p; p = p->nxt, i++)
		fprintf(tc, "	case %d: j = sizeof(P%d); break;\n", i, i);
	for (j = 0; Addp1[j]; j++)
		fprintf(tc, "%s\n", Addp1[j]);

	put_pinit(run->n, (Node *) 0, huntlink(run->pc), 0);
	putskip(run->pc->seqno);
	for (p = rdy, i = 1; p; p = p->nxt, i++)
	{	put_pinit(p->n, p->p, huntlink(p->s->frst), i);
		putskip(p->s->frst->seqno);
	}
	fprintf(tc, "	}\n");
	fprintf(tc, "	return 1;\n");
	fprintf(tc, "}\n\n");
}

huntstart(f)
	Element *f;
{
	Element *e = f;

	if (e->n && !(e->status & L_ATOM))
	{	if (e->n->ntyp=='.' && e->nxt)
			e = e->nxt;
		else if (e->n->ntyp == ATOMIC)
			e->n->seql->this->last->nxt = e->nxt;
	}
	return e->seqno;
}

Element *
huntele(f)
	Element *f;
{
	Element *g, *e = f;
	int cnt; /* a precaution against loops */
	for (cnt=0; cnt < 10 && e->n; cnt++)
	{	switch (e->n->ntyp) {
		case GOTO:
			g = get_lab(e->n->nsym);
			break;
		case '.':
		case BREAK:
			if (!e->nxt) return e;
			g = e->nxt;
			break;
		case ATOMIC:
			e->n->seql->this->last->nxt = e->nxt;
			return e;
		default:
			return e;
		}
		if ((e->status & (ATOM|L_ATOM))
		&& !(g->status & (ATOM|L_ATOM)))
			return e;
		e = g;
	}
	return e;
}

huntlink(f)
	Element *f;
{
	return huntele(f)->seqno;
}

typ2c(sp)
	Symbol *sp;
{
	switch (sp->type) {
	case  1:
		if (sp->nel == 1)
		{	fprintf(th, "\tunsigned %s : 1", sp->name);
			break;
		} /* else fall through */
	case  8:
		fprintf(th, "\tunsigned char %s", sp->name);
		break;
	case 16:
		fprintf(th, "\tshort %s", sp->name);
		break;
	case 32:
		fprintf(th, "\tint %s", sp->name);
		break;
	default:
		fatal("variable %s undeclared", sp->name);
	}
	if (sp->nel != 1)
		fprintf(th, "[%d]", sp->nel);
	fprintf(th, ";\n");
}

genaddqueue()
{	int i, j;
	Queue *q;

	for (j = 0; Addq0[j]; j++)
		fprintf(tc, "%s\n", Addq0[j]);
	if (!qtab)
	{	fprintf(th, "typedef struct Q0 {\t/* template */\n");
		fprintf(th, "	unsigned char Qlen, _t;\n");
		fprintf(th, "} Q0;\n");
	} else
	for (q = qtab; q; q = q->nxt)
	{	fprintf(tc, "	case %d: j = sizeof(Q%d); break;\n",
				q->qid, q->qid);
		fprintf(th, "typedef struct Q%d {\n", q->qid);
		fprintf(th, "	unsigned char Qlen;	/* q_size */\n");
		fprintf(th, "	unsigned char _t;	/* q_type */\n");
		fprintf(th, "	struct {\n");
		for (j = 0; j < q->nflds; j++)
		fprintf(th, "\t\tunsigned fld%d : %d;\n",j,q->fld_width[j]);
		fprintf(th, "	} contents[%d];\n", max(1, q->nslots));
		fprintf(th, "} Q%d;\n", q->qid);
	}
	for (j = 0; Addq1[j]; j++)
		fprintf(tc, "%s\n", Addq1[j]);
	for (q = qtab; q; q = q->nxt)
	{	fprintf(tc, "	case %d:\tj = ((Q%d *)z)->Qlen;\n",
			q->qid, q->qid);
		fprintf(tc, "\t\tif (done)\n");
		fprintf(tc, "\t\t\t((Q%d *)z)->Qlen = j+1;\n", q->qid);
		if (q->nflds == 1)
		{	fprintf(tc, "\t\tif (fld == 0)\n");
			fprintf(tc, "\t\t\t((Q%d *)z)->", q->qid);
			fprintf(tc, "contents[j].fld0 = fldvar;\n");
		} else
		{	fprintf(tc, "\t\tswitch (fld) {\n");
			for (i = 0; i < q->nflds; i++)
			{	fprintf(tc, "\t\tcase %d:\n", i);
				fprintf(tc, "\t\t\t((Q%d *)z)->", q->qid);
				fprintf(tc, "contents[j].fld%d = fldvar;\n", i);
				fprintf(tc, "\t\t\tbreak;\n");
			}
			fprintf(tc, "\t\t}\n");
		}
		fprintf(tc, "		break;\n");
	}
	for (j = 0; Addq2[j]; j++)
		fprintf(tc, "%s\n", Addq2[j]);

	for (q = qtab; q; q = q->nxt)
	fprintf(tc, "	case %d: return %d;\n", q->qid, (q->nslots == 0));

	for (j = 0; Addq3[j]; j++)
		fprintf(tc, "%s\n", Addq3[j]);

	for (q = qtab; q; q = q->nxt)
	fprintf(tc, "	case %d: return (q_sz(from) == %d);\n",
			q->qid, max(1, q->nslots));

	for (j = 0; Addq4[j]; j++)
		fprintf(tc, "%s\n", Addq4[j]);

	for (q = qtab; q; q = q->nxt)
	{	fprintf(tc, "	case %d:", q->qid);
		if (q->nflds == 1)
		{	fprintf(tc, "\tif (fld == 0)\n");
			fprintf(tc, "\t\t\tr = ((Q%d *)z)->", q->qid);
			fprintf(tc, "contents[slot].fld0;\n");
		} else
		{	fprintf(tc, "\tswitch (fld) {\n");
			for (i = 0; i < q->nflds; i++)
			{	fprintf(tc, "\t\tcase %d:\n", i);
				fprintf(tc, "\t\t\tr = ((Q%d *)z)->", q->qid);
				fprintf(tc, "contents[slot].fld%d;\n", i);
				fprintf(tc, "\t\t\tbreak;\n");
			}
			fprintf(tc, "\t\t}\n");
		}
		fprintf(tc, "\t\tif (done)\n");
		fprintf(tc, "\t\t{	j = ((Q%d *)z)->Qlen;\n", q->qid);
		fprintf(tc, "\t\t	((Q%d *)z)->Qlen = --j;\n",q->qid);
		fprintf(tc, "\t\t	for (k=0; k<j; k++)\n",q->qid);
		fprintf(tc, "\t\t	{");
		for (i = 0; i < q->nflds; i++)
		{	fprintf(tc, "\t((Q%d *)z)->contents[k].fld%d =\n",
					q->qid, i);
			fprintf(tc, "\t\t\t\t\t((Q%d *)z)->", q->qid);
			fprintf(tc, "contents[k+1].fld%d;\n\t\t\t", i);
		}
		fprintf(tc, "}\n");
		for (i = 0; i < q->nflds; i++)
		fprintf(tc, "\t\t\t((Q%d *)z)->contents[j].fld%d = 0;\n",
			q->qid, i);
		fprintf(tc, "\t\t}\n");
		fprintf(tc, "\t\tbreak;\n");
	}
	for (j = 0; Addq5[j]; j++)
		fprintf(tc, "%s\n", Addq5[j]);
}
