/***** spin: mesg.c *****/

#include "spin.h"
#include "y.tab.h"

extern int lineno, verbose;
Queue *qtab = (Queue *) 0;
int nqs = 0;

qmake(n)
	Node *n;
{
	Queue *q = (Queue *) emalloc(sizeof(Queue));
	Node *m;
	int i;

	q->nslots = n->nval;
	q->qid = nqs;
	for (m = n->rgt; m; m = m->rgt)
		q->nflds++;
	i = max(1, q->nslots);	/* 0-slot qs get 1 slot minimum */

	q->contents  = (int *) emalloc(q->nflds*i*sizeof(int));
	q->fld_width = (short *) emalloc(q->nflds*sizeof(short));
	for (m = n->rgt, i = 0; m; m = m->rgt)
		q->fld_width[i++] = m->ntyp;
	q->nxt = qtab;
	qtab = q;

	return nqs++;
}

qdel(n)
	Node *n;
{
	Queue *q, *lq = (Queue *) 0;
	int whichq = eval(n->lft);

	for (q = qtab; q; lq = q, q = q->nxt)
		if (q->qid == whichq)
		{	if (lq)
				lq->nxt = q->nxt;
			else
				qtab = q->nxt;
			if (whichq == nqs-1)
				nqs--;
			return 1;
		}
	fatal("del cannot find queue", (char *)0);
}

qlen(n)
	Node *n;
{
	Queue *q;
	int whichq = eval(n->lft);

	for (q = qtab; q; q = q->nxt)
		if (q->qid == whichq)
			return q->qlen;
	return 0;	/* no such queue */
}

q_is_sync(n)
	Node *n;
{
	Queue *q;
	int whichq = eval(n->lft);

	for (q = qtab; q; q = q->nxt)
		if (q->qid == whichq)
			return (q->nslots == 0);
	return 0;	/* no such queue */
}

qsend(n)
	Node *n;
{
	Queue *q;
	int whichq = eval(n->lft);

	for (q = qtab; q; q = q->nxt)
		if (q->qid == whichq)
		return (q->nslots>0)?a_snd(q,n):s_snd(q,n);
	return 0;	/* no such queue */
}

qrecv(n)
	Node *n;
{
	Queue *q;
	int whichq = eval(n->lft);

	for (q = qtab; q; q = q->nxt)
		if (q->qid == whichq)
			return a_rcv(q,n);
	return 0;	/* no such queue */
}

a_snd(q, n)
	Queue *q;
	Node *n;
{
	Node *m;
	int i = q->qlen*q->nflds;	/* q offset */
	int j = 0;			/* q field# */

	if (q->qlen >= q->nslots)
		return 0;	/* q is full */

	for (m = n->rgt; m && j < q->nflds; m = m->rgt, j++)
	{	q->contents[i+j] = cast_val(q->fld_width[j], eval(m->lft));
		if (verbose&16)
			sr_talk(n, eval(m->lft), "Send", "->", j);
	}
	q->qlen++;
	return 1;
}

a_rcv(q, n)
	Queue *q;
	Node *n;
{
	Node *m;
	int j, k;

	if (q->qlen == 0) return 0;	/* q is empty */

	for (m = n->rgt, j=0; m && j<q->nflds; m = m->rgt, j++)
	{
		if (m->lft->ntyp == CONST)
		{	if (q->contents[j] != m->lft->nval)
				return 0;	/* no match */
		} else if (m->lft->ntyp != NAME)
			fatal("bad arg in receive", (char *)0);
	}
	for (m = n->rgt, j=0; j<q->nflds; m = (m)?m->rgt:m, j++)
	{	if (m && (verbose&8))
			sr_talk(n, q->contents[j], "Recv", "<-", j);
		if (m && m->lft->ntyp == NAME)
			setval(m->lft, q->contents[j]);
		for (k = 0; k < q->qlen-1; k++)
			q->contents[k*q->nflds+j] =
			q->contents[(k+1)*q->nflds+j];
	}
	q->qlen--;
	return 1;
}

s_snd(q, n)
	Queue *q;
	Node *n;
{
	Node *m;
	int j = 0;	/* q field# */

	for (m = n->rgt; m && j < q->nflds; m = m->rgt, j++)
	q->contents[j] = cast_val(q->fld_width[j], eval(m->lft));

	q->qlen = 1;
	if (complete_rendez())
		return 1;
	q->qlen = 0;
	return 0;
}

sr_talk(n, v, s, a, j)
	Node *n;
	char *s, *a;
{
	whoruns();
	printf("line %3d, %s[%d] ", n->nval, s, j);
	sr_mesg(v, j);
	printf("\t%s\t", a);
	if (n->lft->ntyp == NAME)
		printf("%d=%s[%d]\n", eval(n->lft), n->lft->nsym->name, eval(n->lft->lft));
	else
		printf("?\n");
}

sr_mesg(v, j)
{	extern Node *Mtype;
	int cnt = 1;
	Node *n;
	for (n = Mtype; n && j == 0; n = n->rgt, cnt++)
		if (cnt == v)
		{	printf(" %s", n->lft->nsym->name);
			return;
		}
	printf(" %d", v);
}
