/***** spin: main.c *****/

#include <stdio.h>
#include "spin.h"
#include "y.tab.h"

extern FILE *yyin;
char filename[256];
int verbose=0;
int analyze=0;
int s_trail=0;

main(argc, argv)
	char *argv[];
{
	int T = (int) time((long *)0);

	while (argc > 1 && argv[1][0] == '-')
	{	switch (argv[1][1]) {
		case 'a': analyze  =  1; break;
		case 'g': verbose +=  1; break;
		case 'l': verbose +=  2; break;
		case 'n': T = atoi(&argv[1][2]); break;
		case 'p': verbose +=  4; break;
		case 'r': verbose +=  8; break;
		case 's': verbose += 16; break;
		case 't': s_trail  =  1; break;
		default : printf("usage: spin -[aglprst] [-nN] file\n");
			  printf("\t-a produce an analyzer\n");
			  printf("\t-g print all global variables\n");
			  printf("\t-l print all local variables\n");
			  printf("\t-nN seed random number generator\n");
			  printf("\t-p print all statements\n");
			  printf("\t-r print receive events\n");
			  printf("\t-s print send events\n");
			  printf("\t-t follow a simulation trail\n");
			  exit(1);
		}
		argc--, argv++;
	}
	if (argc > 1)
	{	char outfile[17], cmd[64];
		strcpy(filename, argv[1]);
		(void) mktemp(strcpy(outfile, "/tmp/spin.XXXXXX"));
		sprintf(cmd, "/lib/cpp %s > %s", argv[1], outfile);
		if (system(cmd))
		{	unlink(outfile);
			exit(1);
		} else if (!(yyin = fopen(outfile, "r")))
		{	printf("cannot open %s\n", outfile);
			exit(1);
		}
		unlink(outfile);
	} else
		strcpy(filename, "<stdin>");
	srand(T);
	yyparse();
	exit(0);
}

yywrap()	/* a dummy routine */
{
	return 1;
}

yyerror(s1, s2)	/* called by yacc on syntax errors */
	char *s1, *s2;
{
	extern int lineno;
	char buf[128];
	sprintf(buf, s1, s2);
	printf("spin: %s line %d: %s\n", filename, lineno, buf);
}

fatal(s1, s2)
	char *s1, *s2;
{
	yyerror(s1, s2);
	fflush(stdout);
	exit(1);
}

char *
emalloc(n)
{	extern char *malloc();	/* library functions */
	extern char *memset();

	char *tmp = malloc(n);
	if (!tmp)
		fatal("not enough memory", (char *)0);
	(void) memset(tmp, 0, n);
	return tmp;
}

Node *
nn(s, v, t, l, r)
	Symbol *s;
	Node *l, *r;
{
	Node *n = (Node *) emalloc(sizeof(Node));
	n->nsym = s;
	n->nval = v;
	n->ntyp = t;
	n->lft  = l;
	n->rgt  = r;
	return n;
}
