/***** spin: flow.c *****/

#include "spin.h"
#include "y.tab.h"

Label	*labtab = (Label *) 0;
Lbreak	*breakstack = (Lbreak *) 0;
SeqList	*cur_s = (SeqList *) 0;
int	Elcnt, break_id=0;

open_seq(top)
{	SeqList *t;
	Sequence *s = (Sequence *) emalloc(sizeof(Sequence));

	t = seqlist(s, cur_s);
	cur_s = t;
	if (top) Elcnt = 1;
}

Sequence *
close_seq()
{	Sequence *s = cur_s->this;

	cur_s = cur_s->nxt;
	return s;
}

SeqList *
seqlist(s, r)
	Sequence *s;
	SeqList *r;
{
	SeqList *t = (SeqList *) emalloc(sizeof(SeqList));
	t->this = s;
	t->nxt = r;
	return t;
}

Element *
new_el(n)
	Node *n;
{
	Element *m, *if_seq();

	if (n && (n->ntyp == IF || n->ntyp == DO))
		return if_seq(n->seql, n->ntyp, n->nval);
	m = (Element *) emalloc(sizeof(Element));
	m->n = n;
	m->seqno = Elcnt++;
	return m;
}

Element *
if_seq(s, tok, lnno)
	SeqList *s;
{
	Element *e = new_el((Node *) 0);
	Element *t = new_el(nn(0,lnno,'.',0,0)); /* target */
	SeqList *z;

	e->n = nn(0,lnno,tok,0,0);
	e->sub = s;
	for (z = s; z; z = z->nxt)
		add_el(t, z->this);
	if (tok == DO)
	{	add_el(t, cur_s->this);
		t = new_el(nn(0,lnno,BREAK,0,0));
		set_lab(break_dest(), t);
		breakstack = breakstack->nxt;	/* pop stack */
	}
	add_el(e, cur_s->this);
	add_el(t, cur_s->this);
	return e;	/* destination node for label */
}

add_el(e, s)
	Element *e;
	Sequence *s;
{
	if (!s->frst)
		s->frst = e;
	else
		s->last->nxt = e;
	s->last = e;
}

add_seq(n)
	Node *n;
{
	Element *e;
	if (!n) return;
	if (n->ntyp == ':')
	{	e = new_el(n->lft);
		set_lab(n->nsym, e);
		n = n->lft;
	} else
		e = new_el(n);
	if (n->ntyp != IF && n->ntyp != DO)
		add_el(e, cur_s->this);
}

set_lab(s, e)
	Symbol *s;
	Element *e;
{
	Label *l;
	if (!s) return;
	l = (Label *) emalloc(sizeof(Label));
	l->s = s;
	l->e = e;
	l->nxt = labtab;
	labtab = l;
}

Element *
get_lab(s)
	Symbol *s;
{
	Label *l;
	for (l = labtab; l; l = l->nxt)
		if (s == l->s)
			return (l->e);
	fatal("undefined label %s", s->name);
}

pushbreak()
{	Lbreak *r = (Lbreak *) emalloc(sizeof(Lbreak));
	Symbol *l;
	char buf[32];

	sprintf(buf, ":b%d", break_id++);
	l = lookup(buf);
	r->l = l;
	r->nxt = breakstack;
	breakstack = r;
}

Symbol *
break_dest()
{	if (!breakstack)
		fatal("illegal break statement", (char *)0);
	return breakstack->l;
}
